/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.file;

import java.io.File;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.file.FrameFile;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.TemporaryFolder;

public class FrameFileWriterTest
extends InitializedNullHandlingTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void test_abort_afterAllFrames() throws IOException {
        Sequence<Frame> frames = FrameSequenceBuilder.fromCursorFactory((CursorFactory)new IncrementalIndexCursorFactory(TestIndex.getIncrementalTestIndex())).allocator((MemoryAllocator)ArenaMemoryAllocator.createOnHeap((int)1000000)).frameType(FrameType.ROW_BASED).frames();
        File file = this.temporaryFolder.newFile();
        FrameFileWriter fileWriter = FrameFileWriter.open((WritableByteChannel)Files.newByteChannel(file.toPath(), StandardOpenOption.WRITE), null, (ByteTracker)ByteTracker.unboundedTracker());
        frames.forEach(frame -> {
            try {
                fileWriter.writeFrame(frame, -1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        fileWriter.abort();
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> FrameFile.open((File)file, null, (FrameFile.Flag[])new FrameFile.Flag[0]));
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Corrupt or truncated file[")));
    }
}

