/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.error;

import java.util.ArrayList;
import org.apache.druid.error.DruidException;
import org.apache.druid.matchers.DruidMatchers;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;

public class DruidExceptionMatcher
extends DiagnosingMatcher<Throwable> {
    private final AllOf<DruidException> delegate;
    private final ArrayList<Matcher<? super DruidException>> matcherList = new ArrayList();

    public static DruidExceptionMatcher invalidInput() {
        return new DruidExceptionMatcher(DruidException.Persona.USER, DruidException.Category.INVALID_INPUT, "invalidInput");
    }

    public static DruidExceptionMatcher notFound() {
        return new DruidExceptionMatcher(DruidException.Persona.USER, DruidException.Category.NOT_FOUND, "notFound");
    }

    public static DruidExceptionMatcher invalidSqlInput() {
        return DruidExceptionMatcher.invalidInput().expectContext("sourceType", "sql");
    }

    public static DruidExceptionMatcher internalServerError() {
        return new DruidExceptionMatcher(DruidException.Persona.OPERATOR, DruidException.Category.RUNTIME_FAILURE, "internalServerError");
    }

    public static DruidExceptionMatcher defensive() {
        return new DruidExceptionMatcher(DruidException.Persona.DEVELOPER, DruidException.Category.DEFENSIVE, "general");
    }

    public DruidExceptionMatcher(DruidException.Persona targetPersona, DruidException.Category category, String errorCode) {
        this.matcherList.add((Matcher<? super DruidException>)DruidMatchers.fn("targetPersona", DruidException::getTargetPersona, Matchers.is((Object)targetPersona)));
        this.matcherList.add((Matcher<? super DruidException>)DruidMatchers.fn("category", DruidException::getCategory, Matchers.is((Object)category)));
        this.matcherList.add((Matcher<? super DruidException>)DruidMatchers.fn("errorCode", DruidException::getErrorCode, Matchers.is((Object)errorCode)));
        this.delegate = new AllOf(this.matcherList);
    }

    public DruidExceptionMatcher expectContext(String key, String value) {
        this.matcherList.add(0, (Matcher<? super DruidException>)DruidMatchers.fn("context", DruidException::getContext, Matchers.hasEntry((Object)key, (Object)value)));
        return this;
    }

    public DruidExceptionMatcher expectMessageIs(String s) {
        return this.expectMessage((Matcher<String>)Matchers.equalTo((Object)s));
    }

    public DruidExceptionMatcher expectMessageContains(String contains) {
        return this.expectMessage((Matcher<String>)Matchers.containsString((String)contains));
    }

    public DruidExceptionMatcher expectMessage(Matcher<String> messageMatcher) {
        this.matcherList.add(0, (Matcher<? super DruidException>)DruidMatchers.fn("message", Throwable::getMessage, messageMatcher));
        return this;
    }

    public DruidExceptionMatcher expectException(Matcher<Throwable> causeMatcher) {
        this.matcherList.add(0, (Matcher<? super DruidException>)DruidMatchers.fn("cause", Throwable::getCause, causeMatcher));
        return this;
    }

    protected boolean matches(Object item, Description mismatchDescription) {
        return this.delegate.matches(item, mismatchDescription);
    }

    public void describeTo(Description description) {
        this.delegate.describeTo(description);
    }

    public <T> void assertThrowsAndMatches(ThrowingSupplier fn) {
        boolean thrown = false;
        try {
            fn.get();
        }
        catch (Throwable e) {
            if (e instanceof DruidException) {
                MatcherAssert.assertThat((Object)e, (Matcher)this);
                thrown = true;
            }
            throw new RuntimeException(e);
        }
        MatcherAssert.assertThat((Object)thrown, (Matcher)Matchers.is((Object)true));
    }

    public static interface ThrowingSupplier {
        public void get();
    }
}

