/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HandlingInputRowIteratorTest {

    public static class PresentRowTest {
        private static final InputRow INPUT_ROW1 = (InputRow)Mockito.mock(InputRow.class);
        private static final InputRow INPUT_ROW2 = (InputRow)Mockito.mock(InputRow.class);
        private static final List<InputRow> INPUT_ROWS = Arrays.asList(INPUT_ROW1, INPUT_ROW2);
        private HandlingInputRowIterator.InputRowHandler successfulHandler;
        private HandlingInputRowIterator.InputRowHandler unsuccessfulHandler;

        @Before
        public void setup() {
            this.successfulHandler = (HandlingInputRowIterator.InputRowHandler)Mockito.mock(HandlingInputRowIterator.InputRowHandler.class);
            Mockito.when((Object)this.successfulHandler.handle((InputRow)ArgumentMatchers.any(InputRow.class))).thenReturn((Object)true);
            this.unsuccessfulHandler = (HandlingInputRowIterator.InputRowHandler)Mockito.mock(HandlingInputRowIterator.InputRowHandler.class);
            Mockito.when((Object)this.unsuccessfulHandler.handle((InputRow)ArgumentMatchers.any(InputRow.class))).thenReturn((Object)false);
        }

        @Test
        public void hasNext() {
            HandlingInputRowIterator target = PresentRowTest.createInputRowIterator(this.unsuccessfulHandler, this.unsuccessfulHandler);
            Assert.assertTrue((boolean)target.hasNext());
            ((HandlingInputRowIterator.InputRowHandler)Mockito.verify((Object)this.unsuccessfulHandler, (VerificationMode)Mockito.never())).handle(INPUT_ROW1);
        }

        @Test
        public void yieldsNextIfUnhandled() {
            HandlingInputRowIterator target = PresentRowTest.createInputRowIterator(this.unsuccessfulHandler, this.unsuccessfulHandler);
            Assert.assertEquals((Object)INPUT_ROW1, (Object)target.next());
            ((HandlingInputRowIterator.InputRowHandler)Mockito.verify((Object)this.unsuccessfulHandler, (VerificationMode)Mockito.times((int)2))).handle(INPUT_ROW1);
        }

        @Test
        public void yieldsNullIfHandledByFirst() {
            HandlingInputRowIterator target = PresentRowTest.createInputRowIterator(this.successfulHandler, this.unsuccessfulHandler);
            Assert.assertNull((Object)target.next());
            ((HandlingInputRowIterator.InputRowHandler)Mockito.verify((Object)this.successfulHandler, (VerificationMode)Mockito.times((int)1))).handle(INPUT_ROW1);
            ((HandlingInputRowIterator.InputRowHandler)Mockito.verify((Object)this.unsuccessfulHandler, (VerificationMode)Mockito.never())).handle(INPUT_ROW1);
        }

        @Test
        public void yieldsNullIfHandledBySecond() {
            HandlingInputRowIterator target = PresentRowTest.createInputRowIterator(this.unsuccessfulHandler, this.successfulHandler);
            Assert.assertNull((Object)target.next());
            ((HandlingInputRowIterator.InputRowHandler)Mockito.verify((Object)this.unsuccessfulHandler, (VerificationMode)Mockito.times((int)1))).handle(INPUT_ROW1);
            ((HandlingInputRowIterator.InputRowHandler)Mockito.verify((Object)this.successfulHandler, (VerificationMode)Mockito.times((int)1))).handle(INPUT_ROW1);
        }

        private static HandlingInputRowIterator createInputRowIterator(HandlingInputRowIterator.InputRowHandler firstHandler, HandlingInputRowIterator.InputRowHandler secondHandler) {
            CloseableIterator iterator = CloseableIterators.withEmptyBaggage((Iterator)new Iterator<InputRow>(){
                private final Iterator<InputRow> delegate = INPUT_ROWS.iterator();

                @Override
                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                @Override
                @Nullable
                public InputRow next() {
                    return this.delegate.next();
                }
            });
            return new HandlingInputRowIterator(iterator, Arrays.asList(firstHandler, secondHandler));
        }
    }

    public static class AbsentRowTest {
        private static final CloseableIterator<InputRow> EMPTY_ITERATOR = CloseableIterators.withEmptyBaggage((Iterator)new Iterator<InputRow>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            @Nullable
            public InputRow next() {
                throw new NoSuchElementException();
            }
        });
        private HandlingInputRowIterator target;

        @Before
        public void setup() {
            this.target = new HandlingInputRowIterator(EMPTY_ITERATOR, Collections.emptyList());
        }

        @Test
        public void doesNotHaveNext() {
            Assert.assertFalse((boolean)this.target.hasNext());
        }

        @Test(expected=NoSuchElementException.class)
        public void throwsExceptionWhenYieldingNext() {
            this.target.next();
        }
    }
}

