/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.junit.Assert;
import org.junit.Test;

public class JacksonUtilsTest {
    @Test
    public void testWriteObjectUsingSerializerProvider() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectMapper objectMapper = new ObjectMapper();
        SerializerProvider serializers = objectMapper.getSerializerProviderInstance();
        JsonGenerator jg = objectMapper.getFactory().createGenerator((OutputStream)baos);
        jg.writeStartArray();
        JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)new SerializableClass(2));
        JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, null);
        JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)new SerializableClass(3));
        jg.writeEndArray();
        jg.close();
        List deserializedValues = (List)objectMapper.readValue(baos.toByteArray(), (TypeReference)new TypeReference<List<SerializableClass>>(){});
        Assert.assertEquals(Arrays.asList(new SerializableClass(2), null, new SerializableClass(3)), (Object)deserializedValues);
    }

    @Test
    public void testWritePrimitivesUsingSerializerProvider() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectMapper objectMapper = new ObjectMapper();
        SerializerProvider serializers = objectMapper.getSerializerProviderInstance();
        JsonGenerator jg = objectMapper.getFactory().createGenerator((OutputStream)baos);
        jg.writeStartArray();
        JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)"foo");
        JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, null);
        JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)1.23);
        jg.writeEndArray();
        jg.close();
        List deserializedValues = (List)objectMapper.readValue(baos.toByteArray(), (TypeReference)new TypeReference<List<Object>>(){});
        Assert.assertEquals(Arrays.asList("foo", null, 1.23), (Object)deserializedValues);
    }

    @Test
    public void testReadValue() {
        ObjectMapper objectMapper = new ObjectMapper();
        byte[] bytes = StringUtils.toUtf8((String)"{\"foo\":\"bar\"}");
        ImmutableMap expected = ImmutableMap.of((Object)"foo", (Object)"bar");
        Assert.assertEquals((String)"readValue(Class)", (Object)expected, (Object)JacksonUtils.readValue((ObjectMapper)objectMapper, (byte[])bytes, Map.class));
        Assert.assertEquals((String)"readValue(JavaType)", (Object)expected, (Object)JacksonUtils.readValue((ObjectMapper)objectMapper, (byte[])bytes, (JavaType)objectMapper.constructType(Map.class)));
        Assert.assertEquals((String)"readValue(TypeReference)", (Object)expected, (Object)JacksonUtils.readValue((ObjectMapper)objectMapper, (byte[])bytes, (TypeReference)JacksonUtils.TYPE_REFERENCE_MAP_STRING_STRING));
    }

    public static class SerializableClass {
        private final int value;

        @JsonCreator
        public SerializableClass(@JsonProperty(value="value") int value) {
            this.value = value;
        }

        @JsonProperty
        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializableClass that = (SerializableClass)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "SerializableClass{value=" + this.value + "}";
        }
    }
}

