/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.ConfigSerde;
import org.apache.druid.common.config.JacksonConfigManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class JacksonConfigManagerTest {
    @Mock
    private ConfigManager mockConfigManager;
    @Mock
    private AuditManager mockAuditManager;
    private JacksonConfigManager jacksonConfigManager;

    @Before
    public void setUp() {
        this.jacksonConfigManager = new JacksonConfigManager(this.mockConfigManager, new ObjectMapper(), this.mockAuditManager);
    }

    @Test
    public void testSet() {
        String key = "key";
        TestConfig val = new TestConfig("version", "string", 3);
        AuditInfo auditInfo = new AuditInfo("testAuthor", "testIdentity", "testComment", "127.0.0.1");
        this.jacksonConfigManager.set(key, (Object)val, auditInfo);
        ArgumentCaptor auditCapture = ArgumentCaptor.forClass(AuditEntry.class);
        ((AuditManager)Mockito.verify((Object)this.mockAuditManager)).doAudit((AuditEntry)auditCapture.capture());
        Assert.assertNotNull((Object)auditCapture.getValue());
    }

    @Test
    public void testConvertByteToConfigWithNullConfigInByte() {
        TestConfig defaultExpected = new TestConfig("version", null, 3);
        TestConfig actual = (TestConfig)this.jacksonConfigManager.convertByteToConfig(null, TestConfig.class, (Object)defaultExpected);
        Assert.assertEquals((Object)defaultExpected, (Object)actual);
    }

    @Test
    public void testConvertByteToConfigWithNonNullConfigInByte() {
        ConfigSerde configConfigSerdeFromTypeReference = this.jacksonConfigManager.create((TypeReference)new TypeReference<TestConfig>(){}, null);
        TestConfig defaultConfig = new TestConfig("version", null, 3);
        TestConfig expectedConfig = new TestConfig("version2", null, 5);
        byte[] expectedConfigInByte = configConfigSerdeFromTypeReference.serialize((Object)expectedConfig);
        TestConfig actual = (TestConfig)this.jacksonConfigManager.convertByteToConfig(expectedConfigInByte, TestConfig.class, (Object)defaultConfig);
        Assert.assertEquals((Object)expectedConfig, (Object)actual);
    }

    static class TestConfig {
        private final String version;
        private final String settingString;
        private final int settingInt;

        @JsonCreator
        public TestConfig(@JsonProperty(value="version") String version, @JsonProperty(value="settingString") String settingString, @JsonProperty(value="settingInt") int settingInt) {
            this.version = version;
            this.settingString = settingString;
            this.settingInt = settingInt;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSettingString() {
            return this.settingString;
        }

        public int getSettingInt() {
            return this.settingInt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestConfig config = (TestConfig)o;
            return this.settingInt == config.settingInt && Objects.equals(this.version, config.version) && Objects.equals(this.settingString, config.settingString);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.settingString, this.settingInt);
        }
    }
}

