/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.fastutil;

import org.apache.druid.collections.fastutil.DruidIntList;
import org.junit.Assert;
import org.junit.Test;

public class DruidIntListTest {
    @Test
    public void addArray() {
        DruidIntList intList = new DruidIntList(2);
        int[] arrrrr = new int[]{0, 1, 2, 3};
        intList.addArray(arrrrr);
        this.expectEquals(intList, arrrrr);
    }

    @Test
    public void fill() {
        DruidIntList intList = new DruidIntList(2);
        intList.fill(2, 4);
        this.expectEquals(intList, new int[]{2, 2, 2, 2});
    }

    @Test
    public void fillWithRepeat() {
        DruidIntList intList = new DruidIntList(2);
        intList.fillWithRepeat(new int[]{0, 1}, 2);
        this.expectEquals(intList, new int[]{0, 1, 0, 1});
    }

    @Test
    public void fillRuns() {
        DruidIntList intList = new DruidIntList(2);
        intList.fillRuns(new int[]{0, 1}, 2, 2);
        this.expectEquals(intList, new int[]{0, 0, 1, 1, 0, 0, 1, 1});
    }

    @Test
    public void fillRunsRunLengthOne() {
        DruidIntList intList = new DruidIntList(2);
        intList.fillRuns(new int[]{0, 1}, 1, 2);
        this.expectEquals(intList, new int[]{0, 1, 0, 1});
    }

    @Test
    public void resetToSize() {
        DruidIntList intList = new DruidIntList(2);
        intList.fill(2, 4);
        Assert.assertEquals((long)4L, (long)intList.size());
        intList.resetToSize(4);
        Assert.assertEquals((long)0L, (long)intList.size());
    }

    private void expectEquals(DruidIntList intList, int[] expected) {
        Assert.assertEquals((long)expected.length, (long)intList.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)String.valueOf(i), (long)expected[i], (long)intList.getInt(i));
        }
    }
}

