/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.collections.SerializablePair;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairTest {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @Test
    public void testBytesSerde() throws IOException {
        SerializablePair pair = new SerializablePair((Object)5L, (Object)9L);
        byte[] bytes = JSON_MAPPER.writeValueAsBytes((Object)pair);
        SerializablePair deserializedPair = (SerializablePair)JSON_MAPPER.readValue(bytes, SerializablePair.class);
        Assert.assertEquals((Object)pair.lhs, (Object)((Number)deserializedPair.lhs).longValue());
        Assert.assertEquals((Object)pair.rhs, (Object)((Number)deserializedPair.rhs).longValue());
    }

    @Test
    public void testStringSerde() throws IOException {
        SerializablePair pair = new SerializablePair((Object)5L, (Object)9L);
        String str = JSON_MAPPER.writeValueAsString((Object)pair);
        SerializablePair deserializedPair = (SerializablePair)JSON_MAPPER.readValue(str, SerializablePair.class);
        Assert.assertEquals((Object)pair.lhs, (Object)((Number)deserializedPair.lhs).longValue());
        Assert.assertEquals((Object)pair.rhs, (Object)((Number)deserializedPair.rhs).longValue());
    }
}

