/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.segment.BypassRestrictedSegment;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.RestrictedCursorFactory;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.SimpleTopNOptimizationInspector;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.segment.WrappedTimeBoundaryInspector;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class RestrictedSegment
implements SegmentReference {
    protected final SegmentReference delegate;
    protected final Policy policy;

    public RestrictedSegment(SegmentReference delegate, Policy policy) {
        this.delegate = delegate;
        this.policy = policy;
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        return this.delegate.acquireReferences();
    }

    @Override
    public SegmentId getId() {
        return this.delegate.getId();
    }

    @Override
    public Interval getDataInterval() {
        return this.delegate.getDataInterval();
    }

    @Override
    public CursorFactory asCursorFactory() {
        return new RestrictedCursorFactory(this.delegate.asCursorFactory(), this.policy);
    }

    @Override
    @Nullable
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    @Nullable
    public <T> T as(@Nonnull Class<T> clazz) {
        if (CursorFactory.class.equals(clazz)) {
            return (T)this.asCursorFactory();
        }
        if (QueryableIndex.class.equals(clazz)) {
            return null;
        }
        if (TimeBoundaryInspector.class.equals(clazz)) {
            return (T)WrappedTimeBoundaryInspector.create(this.delegate.as(TimeBoundaryInspector.class));
        }
        if (TopNOptimizationInspector.class.equals(clazz)) {
            return (T)new SimpleTopNOptimizationInspector(this.policy instanceof NoRestrictionPolicy);
        }
        if (BypassRestrictedSegment.class.equals(clazz)) {
            return (T)new BypassRestrictedSegment(this.delegate, this.policy);
        }
        if (this.policy instanceof NoRestrictionPolicy) {
            return this.delegate.as(clazz);
        }
        return null;
    }

    @Override
    public boolean isTombstone() {
        return this.delegate.isTombstone();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public String asString() {
        return this.delegate.asString();
    }
}

