/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.filter.Filters;

public class FilteredCursorFactory
implements CursorFactory {
    private final CursorFactory delegate;
    @Nullable
    private final DimFilter filter;

    public FilteredCursorFactory(CursorFactory delegate, @Nullable DimFilter filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public CursorHolder makeCursorHolder(CursorBuildSpec spec) {
        Set<String> physicalColumns;
        Filter newFilter;
        CursorBuildSpec.CursorBuildSpecBuilder buildSpecBuilder = CursorBuildSpec.builder(spec);
        if (this.filter != null) {
            newFilter = spec.getFilter() == null ? this.filter.toFilter() : Filters.and(Arrays.asList(spec.getFilter(), this.filter.toFilter()));
            if (spec.getPhysicalColumns() != null) {
                physicalColumns = new HashSet<String>(spec.getPhysicalColumns());
                for (String column : this.filter.getRequiredColumns()) {
                    if (spec.getVirtualColumns().exists(column)) continue;
                    physicalColumns.add(column);
                }
            } else {
                physicalColumns = null;
            }
        } else {
            newFilter = spec.getFilter();
            physicalColumns = spec.getPhysicalColumns();
        }
        buildSpecBuilder.setFilter(newFilter).setPhysicalColumns(physicalColumns);
        return this.delegate.makeCursorHolder(buildSpecBuilder.build());
    }

    @Override
    public RowSignature getRowSignature() {
        return this.delegate.getRowSignature();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.delegate.getColumnCapabilities(column);
    }
}

