/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.operator.AbstractPartitioningOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.ConcatRowsAndColumns;
import org.apache.druid.query.rowsandcols.LimitedRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;

public class GlueingPartitioningOperator
extends AbstractPartitioningOperator {
    private final int maxRowsMaterialized;
    private final AtomicReference<RowsAndColumns> previousRacRef = new AtomicReference<Object>(null);
    private static final Integer MAX_ROWS_MATERIALIZED_NO_LIMIT = Integer.MAX_VALUE;

    public GlueingPartitioningOperator(Operator child, List<String> partitionColumns) {
        this(child, partitionColumns, MAX_ROWS_MATERIALIZED_NO_LIMIT);
    }

    public GlueingPartitioningOperator(Operator child, List<String> partitionColumns, Integer maxRowsMaterialized) {
        super(partitionColumns, child);
        Preconditions.checkNotNull((Object)maxRowsMaterialized, (Object)"maxRowsMaterialized cannot be null");
        this.maxRowsMaterialized = maxRowsMaterialized;
    }

    @Override
    protected AbstractPartitioningOperator.HandleContinuationResult handleContinuation(Operator.Receiver receiver, AbstractPartitioningOperator.Continuation cont) {
        while (cont.iter.hasNext()) {
            RowsAndColumns next = cont.iter.next();
            if (!cont.iter.hasNext()) {
                if (cont.subContinuation == null) {
                    receiver.push(next);
                    receiver.completed();
                    return AbstractPartitioningOperator.HandleContinuationResult.of(null);
                }
                this.previousRacRef.set(next);
                break;
            }
            Operator.Signal signal = receiver.push(next);
            if (signal == Operator.Signal.GO) continue;
            return this.handleNonGoCases(signal, cont.iter, receiver, cont);
        }
        return AbstractPartitioningOperator.HandleContinuationResult.CONTINUE_PROCESSING;
    }

    private static void ensureMaxRowsMaterializedConstraint(int numRows, int maxRowsMaterialized) {
        if (numRows > maxRowsMaterialized) {
            throw InvalidInput.exception("Too many rows to process (requested = %d, max = %d).", numRows, maxRowsMaterialized);
        }
    }

    @Override
    protected Operator.Receiver createReceiver(Operator.Receiver delegate, AtomicReference<Iterator<RowsAndColumns>> iterHolder) {
        return new GlueingReceiver(delegate, iterHolder, this.previousRacRef, this.partitionColumns, this.maxRowsMaterialized);
    }

    private static class GluedRACsIterator
    implements Iterator<RowsAndColumns> {
        private final RowsAndColumns rac;
        private final int[] boundaries;
        private int currentIndex = 0;
        private final AtomicReference<RowsAndColumns> previousRacRef;
        private final int maxRowsMaterialized;
        private final List<String> partitionColumns;

        public GluedRACsIterator(RowsAndColumns rac, AtomicReference<RowsAndColumns> previousRacRef, List<String> partitionColumns, int maxRowsMaterialized) {
            this.rac = rac;
            ClusteredGroupPartitioner groupPartitioner = ClusteredGroupPartitioner.fromRAC(rac);
            this.boundaries = groupPartitioner.computeBoundaries(partitionColumns);
            this.previousRacRef = previousRacRef;
            this.partitionColumns = partitionColumns;
            this.maxRowsMaterialized = maxRowsMaterialized;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.boundaries.length - 1;
        }

        @Override
        public RowsAndColumns next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int start = this.boundaries[this.currentIndex];
            int end = this.boundaries[this.currentIndex + 1];
            if (this.previousRacRef.get() != null) {
                if (this.currentIndex != 0) {
                    throw new ISE("previousRac should be non-null only while handling the first partition boundary.", new Object[0]);
                }
                RowsAndColumns previousRac = this.previousRacRef.get();
                this.previousRacRef.set(null);
                LimitedRowsAndColumns limitedRAC = new LimitedRowsAndColumns(this.rac, start, end);
                ConcatRowsAndColumns concatRacForFirstPartition = this.getConcatRacForFirstPartition(previousRac, limitedRAC);
                if (this.isGlueingNeeded(concatRacForFirstPartition)) {
                    GlueingPartitioningOperator.ensureMaxRowsMaterializedConstraint(concatRacForFirstPartition.numRows(), this.maxRowsMaterialized);
                    ++this.currentIndex;
                    return concatRacForFirstPartition;
                }
                return previousRac;
            }
            ++this.currentIndex;
            return new LimitedRowsAndColumns(this.rac, start, end);
        }

        private boolean isGlueingNeeded(ConcatRowsAndColumns rac) {
            for (String column : this.partitionColumns) {
                Column theCol = rac.findColumn(column);
                if (theCol == null) {
                    throw new ISE("Partition column [%s] not found in RAC.", column);
                }
                ColumnAccessor accessor = theCol.toAccessor();
                int comparison = accessor.compareRows(0, rac.numRows() - 1);
                if (comparison == 0) continue;
                return false;
            }
            return true;
        }

        private ConcatRowsAndColumns getConcatRacForFirstPartition(RowsAndColumns previousRac, RowsAndColumns firstPartitionOfCurrentRac) {
            if (previousRac == null) {
                return new ConcatRowsAndColumns(new ArrayList<RowsAndColumns>(Collections.singletonList(firstPartitionOfCurrentRac)));
            }
            return new ConcatRowsAndColumns(new ArrayList<RowsAndColumns>(Arrays.asList(previousRac, firstPartitionOfCurrentRac)));
        }
    }

    private static class GlueingReceiver
    extends AbstractPartitioningOperator.AbstractReceiver {
        private final AtomicReference<RowsAndColumns> previousRacRef;
        private final int maxRowsMaterialized;

        public GlueingReceiver(Operator.Receiver delegate, AtomicReference<Iterator<RowsAndColumns>> iterHolder, AtomicReference<RowsAndColumns> previousRacRef, List<String> partitionColumns, int maxRowsMaterialized) {
            super(delegate, iterHolder, partitionColumns);
            this.previousRacRef = previousRacRef;
            this.maxRowsMaterialized = maxRowsMaterialized;
        }

        @Override
        public Operator.Signal push(RowsAndColumns rac) {
            if (rac == null) {
                throw DruidException.defensive("Should never get a null rac here.", new Object[0]);
            }
            GlueingPartitioningOperator.ensureMaxRowsMaterializedConstraint(rac.numRows(), this.maxRowsMaterialized);
            return super.push(rac);
        }

        @Override
        public void completed() {
            if (this.previousRacRef.get() != null) {
                this.delegate.push(this.previousRacRef.get());
                this.previousRacRef.set(null);
            }
            super.completed();
        }

        @Override
        protected Operator.Signal pushPartition(RowsAndColumns partition, boolean isLastPartition, Operator.Signal previousSignal) {
            if (isLastPartition) {
                this.previousRacRef.set(partition);
                return previousSignal;
            }
            return super.pushPartition(partition, isLastPartition, previousSignal);
        }

        @Override
        protected Iterator<RowsAndColumns> getIteratorForRAC(RowsAndColumns rac) {
            return new GluedRACsIterator(rac, this.previousRacRef, this.partitionColumns, this.maxRowsMaterialized);
        }
    }
}

