/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.util.Providers;
import java.util.Arrays;
import java.util.Properties;
import org.apache.druid.guice.BaseInjectorBuilder;
import org.apache.druid.guice.ConfigModule;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.ExtensionsLoader;
import org.apache.druid.guice.ExtensionsModule;
import org.apache.druid.guice.NullHandlingModule;
import org.apache.druid.guice.PropertiesModule;
import org.apache.druid.guice.RuntimeInfoModule;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExpressionProcessingModule;
import org.apache.druid.utils.RuntimeInfo;

public class StartupInjectorBuilder
extends BaseInjectorBuilder<StartupInjectorBuilder> {
    public StartupInjectorBuilder() {
        this.add(new DruidGuiceExtensions(), new JacksonModule(), new ConfigModule(), new NullHandlingModule(), new ExpressionProcessingModule(), binder -> binder.bind(DruidSecondaryModule.class), binder -> binder.bind(PropertiesValidator.class));
    }

    @Override
    public Injector build() {
        Injector injector = super.build();
        ((PropertiesValidator)injector.getInstance(PropertiesValidator.class)).validate();
        return injector;
    }

    public StartupInjectorBuilder withProperties(Properties properties) {
        this.add(binder -> binder.bind(Properties.class).toInstance((Object)properties));
        return this;
    }

    public StartupInjectorBuilder withEmptyProperties() {
        return this.withProperties(new Properties());
    }

    public StartupInjectorBuilder withExtensions() {
        this.add(new ExtensionsModule());
        return this;
    }

    public StartupInjectorBuilder forServer() {
        this.withExtensions();
        this.add(new PropertiesModule(Arrays.asList("common.runtime.properties", "runtime.properties")), new RuntimeInfoModule());
        return this;
    }

    public StartupInjectorBuilder forTests() {
        this.add(binder -> {
            binder.bind(ExtensionsLoader.class).toProvider(Providers.of(null));
            binder.bind(RuntimeInfo.class).toProvider(Providers.of(null));
        });
        return this;
    }

    @VisibleForTesting
    public static String getVersionString() {
        String version = StartupInjectorBuilder.class.getPackage().getImplementationVersion();
        if (version == null || version.contains("SNAPSHOT")) {
            return "latest";
        }
        return version;
    }

    private static final class PropertiesValidator {
        private final Properties properties;

        @Inject
        public PropertiesValidator(Properties properties) {
            this.properties = properties;
        }

        public void validate() {
            boolean nonStrictExpressions;
            boolean no3vl;
            boolean defaultValueMode = Boolean.parseBoolean(this.properties.getProperty("druid.generic.useDefaultValueForNull", "false"));
            if (defaultValueMode) {
                String docsLink = StringUtils.format("https://druid.apache.org/docs/%s/release-info/migr-ansi-sql-null", StartupInjectorBuilder.getVersionString());
                throw new ISE("%s set to 'true', but has been removed, see %s for details for how to migrate to SQL compliant behavior", "druid.generic.useDefaultValueForNull", docsLink);
            }
            boolean bl = no3vl = !Boolean.parseBoolean(this.properties.getProperty("druid.generic.useThreeValueLogicForNativeFilters", "true"));
            if (no3vl) {
                String docsLink = StringUtils.format("https://druid.apache.org/docs/%s/release-info/migr-ansi-sql-null", StartupInjectorBuilder.getVersionString());
                throw new ISE("%s set to 'false', but has been removed, see %s for details for how to migrate to SQL compliant behavior", "druid.generic.useThreeValueLogicForNativeFilters", docsLink);
            }
            boolean bl2 = nonStrictExpressions = !Boolean.parseBoolean(this.properties.getProperty("druid.expressions.useStrictBooleans", "true"));
            if (nonStrictExpressions) {
                String docsLink = StringUtils.format("https://druid.apache.org/docs/%s/release-info/migr-ansi-sql-null", StartupInjectorBuilder.getVersionString());
                throw new ISE("%s set to 'false', but has been removed, see %s for details for how to migrate to SQL compliant behavior", "druid.expressions.useStrictBooleans", docsLink);
            }
        }
    }
}

