/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import javax.annotation.Nullable;
import org.apache.druid.frame.field.ComplexFieldWriter;
import org.apache.druid.frame.field.DoubleFieldWriter;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.field.FloatFieldWriter;
import org.apache.druid.frame.field.LongFieldWriter;
import org.apache.druid.frame.field.NumericArrayFieldWriter;
import org.apache.druid.frame.field.StringArrayFieldWriter;
import org.apache.druid.frame.field.StringFieldWriter;
import org.apache.druid.frame.write.UnsupportedColumnTypeException;
import org.apache.druid.frame.write.cast.TypeCastSelectors;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class FieldWriters {
    private FieldWriters() {
    }

    public static FieldWriter create(ColumnSelectorFactory columnSelectorFactory, String columnName, ColumnType columnType, boolean removeNullBytes) {
        if (columnType == null) {
            throw new UnsupportedColumnTypeException(columnName, null);
        }
        switch ((ValueType)columnType.getType()) {
            case LONG: {
                return FieldWriters.makeLongWriter(columnSelectorFactory, columnName);
            }
            case FLOAT: {
                return FieldWriters.makeFloatWriter(columnSelectorFactory, columnName);
            }
            case DOUBLE: {
                return FieldWriters.makeDoubleWriter(columnSelectorFactory, columnName);
            }
            case STRING: {
                return FieldWriters.makeStringWriter(columnSelectorFactory, columnName, removeNullBytes);
            }
            case COMPLEX: {
                return FieldWriters.makeComplexWriter(columnSelectorFactory, columnName, columnType.getComplexTypeName());
            }
            case ARRAY: {
                switch ((ValueType)columnType.getElementType().getType()) {
                    case STRING: {
                        return FieldWriters.makeStringArrayWriter(columnSelectorFactory, columnName, removeNullBytes);
                    }
                    case LONG: {
                        return FieldWriters.makeLongArrayWriter(columnSelectorFactory, columnName);
                    }
                    case FLOAT: {
                        return FieldWriters.makeFloatArrayWriter(columnSelectorFactory, columnName);
                    }
                    case DOUBLE: {
                        return FieldWriters.makeDoubleArrayWriter(columnSelectorFactory, columnName);
                    }
                }
            }
        }
        throw new UnsupportedColumnTypeException(columnName, columnType);
    }

    private static FieldWriter makeLongWriter(ColumnSelectorFactory selectorFactory, String columnName) {
        ColumnValueSelector<?> selector = TypeCastSelectors.makeColumnValueSelector(selectorFactory, columnName, ColumnType.LONG);
        return LongFieldWriter.forPrimitive(selector);
    }

    private static FieldWriter makeFloatWriter(ColumnSelectorFactory selectorFactory, String columnName) {
        ColumnValueSelector<?> selector = TypeCastSelectors.makeColumnValueSelector(selectorFactory, columnName, ColumnType.FLOAT);
        return FloatFieldWriter.forPrimitive(selector);
    }

    private static FieldWriter makeDoubleWriter(ColumnSelectorFactory selectorFactory, String columnName) {
        ColumnValueSelector<?> selector = TypeCastSelectors.makeColumnValueSelector(selectorFactory, columnName, ColumnType.DOUBLE);
        return DoubleFieldWriter.forPrimitive(selector);
    }

    private static FieldWriter makeStringWriter(ColumnSelectorFactory selectorFactory, String columnName, boolean removeNullBytes) {
        DimensionSelector selector = selectorFactory.makeDimensionSelector(DefaultDimensionSpec.of(columnName));
        return new StringFieldWriter(selector, removeNullBytes);
    }

    private static FieldWriter makeStringArrayWriter(ColumnSelectorFactory selectorFactory, String columnName, boolean removeNullBytes) {
        ColumnValueSelector<?> selector = TypeCastSelectors.makeColumnValueSelector(selectorFactory, columnName, ColumnType.STRING_ARRAY);
        return new StringArrayFieldWriter(selector, removeNullBytes);
    }

    private static FieldWriter makeLongArrayWriter(ColumnSelectorFactory selectorFactory, String columnName) {
        ColumnValueSelector<?> selector = TypeCastSelectors.makeColumnValueSelector(selectorFactory, columnName, ColumnType.LONG_ARRAY);
        return NumericArrayFieldWriter.getLongArrayFieldWriter(selector);
    }

    private static FieldWriter makeFloatArrayWriter(ColumnSelectorFactory selectorFactory, String columnName) {
        ColumnValueSelector<?> selector = TypeCastSelectors.makeColumnValueSelector(selectorFactory, columnName, ColumnType.FLOAT_ARRAY);
        return NumericArrayFieldWriter.getFloatArrayFieldWriter(selector);
    }

    private static FieldWriter makeDoubleArrayWriter(ColumnSelectorFactory selectorFactory, String columnName) {
        ColumnValueSelector<?> selector = TypeCastSelectors.makeColumnValueSelector(selectorFactory, columnName, ColumnType.DOUBLE_ARRAY);
        return NumericArrayFieldWriter.getDoubleArrayFieldWriter(selector);
    }

    private static FieldWriter makeComplexWriter(ColumnSelectorFactory selectorFactory, String columnName, @Nullable String columnTypeName) {
        if (columnTypeName == null) {
            throw new ISE("No complexTypeName, cannot write column [%s]", columnName);
        }
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(columnTypeName);
        if (serde == null) {
            throw new ISE("No serde for complexTypeName[%s], cannot write column [%s]", columnTypeName, columnName);
        }
        ColumnValueSelector<?> selector = TypeCastSelectors.makeColumnValueSelector(selectorFactory, columnName, ColumnType.ofComplex(columnTypeName));
        return new ComplexFieldWriter(serde, selector);
    }
}

