/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public final class Threads {
    public static void sleepFor(long sleepTime, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (sleepTime <= 0L) {
            return;
        }
        long sleepTimeLimitNanos = System.nanoTime() + unit.toNanos(sleepTime);
        do {
            long sleepTimeoutNanos;
            if ((sleepTimeoutNanos = sleepTimeLimitNanos - System.nanoTime()) <= 0L) {
                return;
            }
            LockSupport.parkNanos(sleepTimeoutNanos);
        } while (!Thread.interrupted());
        throw new InterruptedException();
    }

    private Threads() {
    }
}

