/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.junit;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.rules.ExternalResource;

public class LoggerCaptureRule
extends ExternalResource {
    private final Class<?> targetClass;
    private InMemoryAppender inMemoryAppender;
    private LoggerConfig targetClassLoggerConfig;

    public LoggerCaptureRule(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    protected void before() {
        this.inMemoryAppender = new InMemoryAppender(this.targetClass);
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        this.targetClassLoggerConfig = configuration.getLoggerConfig(this.targetClass.getName());
        this.targetClassLoggerConfig.addAppender((Appender)this.inMemoryAppender, Level.ALL, null);
    }

    protected void after() {
        this.clearLogEvents();
        this.targetClassLoggerConfig.removeAppender(InMemoryAppender.NAME);
    }

    public List<LogEvent> getLogEvents() {
        return this.inMemoryAppender.getLogEvents();
    }

    public void clearLogEvents() {
        this.inMemoryAppender.clearLogEvents();
    }

    public void awaitLogEvents() throws InterruptedException {
        this.inMemoryAppender.awaitLogEvents();
    }

    private static class InMemoryAppender
    extends AbstractAppender {
        static final String NAME = InMemoryAppender.class.getName();
        private final String targetLoggerName;
        @GuardedBy(value="logEvents")
        private final List<LogEvent> logEvents;

        InMemoryAppender(Class<?> targetClass) {
            super(NAME, null, null);
            this.targetLoggerName = targetClass.getName();
            this.logEvents = new ArrayList<LogEvent>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void append(LogEvent logEvent) {
            List<LogEvent> list = this.logEvents;
            synchronized (list) {
                if (logEvent.getLoggerName().equals(this.targetLoggerName)) {
                    this.logEvents.add(logEvent);
                    this.logEvents.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<LogEvent> getLogEvents() {
            List<LogEvent> list = this.logEvents;
            synchronized (list) {
                return ImmutableList.copyOf(this.logEvents);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearLogEvents() {
            List<LogEvent> list = this.logEvents;
            synchronized (list) {
                this.logEvents.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitLogEvents() throws InterruptedException {
            List<LogEvent> list = this.logEvents;
            synchronized (list) {
                while (this.logEvents.isEmpty()) {
                    this.logEvents.wait();
                }
            }
        }
    }
}

