/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class TestVectorColumnSelectorFactory
implements VectorColumnSelectorFactory {
    private ReadableVectorInspector inspector = null;
    private final Map<String, SingleValueDimensionVectorSelector> singleValDimSelectors = new LinkedHashMap<String, SingleValueDimensionVectorSelector>();
    private final Map<String, MultiValueDimensionVectorSelector> multiValDimSelectors = new LinkedHashMap<String, MultiValueDimensionVectorSelector>();
    private final Map<String, VectorValueSelector> vectorValueSelectors = new LinkedHashMap<String, VectorValueSelector>();
    private final Map<String, VectorObjectSelector> vectorObjectSelectors = new LinkedHashMap<String, VectorObjectSelector>();
    private final Map<String, ColumnCapabilities> capabilitiesMap = new LinkedHashMap<String, ColumnCapabilities>();

    public TestVectorColumnSelectorFactory addSVDVS(String col, SingleValueDimensionVectorSelector selector) {
        this.singleValDimSelectors.put(col, selector);
        return this;
    }

    public TestVectorColumnSelectorFactory addMVDVS(String col, MultiValueDimensionVectorSelector selector) {
        this.multiValDimSelectors.put(col, selector);
        return this;
    }

    public TestVectorColumnSelectorFactory addVVS(String col, VectorValueSelector selector) {
        this.vectorValueSelectors.put(col, selector);
        return this;
    }

    public TestVectorColumnSelectorFactory addVOS(String col, VectorObjectSelector selector) {
        this.vectorObjectSelectors.put(col, selector);
        return this;
    }

    public TestVectorColumnSelectorFactory addCapabilities(String col, ColumnCapabilities capabilities) {
        this.capabilitiesMap.put(col, capabilities);
        return this;
    }

    public ReadableVectorInspector getReadableVectorInspector() {
        return this.inspector;
    }

    public SingleValueDimensionVectorSelector makeSingleValueDimensionSelector(DimensionSpec dimensionSpec) {
        return this.getFromMap(this.singleValDimSelectors, dimensionSpec.getDimension(), "dimension");
    }

    public MultiValueDimensionVectorSelector makeMultiValueDimensionSelector(DimensionSpec dimensionSpec) {
        return this.getFromMap(this.multiValDimSelectors, dimensionSpec.getDimension(), "dimension");
    }

    public VectorValueSelector makeValueSelector(String column) {
        return this.getFromMap(this.vectorValueSelectors, column, "column");
    }

    public VectorObjectSelector makeObjectSelector(String column) {
        return this.getFromMap(this.vectorObjectSelectors, column, "column");
    }

    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.getFromMap(this.capabilitiesMap, column, "capability");
    }

    private <T> T getFromMap(Map<String, T> map, String key, String name) {
        if (!map.containsKey(key)) {
            throw new UOE("%s[%s] wasn't registered, but was asked for, register first (null is okay)", new Object[]{name, key});
        }
        return map.get(key);
    }
}

