/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.collections.spatial.search.RadiusBound;
import org.apache.druid.collections.spatial.search.RectangularBound;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.SpatialDimFilter;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.filter.SpatialFilter;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SpatialFilterTest
extends InitializedNullHandlingTest {
    public static final int NUM_POINTS = 5000;
    private static IndexMerger INDEX_MERGER = TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
    private static IndexIO INDEX_IO = TestHelper.getTestIndexIO();
    private static Interval DATA_INTERVAL = Intervals.of((String)"2013-01-01/2013-01-07");
    private static AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val")};
    private static List<String> DIMS = Lists.newArrayList((Object[])new String[]{"dim", "lat", "long", "lat2", "long2"});
    private final Segment segment;

    public SpatialFilterTest(Segment segment) {
        this.segment = segment;
    }

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        IndexSpec indexSpec = IndexSpec.DEFAULT;
        IndexSpec frontCodedIndexSpec = IndexSpec.builder().withStringDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(4), Byte.valueOf((byte)1))).build();
        IncrementalIndex rtIndex = SpatialFilterTest.makeIncrementalIndex();
        QueryableIndex mMappedTestIndex = SpatialFilterTest.makeQueryableIndex(indexSpec);
        QueryableIndex mergedRealtimeIndex = SpatialFilterTest.makeMergedQueryableIndex(indexSpec);
        QueryableIndex mMappedTestIndexFrontCoded = SpatialFilterTest.makeQueryableIndex(frontCodedIndexSpec);
        QueryableIndex mergedRealtimeIndexFrontCoded = SpatialFilterTest.makeMergedQueryableIndex(frontCodedIndexSpec);
        return Arrays.asList({new IncrementalIndexSegment(rtIndex, null)}, {new QueryableIndexSegment(mMappedTestIndex, null)}, {new QueryableIndexSegment(mergedRealtimeIndex, null)}, {new QueryableIndexSegment(mMappedTestIndexFrontCoded, null)}, {new QueryableIndexSegment(mergedRealtimeIndexFrontCoded, null)});
    }

    private static IncrementalIndex makeIncrementalIndex() throws IOException {
        IncrementalIndex theIndex = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(DimensionsSpec.builder().setSpatialDimensions(Arrays.asList(new SpatialDimensionSchema("dim.geo", Arrays.asList("lat", "long")), new SpatialDimensionSchema("spatialIsRad", Arrays.asList("lat2", "long2")))).build()).build()).setMaxRowCount(5000).build();
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(0.0f), (Object)"long", (Object)Float.valueOf(0.0f), (Object)"val", (Object)17L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-02").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-02").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(1.0f), (Object)"long", (Object)Float.valueOf(3.0f), (Object)"val", (Object)29L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-03").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-03").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(4.0f), (Object)"long", (Object)Float.valueOf(2.0f), (Object)"val", (Object)13L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-04").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-04").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(7.0f), (Object)"long", (Object)Float.valueOf(3.0f), (Object)"val", (Object)91L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(8.0f), (Object)"long", (Object)Float.valueOf(6.0f), (Object)"val", (Object)47L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)"_mmx.unknown", (Object)"long", (Object)"_mmx.unknown", (Object)"val", (Object)101L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"_mmx.unknown", (Object)"val", (Object)501L)));
        theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"lat2", (Object)Float.valueOf(0.0f), (Object)"long2", (Object)Float.valueOf(0.0f), (Object)"val", (Object)13L)));
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 8; i < 5000; ++i) {
            theIndex.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"boo", (Object)"lat", (Object)Float.valueOf((float)((double)(((Random)rand).nextFloat() * 10.0f) + 10.0)), (Object)"long", (Object)Float.valueOf((float)((double)(((Random)rand).nextFloat() * 10.0f) + 10.0)), (Object)"val", (Object)i)));
        }
        return theIndex;
    }

    private static QueryableIndex makeQueryableIndex(IndexSpec indexSpec) throws IOException {
        IncrementalIndex theIndex = SpatialFilterTest.makeIncrementalIndex();
        File tmpFile = File.createTempFile("billy", "yay");
        tmpFile.delete();
        FileUtils.mkdirp((File)tmpFile);
        tmpFile.deleteOnExit();
        INDEX_MERGER.persist(theIndex, tmpFile, indexSpec, null);
        return INDEX_IO.loadIndex(tmpFile);
    }

    private static QueryableIndex makeMergedQueryableIndex(IndexSpec indexSpec) {
        try {
            IncrementalIndex first = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(DimensionsSpec.builder().setSpatialDimensions(Arrays.asList(new SpatialDimensionSchema("dim.geo", Arrays.asList("lat", "long")), new SpatialDimensionSchema("spatialIsRad", Arrays.asList("lat2", "long2")))).build()).build()).setMaxRowCount(1000).build();
            IncrementalIndex second = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(DimensionsSpec.builder().setSpatialDimensions(Arrays.asList(new SpatialDimensionSchema("dim.geo", Arrays.asList("lat", "long")), new SpatialDimensionSchema("spatialIsRad", Arrays.asList("lat2", "long2")))).build()).build()).setMaxRowCount(1000).build();
            IncrementalIndex third = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DATA_INTERVAL.getStartMillis()).withQueryGranularity(Granularities.DAY).withMetrics(METRIC_AGGS).withDimensionsSpec(DimensionsSpec.builder().setSpatialDimensions(Arrays.asList(new SpatialDimensionSchema("dim.geo", Arrays.asList("lat", "long")), new SpatialDimensionSchema("spatialIsRad", Arrays.asList("lat2", "long2")))).build()).build()).setMaxRowCount(5000).build();
            first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(0.0f), (Object)"long", (Object)Float.valueOf(0.0f), (Object)"val", (Object)17L)));
            first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-02").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-02").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(1.0f), (Object)"long", (Object)Float.valueOf(3.0f), (Object)"val", (Object)29L)));
            first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-03").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-03").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(4.0f), (Object)"long", (Object)Float.valueOf(2.0f), (Object)"val", (Object)13L)));
            first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)"_mmx.unknown", (Object)"long", (Object)"_mmx.unknown", (Object)"val", (Object)101L)));
            first.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"dim.geo", (Object)"_mmx.unknown", (Object)"val", (Object)501L)));
            second.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-04").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-04").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(7.0f), (Object)"long", (Object)Float.valueOf(3.0f), (Object)"val", (Object)91L)));
            second.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"dim", (Object)"foo", (Object)"lat", (Object)Float.valueOf(8.0f), (Object)"long", (Object)Float.valueOf(6.0f), (Object)"val", (Object)47L)));
            second.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-05").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-05").toString(), (Object)"lat2", (Object)Float.valueOf(0.0f), (Object)"long2", (Object)Float.valueOf(0.0f), (Object)"val", (Object)13L)));
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (int i = 8; i < 5000; ++i) {
                third.add((InputRow)new MapBasedInputRow(DateTimes.of((String)"2013-01-01").getMillis(), DIMS, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01").toString(), (Object)"dim", (Object)"boo", (Object)"lat", (Object)Float.valueOf((float)((double)(((Random)rand).nextFloat() * 10.0f) + 10.0)), (Object)"long", (Object)Float.valueOf((float)((double)(((Random)rand).nextFloat() * 10.0f) + 10.0)), (Object)"val", (Object)i)));
            }
            File tmpFile = File.createTempFile("yay", "who");
            tmpFile.delete();
            File firstFile = new File(tmpFile, "first");
            File secondFile = new File(tmpFile, "second");
            File thirdFile = new File(tmpFile, "third");
            File mergedFile = new File(tmpFile, "merged");
            FileUtils.mkdirp((File)firstFile);
            FileUtils.mkdirp((File)secondFile);
            FileUtils.mkdirp((File)thirdFile);
            FileUtils.mkdirp((File)mergedFile);
            firstFile.deleteOnExit();
            secondFile.deleteOnExit();
            thirdFile.deleteOnExit();
            mergedFile.deleteOnExit();
            INDEX_MERGER.persist(first, DATA_INTERVAL, firstFile, indexSpec, null);
            INDEX_MERGER.persist(second, DATA_INTERVAL, secondFile, indexSpec, null);
            INDEX_MERGER.persist(third, DATA_INTERVAL, thirdFile, indexSpec, null);
            QueryableIndex mergedRealtime = INDEX_IO.loadIndex(INDEX_MERGER.mergeQueryableIndex(Arrays.asList(INDEX_IO.loadIndex(firstFile), INDEX_IO.loadIndex(secondFile), INDEX_IO.loadIndex(thirdFile)), true, METRIC_AGGS, mergedFile, indexSpec, null, -1));
            return mergedRealtime;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testSpatialQuery() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals(Collections.singletonList(Intervals.of((String)"2013-01-01/2013-01-07"))).filters((DimFilter)new SpatialDimFilter("dim.geo", (Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)3L).put((Object)"val", (Object)59L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testSpatialQueryWithOtherSpatialDim() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.ALL).intervals(Collections.singletonList(Intervals.of((String)"2013-01-01/2013-01-07"))).filters((DimFilter)new SpatialDimFilter("spatialIsRad", (Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 5.0f))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)13L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testSpatialQueryMorePoints() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("test").granularity(Granularities.DAY).intervals(Collections.singletonList(Intervals.of((String)"2013-01-01/2013-01-07"))).filters((DimFilter)new SpatialDimFilter("dim.geo", (Bound)new RectangularBound(new float[]{0.0f, 0.0f}, new float[]{9.0f, 9.0f}))).aggregators(Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("val", "val"))).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2013-01-01T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)17L).build())), new Result(DateTimes.of((String)"2013-01-02T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)29L).build())), new Result(DateTimes.of((String)"2013-01-03T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)13L).build())), new Result(DateTimes.of((String)"2013-01-04T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)91L).build())), new Result(DateTimes.of((String)"2013-01-05T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"val", (Object)47L).build())));
        try {
            TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
            FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner(this.segment), factory.getToolchest());
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(SpatialFilter.class).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForBoundDruidPredicateFactory() {
        EqualsVerifier.forClass(SpatialFilter.BoundDruidPredicateFactory.class).usingGetClass().verify();
    }

    @Test
    public void testSpatialFilter() {
        SpatialFilter spatialFilter = new SpatialFilter("test", (Bound)new RadiusBound(new float[]{0.0f, 0.0f}, 0.0f, 0), new FilterTuning(Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1)));
        Assert.assertTrue((boolean)spatialFilter.makeMatcher((ColumnSelectorFactory)new TestSpatialSelectorFactory("0,0")).matches(true));
        Assert.assertFalse((boolean)spatialFilter.makeMatcher((ColumnSelectorFactory)new TestSpatialSelectorFactory(new Date())).matches(true));
        Assert.assertFalse((boolean)spatialFilter.makeMatcher((ColumnSelectorFactory)new TestSpatialSelectorFactory(new Object())).matches(true));
    }

    static class TestSpatialSelectorFactory
    implements ColumnSelectorFactory {
        Object object;

        public TestSpatialSelectorFactory(Object value) {
            this.object = value;
        }

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return null;
        }

        public ColumnValueSelector makeColumnValueSelector(String columnName) {
            return new TestObjectColumnSelector<Object>(new Object[]{this.object});
        }

        @Nullable
        public ColumnCapabilities getColumnCapabilities(String column) {
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.UNKNOWN_COMPLEX);
        }
    }
}

