/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.Result;
import org.apache.druid.query.TestQueryRunners;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.SchemalessIndexTest;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SchemalessTestSimpleTest
extends InitializedNullHandlingTest {
    final String dataSource = "testing";
    final Granularity ALL_GRAN = Granularities.ALL;
    final String marketDimension = "market";
    final String qualityDimension = "quality";
    final String placementDimension = "placement";
    final String placementishDimension = "placementish";
    final String indexMetric = "index";
    final CountAggregatorFactory rowsCount = new CountAggregatorFactory("rows");
    final DoubleSumAggregatorFactory indexDoubleSum = new DoubleSumAggregatorFactory("index", "index");
    final HyperUniquesAggregatorFactory uniques = new HyperUniquesAggregatorFactory("uniques", "quality_uniques");
    final ConstantPostAggregator constant = new ConstantPostAggregator("const", (Number)1L);
    final FieldAccessPostAggregator rowsPostAgg = new FieldAccessPostAggregator("rows", "rows");
    final FieldAccessPostAggregator indexPostAgg = new FieldAccessPostAggregator("index", "index");
    final ArithmeticPostAggregator addRowsIndexConstant = new ArithmeticPostAggregator("addRowsIndexConstant", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{this.constant, this.rowsPostAgg, this.indexPostAgg}));
    final List<AggregatorFactory> commonAggregators = Arrays.asList(this.rowsCount, this.indexDoubleSum, this.uniques);
    final QuerySegmentSpec fullOnInterval = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.of((String)"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z")));
    private final Segment segment;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() {
        ArrayList<Object[]> argumentArrays = new ArrayList<Object[]>();
        for (SegmentWriteOutMediumFactory segmentWriteOutMediumFactory : SegmentWriteOutMediumFactory.builtInFactories()) {
            SchemalessIndexTest schemalessIndexTest = new SchemalessIndexTest(segmentWriteOutMediumFactory);
            IncrementalIndex incrementalIndex = SchemalessIndexTest.getIncrementalIndex();
            QueryableIndex persistedIncrementalIndex = TestIndex.persistAndMemoryMap(incrementalIndex);
            QueryableIndex mergedIncrementalIndex = schemalessIndexTest.getMergedIncrementalIndex();
            argumentArrays.add(new Object[]{new IncrementalIndexSegment(incrementalIndex, SegmentId.dummy((String)"test"))});
            argumentArrays.add(new Object[]{new QueryableIndexSegment(persistedIncrementalIndex, SegmentId.dummy((String)"test"))});
            argumentArrays.add(new Object[]{new QueryableIndexSegment(mergedIncrementalIndex, SegmentId.dummy((String)"test"))});
        }
        return argumentArrays;
    }

    public SchemalessTestSimpleTest(Segment segment) {
        this.segment = segment;
    }

    @Test
    public void testFullOnTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)11L).put((Object)"index", (Object)900.0).put((Object)"addRowsIndexConstant", (Object)912.0).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Ignore
    public void testFullOnTopN() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).dimension("market").metric("index").threshold(3).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(new DimensionAndMetricValueExtractor((Map)ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)4L).put((Object)"index", (Object)400.0).put((Object)"addRowsIndexConstant", (Object)405.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()), new DimensionAndMetricValueExtractor((Map)ImmutableMap.builder().put((Object)"market", (Object)"").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()), new DimensionAndMetricValueExtractor((Map)ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())))));
        try (CloseableStupidPool<ByteBuffer> pool = TestQueryRunners.createDefaultNonBlockingPool();){
            QueryRunner runner = TestQueryRunners.makeTopNQueryRunner(this.segment, pool);
            TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
        }
    }

    @Test
    public void testFullOnSearch() {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(this.ALL_GRAN).intervals(this.fullOnInterval).query("a").build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        QueryRunner runner = TestQueryRunners.makeSearchQueryRunner(this.segment);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }

    @Test
    public void testTimeBoundary() {
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        List expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")))));
        QueryRunner runner = TestQueryRunners.makeTimeBoundaryQueryRunner(this.segment);
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query)));
    }
}

