/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.DebugRow;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.RowIterator;
import org.apache.druid.segment.RowIteratorHelper;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.StringUtf8DictionaryEncodedColumn;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.BitmapValues;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.data.ImmutableBitmapValues;
import org.apache.druid.segment.data.IncrementalIndexTest;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.druid.segment.incremental.IncrementalIndexRowSelector;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueIndexes;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public class IndexMergerTestBase
extends InitializedNullHandlingTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    protected IndexMerger indexMerger;
    private final IndexSpec indexSpec;
    private final IndexIO indexIO;
    private final boolean useBitmapIndexes;
    private final BitmapSerdeFactory serdeFactory;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    @Parameterized.Parameters(name="{index}: metric compression={0}, dimension compression={1}, long encoding={2}, segment write-out medium={3}")
    public static Collection<Object[]> data() {
        return Collections2.transform((Collection)Sets.cartesianProduct((List)ImmutableList.of(EnumSet.allOf(CompressionStrategy.class), (Object)ImmutableSet.copyOf((Object[])CompressionStrategy.noNoneValues()), EnumSet.allOf(CompressionFactory.LongEncodingStrategy.class), (Object)SegmentWriteOutMediumFactory.builtInFactories())), (Function)new Function<List<?>, Object[]>(){

            @Nullable
            public Object[] apply(List<?> input) {
                return input.toArray();
            }
        });
    }

    static BitmapValues getBitmapIndex(QueryableIndexIndexableAdapter adapter, String dimension, String value) {
        ColumnHolder columnHolder = adapter.getQueryableIndex().getColumnHolder(dimension);
        if (columnHolder == null) {
            return BitmapValues.EMPTY;
        }
        ColumnIndexSupplier indexSupplier = columnHolder.getIndexSupplier();
        if (indexSupplier == null) {
            return BitmapValues.EMPTY;
        }
        StringValueSetIndexes index = (StringValueSetIndexes)indexSupplier.as(StringValueSetIndexes.class);
        if (index == null) {
            return BitmapValues.EMPTY;
        }
        return new ImmutableBitmapValues((ImmutableBitmap)index.forValue(value).computeBitmapResult((BitmapResultFactory)new DefaultBitmapResultFactory(adapter.getQueryableIndex().getBitmapFactoryForDimensions()), false));
    }

    protected IndexMergerTestBase(@Nullable BitmapSerdeFactory bitmapSerdeFactory, CompressionStrategy compressionStrategy, CompressionStrategy dimCompressionStrategy, CompressionFactory.LongEncodingStrategy longEncodingStrategy) {
        this.indexSpec = IndexSpec.builder().withBitmapSerdeFactory((BitmapSerdeFactory)(bitmapSerdeFactory != null ? bitmapSerdeFactory : new ConciseBitmapSerdeFactory())).withDimensionCompression(dimCompressionStrategy).withMetricCompression(compressionStrategy).withLongEncoding(longEncodingStrategy).build();
        this.indexIO = TestHelper.getTestIndexIO();
        this.serdeFactory = bitmapSerdeFactory;
        this.useBitmapIndexes = bitmapSerdeFactory != null;
    }

    @Test
    public void testPersist() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist);
        File tempDir = this.temporaryFolder.newFolder();
        QueryableIndex index = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, this.indexSpec, null)));
        Assert.assertEquals((long)2L, (long)index.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
        Assert.assertEquals(IndexMergerTestBase.makeOrderBys("__time"), (Object)Lists.newArrayList((Iterable)index.getOrdering()));
        Assert.assertEquals((long)3L, (long)index.getColumnNames().size());
        this.assertDimCompression(index, this.indexSpec.getDimensionCompression());
        Assert.assertArrayEquals((Object[])IncrementalIndexTest.getDefaultCombiningAggregatorFactories(), (Object[])index.getMetadata().getAggregators());
        Assert.assertEquals((Object)Granularities.NONE, (Object)index.getMetadata().getQueryGranularity());
    }

    @Test
    public void testPersistPlainNonTimeOrdered() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("dim1"), (Object)new StringDimensionSchema("dim2"), (Object)new LongDimensionSchema("__time"))).setForceSegmentSortByTime(Boolean.valueOf(false)).build()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).withQueryGranularity(Granularities.NONE).withRollup(false).build()).setMaxRowCount(1000000).build();
        IncrementalIndexTest.populateIndex(timestamp, toPersist);
        IncrementalIndexTest.populateIndex(timestamp, toPersist);
        IncrementalIndexTest.populateIndex(timestamp + 1L, toPersist);
        File tempDir = this.temporaryFolder.newFolder();
        QueryableIndex index = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, this.indexSpec, null)));
        Assert.assertEquals((long)6L, (long)index.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
        Assert.assertEquals(IndexMergerTestBase.makeOrderBys("dim1", "dim2", "__time"), (Object)Lists.newArrayList((Iterable)index.getOrdering()));
        Assert.assertEquals((long)3L, (long)index.getColumnNames().size());
        this.assertDimCompression(index, this.indexSpec.getDimensionCompression());
        Assert.assertArrayEquals((Object[])IncrementalIndexTest.getDefaultCombiningAggregatorFactories(), (Object[])index.getMetadata().getAggregators());
        Assert.assertEquals((Object)Granularities.NONE, (Object)index.getMetadata().getQueryGranularity());
        Assert.assertEquals((long)6L, (long)index.getNumRows());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)timestamp, (Object)1L), (Object)ImmutableList.of((Object)"1", (Object)"2", (Object)timestamp, (Object)1L), (Object)ImmutableList.of((Object)"1", (Object)"2", (Object)(timestamp + 1L), (Object)1L), (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)timestamp, (Object)1L), (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)timestamp, (Object)1L), (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)(timestamp + 1L), (Object)1L)), (Object)FrameTestUtil.readRowsFromCursorFactory((CursorFactory)new QueryableIndexCursorFactory(index)).toList());
    }

    @Test
    public void testPersistRollupNonTimeOrdered() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist = new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("dim1"), (Object)new StringDimensionSchema("dim2"), (Object)new LongDimensionSchema("__time"))).setForceSegmentSortByTime(Boolean.valueOf(false)).build()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).withQueryGranularity(Granularities.NONE).withRollup(true).build()).setMaxRowCount(1000000).build();
        IncrementalIndexTest.populateIndex(timestamp, toPersist);
        IncrementalIndexTest.populateIndex(timestamp, toPersist);
        IncrementalIndexTest.populateIndex(timestamp + 1L, toPersist);
        File tempDir = this.temporaryFolder.newFolder();
        QueryableIndex index = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, this.indexSpec, null)));
        Assert.assertEquals((long)4L, (long)index.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
        Assert.assertEquals(IndexMergerTestBase.makeOrderBys("dim1", "dim2", "__time"), (Object)Lists.newArrayList((Iterable)index.getOrdering()));
        Assert.assertEquals((long)3L, (long)index.getColumnNames().size());
        this.assertDimCompression(index, this.indexSpec.getDimensionCompression());
        Assert.assertArrayEquals((Object[])IncrementalIndexTest.getDefaultCombiningAggregatorFactories(), (Object[])index.getMetadata().getAggregators());
        Assert.assertEquals((Object)Granularities.NONE, (Object)index.getMetadata().getQueryGranularity());
        Assert.assertEquals((long)4L, (long)index.getNumRows());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)timestamp, (Object)2L), (Object)ImmutableList.of((Object)"1", (Object)"2", (Object)(timestamp + 1L), (Object)1L), (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)timestamp, (Object)2L), (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)(timestamp + 1L), (Object)1L)), (Object)FrameTestUtil.readRowsFromCursorFactory((CursorFactory)new QueryableIndexCursorFactory(index)).toList());
    }

    @Test
    public void testPersistWithDifferentDims() throws Exception {
        IncrementalIndex toPersist = IncrementalIndexTest.createIndex(null);
        toPersist.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2")));
        toPersist.add((InputRow)new MapBasedInputRow(1L, Collections.singletonList("dim1"), (Map)ImmutableMap.of((Object)"dim1", (Object)"3")));
        File tempDir = this.temporaryFolder.newFolder();
        QueryableIndex index = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, this.indexSpec, null)));
        Assert.assertEquals((long)2L, (long)index.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
        Assert.assertEquals(IndexMergerTestBase.makeOrderBys("__time"), (Object)Lists.newArrayList((Iterable)index.getOrdering()));
        Assert.assertEquals((long)3L, (long)index.getColumnNames().size());
        this.assertDimCompression(index, this.indexSpec.getDimensionCompression());
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(index);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((long)2L, (long)rowList.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)"1", (Object)"2"), rowList.get(0).dimensionValues());
        Assert.assertEquals(Arrays.asList("3", null), rowList.get(1).dimensionValues());
        this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", null));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "1"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "3"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", null));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", "2"));
    }

    @Test
    public void testPersistWithSegmentMetadata() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist);
        ImmutableMap metadataElems = ImmutableMap.of((Object)"key", (Object)"value");
        toPersist.getMetadata().putAll((Map)metadataElems);
        File tempDir = this.temporaryFolder.newFolder();
        QueryableIndex index = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, this.indexSpec, null)));
        Assert.assertEquals((long)2L, (long)index.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
        Assert.assertEquals(IndexMergerTestBase.makeOrderBys("__time"), (Object)Lists.newArrayList((Iterable)index.getOrdering()));
        Assert.assertEquals((long)3L, (long)index.getColumnNames().size());
        this.assertDimCompression(index, this.indexSpec.getDimensionCompression());
        Assert.assertEquals((Object)new Metadata((Map)metadataElems, IncrementalIndexTest.getDefaultCombiningAggregatorFactories(), null, Granularities.NONE, Boolean.TRUE, Cursors.ascendingTimeOrder(), null), (Object)index.getMetadata());
    }

    @Test
    public void testPersistMerge() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        IncrementalIndex toPersist2 = new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setMaxRowCount(1000).build();
        toPersist2.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2")));
        toPersist2.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"5", (Object)"dim2", (Object)"6")));
        File tempDir1 = this.temporaryFolder.newFolder();
        File tempDir2 = this.temporaryFolder.newFolder();
        File mergedDir = this.temporaryFolder.newFolder();
        QueryableIndex index1 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist1, tempDir1, this.indexSpec, null)));
        Assert.assertEquals((long)2L, (long)index1.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)index1.getColumnNames().size());
        QueryableIndex index2 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist2, tempDir2, this.indexSpec, null)));
        Assert.assertEquals((long)2L, (long)index2.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index2.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)index2.getColumnNames().size());
        AggregatorFactory[] mergedAggregators = new AggregatorFactory[]{new CountAggregatorFactory("count")};
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(index1, index2), true, mergedAggregators, mergedDir, this.indexSpec, null, -1)));
        Assert.assertEquals((long)3L, (long)merged.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)merged.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)merged.getColumnNames().size());
        this.assertDimCompression(index2, this.indexSpec.getDimensionCompression());
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompression());
        this.assertDimCompression(merged, this.indexSpec.getDimensionCompression());
        Assert.assertArrayEquals((Object[])this.getCombiningAggregators(mergedAggregators), (Object[])merged.getMetadata().getAggregators());
    }

    @Test
    public void testPersistEmptyColumn() throws Exception {
        IncrementalIndex toPersist1 = new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[0]).setMaxRowCount(10).build();
        IncrementalIndex toPersist2 = new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[0]).setMaxRowCount(10).build();
        File tmpDir1 = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File tmpDir3 = this.temporaryFolder.newFolder();
        toPersist1.add((InputRow)new MapBasedInputRow(1L, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)ImmutableList.of(), (Object)"dim2", (Object)"foo")));
        toPersist2.add((InputRow)new MapBasedInputRow(1L, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)ImmutableList.of(), (Object)"dim2", (Object)"bar")));
        QueryableIndex index1 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist1, tmpDir1, this.indexSpec, null)));
        QueryableIndex index2 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist2, tmpDir2, this.indexSpec, null)));
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(index1, index2), true, new AggregatorFactory[0], tmpDir3, this.indexSpec, null, -1)));
        Assert.assertEquals((long)1L, (long)index1.getColumnHolder("__time").getLength());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim2"), (Object)ImmutableList.copyOf((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)1L, (long)index2.getColumnHolder("__time").getLength());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim2"), (Object)ImmutableList.copyOf((Iterable)index2.getAvailableDimensions()));
        Assert.assertEquals((long)2L, (long)merged.getColumnHolder("__time").getLength());
        Assert.assertEquals((Object)ImmutableList.of((Object)"dim2"), (Object)ImmutableList.copyOf((Iterable)merged.getAvailableDimensions()));
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompression());
        this.assertDimCompression(index2, this.indexSpec.getDimensionCompression());
        this.assertDimCompression(merged, this.indexSpec.getDimensionCompression());
    }

    @Test
    public void testMergeRetainsValues() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        File tempDir1 = this.temporaryFolder.newFolder();
        File mergedDir = this.temporaryFolder.newFolder();
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), (IncrementalIndexRowSelector)toPersist1, this.indexSpec.getBitmapSerdeFactory().getBitmapFactory());
        QueryableIndex index1 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist1, tempDir1, this.indexSpec, null)));
        QueryableIndexIndexableAdapter queryableAdapter = new QueryableIndexIndexableAdapter(index1);
        this.indexIO.validateTwoSegments((IndexableAdapter)incrementalAdapter, (IndexableAdapter)queryableAdapter);
        Assert.assertEquals((long)2L, (long)index1.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)index1.getColumnNames().size());
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex((List)ImmutableList.of((Object)index1), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, mergedDir, this.indexSpec, null, -1)));
        Assert.assertEquals((long)2L, (long)merged.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)merged.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)merged.getColumnNames().size());
        this.indexIO.validateTwoSegments(tempDir1, mergedDir);
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompression());
        this.assertDimCompression(merged, this.indexSpec.getDimensionCompression());
    }

    @Test
    public void testMergeSpecChange() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        File tempDir1 = this.temporaryFolder.newFolder();
        File mergedDir = this.temporaryFolder.newFolder();
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), (IncrementalIndexRowSelector)toPersist1, this.indexSpec.getBitmapSerdeFactory().getBitmapFactory());
        QueryableIndex index1 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist1, tempDir1, this.indexSpec, null)));
        QueryableIndexIndexableAdapter queryableAdapter = new QueryableIndexIndexableAdapter(index1);
        this.indexIO.validateTwoSegments((IndexableAdapter)incrementalAdapter, (IndexableAdapter)queryableAdapter);
        Assert.assertEquals((long)2L, (long)index1.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index1.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)index1.getColumnNames().size());
        IndexSpec.Builder builder = IndexSpec.builder().withBitmapSerdeFactory(this.indexSpec.getBitmapSerdeFactory());
        if (CompressionStrategy.LZ4.equals((Object)this.indexSpec.getDimensionCompression())) {
            builder.withDimensionCompression(CompressionStrategy.LZF).withMetricCompression(CompressionStrategy.LZF);
        } else {
            builder.withDimensionCompression(CompressionStrategy.LZ4).withMetricCompression(CompressionStrategy.LZ4);
        }
        if (CompressionFactory.LongEncodingStrategy.LONGS.equals((Object)this.indexSpec.getLongEncoding())) {
            builder.withLongEncoding(CompressionFactory.LongEncodingStrategy.AUTO);
        } else {
            builder.withLongEncoding(CompressionFactory.LongEncodingStrategy.LONGS);
        }
        IndexSpec newSpec = builder.build();
        AggregatorFactory[] mergedAggregators = new AggregatorFactory[]{new CountAggregatorFactory("count")};
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex((List)ImmutableList.of((Object)index1), true, mergedAggregators, mergedDir, newSpec, null, -1)));
        Assert.assertEquals((long)2L, (long)merged.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)merged.getAvailableDimensions()));
        Assert.assertEquals((long)3L, (long)merged.getColumnNames().size());
        this.indexIO.validateTwoSegments(tempDir1, mergedDir);
        this.assertDimCompression(index1, this.indexSpec.getDimensionCompression());
        this.assertDimCompression(merged, newSpec.getDimensionCompression());
    }

    private void assertDimCompression(QueryableIndex index, CompressionStrategy expectedStrategy) throws Exception {
        Object obj;
        Field field;
        if (expectedStrategy == null || expectedStrategy == CompressionStrategy.UNCOMPRESSED) {
            return;
        }
        DictionaryEncodedColumn encodedColumn = (DictionaryEncodedColumn)index.getColumnHolder("dim2").getColumn();
        if (encodedColumn.hasMultipleValues()) {
            field = StringUtf8DictionaryEncodedColumn.class.getDeclaredField("multiValueColumn");
            field.setAccessible(true);
            obj = field.get(encodedColumn);
        } else {
            field = StringUtf8DictionaryEncodedColumn.class.getDeclaredField("column");
            field.setAccessible(true);
            obj = field.get(encodedColumn);
        }
        Field compressedSupplierField = obj.getClass().getDeclaredField("this$0");
        compressedSupplierField.setAccessible(true);
        Object supplier = compressedSupplierField.get(obj);
        Field compressionField = supplier.getClass().getDeclaredField("compression");
        compressionField.setAccessible(true);
        Object strategy = compressionField.get(supplier);
        Assert.assertEquals((Object)expectedStrategy, (Object)strategy);
    }

    @Test
    public void testNonLexicographicDimOrderMerge() throws Exception {
        IncrementalIndex toPersist1 = this.getIndexD3();
        IncrementalIndex toPersist2 = this.getIndexD3();
        IncrementalIndex toPersist3 = this.getIndexD3();
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File tmpDir3 = this.temporaryFolder.newFolder();
        File tmpDirMerged = this.temporaryFolder.newFolder();
        QueryableIndex index1 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist1, tmpDir, this.indexSpec, null)));
        QueryableIndex index2 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist2, tmpDir2, this.indexSpec, null)));
        QueryableIndex index3 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist3, tmpDir3, this.indexSpec, null)));
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(index1, index2, index3), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged, this.indexSpec, null, -1)));
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals(Arrays.asList("__time", "d3", "d1", "d2"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
        Assert.assertEquals(Arrays.asList("d3", "d1", "d2"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
        Assert.assertEquals((long)3L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList("30000", "100", "4000"), rowList.get(0).dimensionValues());
        Assert.assertEquals(Collections.singletonList(3L), rowList.get(0).metricValues());
        Assert.assertEquals(Arrays.asList("40000", "300", "2000"), rowList.get(1).dimensionValues());
        Assert.assertEquals(Collections.singletonList(3L), rowList.get(1).metricValues());
        Assert.assertEquals(Arrays.asList("50000", "200", "3000"), rowList.get(2).dimensionValues());
        Assert.assertEquals(Collections.singletonList(3L), rowList.get(2).metricValues());
        this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "d3", null));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d3", "30000"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d3", "40000"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d3", "50000"));
        this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "d1", null));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d1", "100"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d1", "200"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d1", "300"));
        this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "d2", null));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d2", "2000"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d2", "3000"));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d2", "4000"));
    }

    @Test
    public void testMergeWithDimensionsList() throws Exception {
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(this.makeDimensionSchemas(Arrays.asList("dimA", "dimB", "dimC")))).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
        IncrementalIndex toPersist1 = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(1000).build();
        IncrementalIndex toPersist2 = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(1000).build();
        IncrementalIndex toPersist3 = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(1000).build();
        this.addDimValuesToIndex(toPersist1, "dimA", Arrays.asList("1", "2"));
        this.addDimValuesToIndex(toPersist2, "dimA", Arrays.asList("1", "2"));
        this.addDimValuesToIndex(toPersist3, "dimC", Arrays.asList("1", "2"));
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File tmpDir3 = this.temporaryFolder.newFolder();
        File tmpDirMerged = this.temporaryFolder.newFolder();
        QueryableIndex index1 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist1, tmpDir, this.indexSpec, null)));
        QueryableIndex index2 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist2, tmpDir2, this.indexSpec, null)));
        QueryableIndex index3 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist3, tmpDir3, this.indexSpec, null)));
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(index1, index2, index3), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged, this.indexSpec, null, -1)));
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimC"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
        Assert.assertEquals((Object)ImmutableList.of((Object)"dimA", (Object)"dimC"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
        Assert.assertEquals((long)4L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList(null, "1"), rowList.get(0).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList.get(0).metricValues());
        Assert.assertEquals(Arrays.asList(null, "2"), rowList.get(1).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList.get(1).metricValues());
        Assert.assertEquals(Arrays.asList("1", null), rowList.get(2).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(2).metricValues());
        Assert.assertEquals(Arrays.asList("2", null), rowList.get(3).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(3).metricValues());
        Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dimA").hasBitmapIndexes());
        Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dimC").hasBitmapIndexes());
        if (this.useBitmapIndexes) {
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", null));
            this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "1"));
            this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "2"));
            this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", null));
            this.checkBitmapIndex(Arrays.asList(2, 3), IndexMergerTestBase.getBitmapIndex(adapter, "dimC", null));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dimC", "1"));
            this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "dimC", "2"));
        }
        this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", ""));
    }

    @Test
    public void testMergePlainNonTimeOrdered() throws Exception {
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions((List)ImmutableList.of((Object)new StringDimensionSchema("dimA", null, Boolean.valueOf(this.useBitmapIndexes)), (Object)new StringDimensionSchema("dimB", null, Boolean.valueOf(this.useBitmapIndexes)), (Object)new StringDimensionSchema("dimC", null, Boolean.valueOf(this.useBitmapIndexes)))).setForceSegmentSortByTime(Boolean.valueOf(false)).build()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).withQueryGranularity(Granularities.NONE).withRollup(false).build();
        IncrementalIndex toPersist1 = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(1000).build();
        IncrementalIndex toPersist2 = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(1000).build();
        IncrementalIndex toPersist3 = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(1000).build();
        this.addDimValuesToIndex(toPersist1, "dimA", Arrays.asList("1", "2"));
        this.addDimValuesToIndex(toPersist2, "dimA", Arrays.asList("1", "2"));
        this.addDimValuesToIndex(toPersist3, "dimC", Arrays.asList("1", "2"));
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File tmpDir3 = this.temporaryFolder.newFolder();
        File tmpDirMerged = this.temporaryFolder.newFolder();
        QueryableIndex index1 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist1, tmpDir, this.indexSpec, null)));
        QueryableIndex index2 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist2, tmpDir2, this.indexSpec, null)));
        QueryableIndex index3 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist3, tmpDir3, this.indexSpec, null)));
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(index1, index2, index3), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged, this.indexSpec, null, -1)));
        Assert.assertEquals(Arrays.asList("dimA", "dimC"), (Object)Lists.newArrayList((Iterable)merged.getAvailableDimensions()));
        Assert.assertEquals(IndexMergerTestBase.makeOrderBys("dimA", "dimB", "dimC", "__time"), (Object)Lists.newArrayList((Iterable)merged.getOrdering()));
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimC"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
        Assert.assertEquals((Object)ImmutableList.of((Object)"dimA", (Object)"dimC"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
        Assert.assertEquals((long)4L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList(null, "1"), rowList.get(0).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList.get(0).metricValues());
        Assert.assertEquals(Arrays.asList(null, "2"), rowList.get(1).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList.get(1).metricValues());
        Assert.assertEquals(Arrays.asList("1", null), rowList.get(2).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(2).metricValues());
        Assert.assertEquals(Arrays.asList("2", null), rowList.get(3).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(3).metricValues());
        Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dimA").hasBitmapIndexes());
        Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dimC").hasBitmapIndexes());
        if (this.useBitmapIndexes) {
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", null));
            this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "1"));
            this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "2"));
            this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", null));
            this.checkBitmapIndex(Arrays.asList(2, 3), IndexMergerTestBase.getBitmapIndex(adapter, "dimC", null));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dimC", "1"));
            this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "dimC", "2"));
        }
        this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", ""));
    }

    @Test
    public void testDisjointDimMerge() throws Exception {
        IncrementalIndex toPersistA = this.getSingleDimIndex("dimA", Arrays.asList("1", "2"));
        IncrementalIndex toPersistB1 = this.getSingleDimIndex("dimB", Arrays.asList("1", "2", "3"));
        IncrementalIndex toPersistB2 = this.getIndexWithDims(Arrays.asList("dimA", "dimB"));
        this.addDimValuesToIndex(toPersistB2, "dimB", Arrays.asList("1", "2", "3"));
        for (IncrementalIndex toPersistB : Arrays.asList(toPersistB1, toPersistB2)) {
            File tmpDirA = this.temporaryFolder.newFolder();
            File tmpDirB = this.temporaryFolder.newFolder();
            File tmpDirMerged = this.temporaryFolder.newFolder();
            QueryableIndex indexA = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistA, tmpDirA, this.indexSpec, null)));
            QueryableIndex indexB = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistB, tmpDirB, this.indexSpec, null)));
            QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged, this.indexSpec, null, -1)));
            QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
            List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
            Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimB"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
            Assert.assertEquals((Object)ImmutableList.of((Object)"dimA", (Object)"dimB"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
            Assert.assertEquals((long)5L, (long)rowList.size());
            Assert.assertEquals(Arrays.asList(null, "1"), rowList.get(0).dimensionValues());
            Assert.assertEquals(Collections.singletonList(1L), rowList.get(0).metricValues());
            Assert.assertEquals(Arrays.asList(null, "2"), rowList.get(1).dimensionValues());
            Assert.assertEquals(Collections.singletonList(1L), rowList.get(1).metricValues());
            Assert.assertEquals(Arrays.asList(null, "3"), rowList.get(2).dimensionValues());
            Assert.assertEquals(Collections.singletonList(1L), rowList.get(2).metricValues());
            Assert.assertEquals(Arrays.asList("1", null), rowList.get(3).dimensionValues());
            Assert.assertEquals(Collections.singletonList(1L), rowList.get(3).metricValues());
            Assert.assertEquals(Arrays.asList("2", null), rowList.get(4).dimensionValues());
            Assert.assertEquals(Collections.singletonList(1L), rowList.get(4).metricValues());
            Assert.assertTrue((boolean)adapter.getCapabilities("dimA").hasBitmapIndexes());
            this.checkBitmapIndex(Arrays.asList(0, 1, 2), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", null));
            this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "1"));
            this.checkBitmapIndex(Collections.singletonList(4), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "2"));
            if (toPersistB == toPersistB2) {
                Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dimB").hasBitmapIndexes());
            }
            if (toPersistB == toPersistB2 && !this.useBitmapIndexes) continue;
            this.checkBitmapIndex(Arrays.asList(3, 4), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", null));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", "1"));
            this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", "2"));
            this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", "3"));
        }
    }

    @Test
    public void testJointDimMerge() throws Exception {
        IncrementalIndexSchema rollupIndexSchema = new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
        IncrementalIndexSchema noRollupIndexSchema = new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).withRollup(false).build();
        for (IncrementalIndexSchema indexSchema : Arrays.asList(rollupIndexSchema, noRollupIndexSchema)) {
            IncrementalIndex toPersistA = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
            toPersistA.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9"), (Map)ImmutableMap.of((Object)"d1", (Object)"", (Object)"d2", (Object)"", (Object)"d3", (Object)"310", (Object)"d7", (Object)"", (Object)"d9", (Object)"910")));
            toPersistA.add((InputRow)new MapBasedInputRow(2L, Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9"), (Map)ImmutableMap.of((Object)"d2", (Object)"210", (Object)"d3", (Object)"311", (Object)"d7", (Object)"710", (Object)"d8", (Object)"810", (Object)"d9", (Object)"911")));
            IncrementalIndex toPersistB = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
            toPersistB.add((InputRow)new MapBasedInputRow(3L, Arrays.asList("d4", "d5", "d6", "d7", "d8", "d9"), (Map)ImmutableMap.of((Object)"d5", (Object)"520", (Object)"d6", (Object)"620", (Object)"d7", (Object)"720", (Object)"d8", (Object)"820", (Object)"d9", (Object)"920")));
            toPersistB.add((InputRow)new MapBasedInputRow(4L, Arrays.asList("d4", "d5", "d6", "d7", "d8", "d9"), (Map)ImmutableMap.of((Object)"d5", (Object)"", (Object)"d6", (Object)"621", (Object)"d7", (Object)"", (Object)"d8", (Object)"821", (Object)"d9", (Object)"921")));
            File tmpDirA = this.temporaryFolder.newFolder();
            File tmpDirB = this.temporaryFolder.newFolder();
            File tmpDirMerged = this.temporaryFolder.newFolder();
            QueryableIndex indexA = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistA, tmpDirA, this.indexSpec, null)));
            QueryableIndex indexB = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistB, tmpDirB, this.indexSpec, null)));
            QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged, this.indexSpec, null, -1)));
            QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
            List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
            Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"d1", (Object)"d2", (Object)"d3", (Object)"d5", (Object)"d6", (Object)"d7", (Object)"d8", (Object)"d9"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
            Assert.assertEquals((Object)ImmutableList.of((Object)"d1", (Object)"d2", (Object)"d3", (Object)"d5", (Object)"d6", (Object)"d7", (Object)"d8", (Object)"d9"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
            Assert.assertEquals((long)4L, (long)rowList.size());
            Assert.assertEquals(Arrays.asList("", "", "310", null, null, "", null, "910"), rowList.get(0).dimensionValues());
            Assert.assertEquals(Arrays.asList(null, "210", "311", null, null, "710", "810", "911"), rowList.get(1).dimensionValues());
            Assert.assertEquals(Arrays.asList(null, null, null, "520", "620", "720", "820", "920"), rowList.get(2).dimensionValues());
            Assert.assertEquals(Arrays.asList(null, null, null, "", "621", "", "821", "921"), rowList.get(3).dimensionValues());
            this.checkBitmapIndex(Arrays.asList(2, 3), IndexMergerTestBase.getBitmapIndex(adapter, "d2", null));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "d5", null));
            this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "d7", null));
            this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d2", "210"));
            this.checkBitmapIndex(Arrays.asList(2, 3), IndexMergerTestBase.getBitmapIndex(adapter, "d3", null));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d3", "310"));
            this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d3", "311"));
            this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d5", "520"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "d6", null));
            this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d6", "620"));
            this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d6", "621"));
            this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d7", "710"));
            this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d7", "720"));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d8", null));
            this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d8", "810"));
            this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d8", "820"));
            this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d8", "821"));
            this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "d9", null));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d9", "910"));
            this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d9", "911"));
            this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d9", "920"));
            this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d9", "921"));
        }
    }

    @Test
    public void testNoRollupMergeWithDuplicateRow() throws Exception {
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).withRollup(false).build();
        IncrementalIndex toPersistA = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
        toPersistA.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9"), (Map)ImmutableMap.of((Object)"d1", (Object)"", (Object)"d2", (Object)"", (Object)"d3", (Object)"310", (Object)"d7", (Object)"", (Object)"d9", (Object)"910")));
        toPersistA.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9"), (Map)ImmutableMap.of((Object)"d1", (Object)"", (Object)"d2", (Object)"", (Object)"d3", (Object)"310", (Object)"d7", (Object)"", (Object)"d9", (Object)"910")));
        IncrementalIndex toPersistB = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
        toPersistB.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9"), (Map)ImmutableMap.of((Object)"d1", (Object)"", (Object)"d2", (Object)"", (Object)"d3", (Object)"310", (Object)"d7", (Object)"", (Object)"d9", (Object)"910")));
        toPersistB.add((InputRow)new MapBasedInputRow(4L, Arrays.asList("d4", "d5", "d6", "d7", "d8", "d9"), (Map)ImmutableMap.of((Object)"d5", (Object)"", (Object)"d6", (Object)"621", (Object)"d7", (Object)"", (Object)"d8", (Object)"821", (Object)"d9", (Object)"921")));
        File tmpDirA = this.temporaryFolder.newFolder();
        File tmpDirB = this.temporaryFolder.newFolder();
        File tmpDirMerged = this.temporaryFolder.newFolder();
        QueryableIndex indexA = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistA, tmpDirA, this.indexSpec, null)));
        QueryableIndex indexB = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistB, tmpDirB, this.indexSpec, null)));
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB), false, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged, this.indexSpec, null, -1)));
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"d1", (Object)"d2", (Object)"d3", (Object)"d5", (Object)"d6", (Object)"d7", (Object)"d8", (Object)"d9"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
        Assert.assertEquals((Object)ImmutableList.of((Object)"d1", (Object)"d2", (Object)"d3", (Object)"d5", (Object)"d6", (Object)"d7", (Object)"d8", (Object)"d9"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
        Assert.assertEquals((long)4L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList("", "", "310", null, null, "", null, "910"), rowList.get(0).dimensionValues());
        Assert.assertEquals(Arrays.asList("", "", "310", null, null, "", null, "910"), rowList.get(1).dimensionValues());
        Assert.assertEquals(Arrays.asList("", "", "310", null, null, "", null, "910"), rowList.get(2).dimensionValues());
        Assert.assertEquals(Arrays.asList(null, null, null, "", "621", "", "821", "921"), rowList.get(3).dimensionValues());
        this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d3", null));
        this.checkBitmapIndex(Arrays.asList(0, 1, 2), IndexMergerTestBase.getBitmapIndex(adapter, "d3", "310"));
        this.checkBitmapIndex(Arrays.asList(0, 1, 2), IndexMergerTestBase.getBitmapIndex(adapter, "d6", null));
        this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d6", "621"));
        this.checkBitmapIndex(Arrays.asList(0, 1, 2), IndexMergerTestBase.getBitmapIndex(adapter, "d8", null));
        this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d8", "821"));
        this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "d9", null));
        this.checkBitmapIndex(Arrays.asList(0, 1, 2), IndexMergerTestBase.getBitmapIndex(adapter, "d9", "910"));
        this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d9", "921"));
    }

    private void checkBitmapIndex(List<Integer> expected, BitmapValues real) {
        Assert.assertEquals((String)"bitmap size", (long)expected.size(), (long)real.size());
        int i = 0;
        IntIterator iterator = real.iterator();
        while (iterator.hasNext()) {
            int index = iterator.nextInt();
            Assert.assertEquals((Object)expected.get(i++), (Object)index);
        }
    }

    @Test
    public void testMergeWithSupersetOrdering() throws Exception {
        IncrementalIndex toPersistA = this.getSingleDimIndex("dimA", Arrays.asList("1", "2"));
        IncrementalIndex toPersistB = this.getSingleDimIndex("dimB", Arrays.asList("1", "2", "3"));
        IncrementalIndex toPersistBA = this.getSingleDimIndex("dimB", Arrays.asList("1", "2", "3"));
        this.addDimValuesToIndex(toPersistBA, "dimA", Arrays.asList("1", "2"));
        IncrementalIndex toPersistBA2 = new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setMaxRowCount(1000).build();
        toPersistBA2.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("dimB", "dimA"), (Map)ImmutableMap.of((Object)"dimB", (Object)"1")));
        toPersistBA2.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("dimB", "dimA"), (Map)ImmutableMap.of((Object)"dimA", (Object)"1")));
        IncrementalIndex toPersistC = this.getSingleDimIndex("dimA", Arrays.asList("1", "2"));
        this.addDimValuesToIndex(toPersistC, "dimC", Arrays.asList("1", "2", "3"));
        File tmpDirA = this.temporaryFolder.newFolder();
        File tmpDirB = this.temporaryFolder.newFolder();
        File tmpDirBA = this.temporaryFolder.newFolder();
        File tmpDirBA2 = this.temporaryFolder.newFolder();
        File tmpDirC = this.temporaryFolder.newFolder();
        File tmpDirMerged = this.temporaryFolder.newFolder();
        File tmpDirMerged2 = this.temporaryFolder.newFolder();
        QueryableIndex indexA = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistA, tmpDirA, this.indexSpec, null)));
        QueryableIndex indexB = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistB, tmpDirB, this.indexSpec, null)));
        QueryableIndex indexBA = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistBA, tmpDirBA, this.indexSpec, null)));
        QueryableIndex indexBA2 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistBA2, tmpDirBA2, this.indexSpec, null)));
        QueryableIndex indexC = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistC, tmpDirC, this.indexSpec, null)));
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB, indexBA, indexBA2), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged, this.indexSpec, null, -1)));
        QueryableIndex merged2 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB, indexBA, indexC), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged2, this.indexSpec, null, -1)));
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        QueryableIndexIndexableAdapter adapter2 = new QueryableIndexIndexableAdapter(merged2);
        List<DebugRow> rowList2 = RowIteratorHelper.toList((RowIterator)adapter2.getRows());
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"dimB", (Object)"dimA"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
        Assert.assertEquals((Object)ImmutableList.of((Object)"dimB", (Object)"dimA"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
        Assert.assertEquals((long)5L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList(null, "1"), rowList.get(0).dimensionValues());
        Assert.assertEquals(Collections.singletonList(3L), rowList.get(0).metricValues());
        Assert.assertEquals(Arrays.asList(null, "2"), rowList.get(1).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(1).metricValues());
        Assert.assertEquals(Arrays.asList("1", null), rowList.get(2).dimensionValues());
        Assert.assertEquals(Collections.singletonList(3L), rowList.get(2).metricValues());
        Assert.assertEquals(Arrays.asList("2", null), rowList.get(3).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(3).metricValues());
        Assert.assertEquals(Arrays.asList("3", null), rowList.get(4).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(4).metricValues());
        this.checkBitmapIndex(Arrays.asList(2, 3, 4), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", null));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "1"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "2"));
        this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", null));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", "1"));
        this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", "2"));
        this.checkBitmapIndex(Collections.singletonList(4), IndexMergerTestBase.getBitmapIndex(adapter, "dimB", "3"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimB", (Object)"dimC"), (Object)ImmutableList.copyOf((Collection)adapter2.getDimensionNames(true)));
        Assert.assertEquals((Object)ImmutableList.of((Object)"dimA", (Object)"dimB", (Object)"dimC"), (Object)ImmutableList.copyOf((Collection)adapter2.getDimensionNames(false)));
        Assert.assertEquals((long)12L, (long)rowList2.size());
        Assert.assertEquals(Arrays.asList(null, null, "1"), rowList2.get(0).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList2.get(0).metricValues());
        Assert.assertEquals(Arrays.asList(null, null, "2"), rowList2.get(1).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList2.get(1).metricValues());
        Assert.assertEquals(Arrays.asList(null, null, "3"), rowList2.get(2).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList2.get(2).metricValues());
        Assert.assertEquals(Arrays.asList(null, "1", null), rowList2.get(3).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList2.get(3).metricValues());
        Assert.assertEquals(Arrays.asList(null, "2", null), rowList2.get(4).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList2.get(4).metricValues());
        Assert.assertEquals(Arrays.asList(null, "3", null), rowList2.get(5).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList2.get(5).metricValues());
        Assert.assertEquals(Arrays.asList("1", null, null), rowList2.get(6).dimensionValues());
        Assert.assertEquals(Collections.singletonList(3L), rowList2.get(6).metricValues());
        Assert.assertEquals(Arrays.asList("2", null, null), rowList2.get(7).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList2.get(7).metricValues());
        Assert.assertEquals(Arrays.asList(null, "1", null), rowList2.get(8).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList2.get(8).metricValues());
        Assert.assertEquals(Arrays.asList(null, "2", null), rowList2.get(9).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList2.get(9).metricValues());
        Assert.assertEquals(Arrays.asList(null, "3", null), rowList2.get(10).dimensionValues());
        Assert.assertEquals(Collections.singletonList(1L), rowList2.get(10).metricValues());
        Assert.assertEquals(Arrays.asList("2", null, null), rowList2.get(11).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList2.get(11).metricValues());
        this.checkBitmapIndex(Arrays.asList(0, 1, 2, 3, 4, 5, 8, 9, 10), IndexMergerTestBase.getBitmapIndex(adapter2, "dimA", null));
        this.checkBitmapIndex(Collections.singletonList(6), IndexMergerTestBase.getBitmapIndex(adapter2, "dimA", "1"));
        this.checkBitmapIndex(Arrays.asList(7, 11), IndexMergerTestBase.getBitmapIndex(adapter2, "dimA", "2"));
        this.checkBitmapIndex(Arrays.asList(0, 1, 2, 6, 7, 11), IndexMergerTestBase.getBitmapIndex(adapter2, "dimB", null));
        this.checkBitmapIndex(Arrays.asList(3, 8), IndexMergerTestBase.getBitmapIndex(adapter2, "dimB", "1"));
        this.checkBitmapIndex(Arrays.asList(4, 9), IndexMergerTestBase.getBitmapIndex(adapter2, "dimB", "2"));
        this.checkBitmapIndex(Arrays.asList(5, 10), IndexMergerTestBase.getBitmapIndex(adapter2, "dimB", "3"));
        this.checkBitmapIndex(Arrays.asList(3, 4, 5, 6, 7, 8, 9, 10, 11), IndexMergerTestBase.getBitmapIndex(adapter2, "dimC", null));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter2, "dimC", "1"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter2, "dimC", "2"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter2, "dimC", "3"));
    }

    @Test
    public void testMismatchedDimensions() throws IOException {
        IncrementalIndex index1 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A")});
        index1.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d1", "d2"), (Map)ImmutableMap.of((Object)"d1", (Object)"a", (Object)"d2", (Object)"z", (Object)"A", (Object)1)));
        this.closer.closeLater(index1);
        IncrementalIndex index2 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("C", "C")});
        index2.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d1", "d2"), (Map)ImmutableMap.of((Object)"d1", (Object)"a", (Object)"d2", (Object)"z", (Object)"A", (Object)2, (Object)"C", (Object)100)));
        this.closer.closeLater(index2);
        Interval interval = new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc());
        RoaringBitmapFactory factory = new RoaringBitmapFactory();
        List<IndexableAdapter> toMerge = Arrays.asList(new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index1, (BitmapFactory)factory), new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index2, (BitmapFactory)factory));
        File tmpDirMerged = this.temporaryFolder.newFolder();
        this.indexMerger.merge(toMerge, true, new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("C", "C")}, tmpDirMerged, null, this.indexSpec, -1);
    }

    @Test
    public void testAddMetrics() throws IOException {
        IncrementalIndex index1 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A")});
        this.closer.closeLater(index1);
        long timestamp = System.currentTimeMillis();
        index1.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2", (Object)"A", (Object)5)));
        IncrementalIndex index2 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("C", "C")});
        index2.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2", (Object)"A", (Object)5, (Object)"C", (Object)6)));
        this.closer.closeLater(index2);
        Interval interval = new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc());
        RoaringBitmapFactory factory = new RoaringBitmapFactory();
        List<IndexableAdapter> toMerge = Arrays.asList(new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index1, (BitmapFactory)factory), new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index2, (BitmapFactory)factory));
        File tmpDirMerged = this.temporaryFolder.newFolder();
        File merged = this.indexMerger.merge(toMerge, true, new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("C", "C")}, tmpDirMerged, null, this.indexSpec, -1);
        QueryableIndexSegment segment = new QueryableIndexSegment(this.closer.closeLater(this.indexIO.loadIndex(merged)), SegmentId.dummy((String)"test"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"C"), Arrays.stream(((PhysicalSegmentInspector)segment.as(PhysicalSegmentInspector.class)).getMetadata().getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toSet()));
    }

    @Test
    public void testAddMetricsBothSidesNull() throws IOException {
        IncrementalIndex index1 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A")});
        this.closer.closeLater(index1);
        long timestamp = System.currentTimeMillis();
        index1.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2", (Object)"A", (Object)5)));
        IncrementalIndex index2 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("C", "C")});
        index2.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2", (Object)"A", (Object)5, (Object)"C", (Object)6)));
        this.closer.closeLater(index2);
        IncrementalIndex index3 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A")});
        index3.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", (Object)"1", (Object)"dim2", (Object)"2", (Object)"A", (Object)5)));
        Interval interval = new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc());
        RoaringBitmapFactory factory = new RoaringBitmapFactory();
        List<IndexableAdapter> toMerge = Arrays.asList(new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index1, (BitmapFactory)factory), new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index2, (BitmapFactory)factory), new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index3, (BitmapFactory)factory));
        File tmpDirMerged = this.temporaryFolder.newFolder();
        File merged = this.indexMerger.merge(toMerge, true, new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("C", "C")}, tmpDirMerged, null, this.indexSpec, -1);
        QueryableIndexSegment segment = new QueryableIndexSegment(this.closer.closeLater(this.indexIO.loadIndex(merged)), SegmentId.dummy((String)"test"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"C"), Arrays.stream(((PhysicalSegmentInspector)segment.as(PhysicalSegmentInspector.class)).getMetadata().getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toSet()));
    }

    @Test
    public void testMismatchedMetrics() throws IOException {
        IncrementalIndex index1 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A")});
        this.closer.closeLater(index1);
        IncrementalIndex index2 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("C", "C")});
        this.closer.closeLater(index2);
        IncrementalIndex index3 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("B", "B")});
        this.closer.closeLater(index3);
        IncrementalIndex index4 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("C", "C"), new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("B", "B")});
        this.closer.closeLater(index4);
        IncrementalIndex index5 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("C", "C"), new LongSumAggregatorFactory("B", "B")});
        this.closer.closeLater(index5);
        Interval interval = new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc());
        RoaringBitmapFactory factory = new RoaringBitmapFactory();
        List<IndexableAdapter> toMerge = Arrays.asList(new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index1, (BitmapFactory)factory), new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index2, (BitmapFactory)factory), new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index3, (BitmapFactory)factory), new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index4, (BitmapFactory)factory), new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index5, (BitmapFactory)factory));
        File tmpDirMerged = this.temporaryFolder.newFolder();
        File merged = this.indexMerger.merge(toMerge, true, new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("B", "B"), new LongSumAggregatorFactory("C", "C"), new LongSumAggregatorFactory("D", "D")}, tmpDirMerged, null, this.indexSpec, -1);
        QueryableIndexSegment segment = new QueryableIndexSegment(this.closer.closeLater(this.indexIO.loadIndex(merged)), SegmentId.dummy((String)"test"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C"), Arrays.stream(((PhysicalSegmentInspector)segment.as(PhysicalSegmentInspector.class)).getMetadata().getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toSet()));
    }

    @Test(expected=IAE.class)
    public void testMismatchedMetricsVarying() throws IOException {
        IncrementalIndex index2 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("C", "C")});
        this.closer.closeLater(index2);
        IncrementalIndex index5 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("C", "C"), new LongSumAggregatorFactory("B", "B")});
        this.closer.closeLater(index5);
        Interval interval = new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.nowUtc());
        RoaringBitmapFactory factory = new RoaringBitmapFactory();
        List<IncrementalIndexAdapter> toMerge = Collections.singletonList(new IncrementalIndexAdapter(interval, (IncrementalIndexRowSelector)index2, (BitmapFactory)factory));
        File tmpDirMerged = this.temporaryFolder.newFolder();
        File merged = this.indexMerger.merge(toMerge, true, new AggregatorFactory[]{new LongSumAggregatorFactory("B", "B"), new LongSumAggregatorFactory("A", "A"), new LongSumAggregatorFactory("D", "D")}, tmpDirMerged, null, this.indexSpec, -1);
        QueryableIndexSegment segment = new QueryableIndexSegment(this.closer.closeLater(this.indexIO.loadIndex(merged)), SegmentId.dummy((String)"test"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"A", (Object)"B", (Object)"C"), Arrays.stream(((PhysicalSegmentInspector)segment.as(PhysicalSegmentInspector.class)).getMetadata().getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toSet()));
    }

    @Test
    public void testMergeNumericDims() throws Exception {
        IncrementalIndex toPersist1 = this.getIndexWithNumericDims();
        IncrementalIndex toPersist2 = this.getIndexWithNumericDims();
        File tmpDir = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File tmpDirMerged = this.temporaryFolder.newFolder();
        QueryableIndex index1 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist1, tmpDir, this.indexSpec, null)));
        QueryableIndex index2 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist2, tmpDir2, this.indexSpec, null)));
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(index1, index2), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged, this.indexSpec, null, -1)));
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimB", (Object)"dimC"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
        Assert.assertEquals((Object)ImmutableList.of((Object)"dimA", (Object)"dimB", (Object)"dimC"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
        Assert.assertEquals((long)4L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList(null, null, "Nully Row"), rowList.get(0).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(0).metricValues());
        Assert.assertEquals(Arrays.asList(72L, Float.valueOf(60000.79f), "World"), rowList.get(1).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(0).metricValues());
        Assert.assertEquals(Arrays.asList(100L, Float.valueOf(4000.567f), "Hello"), rowList.get(2).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(1).metricValues());
        Assert.assertEquals(Arrays.asList(3001L, Float.valueOf(1.2345f), "Foobar"), rowList.get(3).dimensionValues());
        Assert.assertEquals(Collections.singletonList(2L), rowList.get(2).metricValues());
    }

    private IncrementalIndex getIndexWithNumericDims() throws Exception {
        IncrementalIndex index = this.getIndexWithDimsFromSchemata(Arrays.asList(new LongDimensionSchema("dimA"), new FloatDimensionSchema("dimB"), new StringDimensionSchema("dimC", DimensionSchema.MultiValueHandling.SORTED_ARRAY, Boolean.valueOf(this.useBitmapIndexes))));
        index.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("dimA", "dimB", "dimC"), (Map)ImmutableMap.of((Object)"dimA", (Object)100L, (Object)"dimB", (Object)4000.567, (Object)"dimC", (Object)"Hello")));
        index.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("dimA", "dimB", "dimC"), (Map)ImmutableMap.of((Object)"dimA", (Object)72L, (Object)"dimB", (Object)60000.789, (Object)"dimC", (Object)"World")));
        index.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("dimA", "dimB", "dimC"), (Map)ImmutableMap.of((Object)"dimA", (Object)3001L, (Object)"dimB", (Object)1.2345, (Object)"dimC", (Object)"Foobar")));
        index.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("dimA", "dimB", "dimC"), (Map)ImmutableMap.of((Object)"dimC", (Object)"Nully Row")));
        return index;
    }

    private IncrementalIndex getIndexWithDimsFromSchemata(List<DimensionSchema> dims) {
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(dims)).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
        return new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(1000).build();
    }

    @Test
    public void testPersistNullColumnSkipping() throws Exception {
        IncrementalIndex index1 = IncrementalIndexTest.createIndex(new AggregatorFactory[]{new LongSumAggregatorFactory("A", "A")});
        index1.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d1", "d2"), (Map)ImmutableMap.of((Object)"d1", (Object)"a", (Object)"A", (Object)1)));
        index1.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d1", "d2"), (Map)ImmutableMap.of((Object)"d1", (Object)"b", (Object)"A", (Object)1)));
        File tempDir = this.temporaryFolder.newFolder();
        QueryableIndex index = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(index1, tempDir, this.indexSpec, null)));
        List<String> expectedColumnNames = Arrays.asList("A", "d1");
        ArrayList actualColumnNames = Lists.newArrayList((Iterable)index.getColumnNames());
        Collections.sort(expectedColumnNames);
        Collections.sort(actualColumnNames);
        Assert.assertEquals(expectedColumnNames, (Object)actualColumnNames);
        SmooshedFileMapper sfm = this.closer.closeLater(SmooshedFileMapper.load((File)tempDir));
        List<String> expectedFilenames = Arrays.asList("A", "__time", "d1", "index.drd", "metadata.drd");
        ArrayList actualFilenames = new ArrayList(sfm.getInternalFilenames());
        Collections.sort(expectedFilenames);
        Collections.sort(actualFilenames);
        Assert.assertEquals(expectedFilenames, actualFilenames);
    }

    private IncrementalIndex getIndexD3() throws Exception {
        IncrementalIndex toPersist1 = new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setMaxRowCount(1000).build();
        toPersist1.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d3", "d1", "d2"), (Map)ImmutableMap.of((Object)"d1", (Object)"100", (Object)"d2", (Object)"4000", (Object)"d3", (Object)"30000")));
        toPersist1.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d3", "d1", "d2"), (Map)ImmutableMap.of((Object)"d1", (Object)"300", (Object)"d2", (Object)"2000", (Object)"d3", (Object)"40000")));
        toPersist1.add((InputRow)new MapBasedInputRow(1L, Arrays.asList("d3", "d1", "d2"), (Map)ImmutableMap.of((Object)"d1", (Object)"200", (Object)"d2", (Object)"3000", (Object)"d3", (Object)"50000")));
        return toPersist1;
    }

    private IncrementalIndex getSingleDimIndex(String dimName, List<String> values) throws Exception {
        IncrementalIndex toPersist1 = new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setMaxRowCount(1000).build();
        this.addDimValuesToIndex(toPersist1, dimName, values);
        return toPersist1;
    }

    private void addDimValuesToIndex(IncrementalIndex index, String dimName, List<String> values) throws Exception {
        for (String val : values) {
            index.add((InputRow)new MapBasedInputRow(1L, Collections.singletonList(dimName), (Map)ImmutableMap.of((Object)dimName, (Object)val)));
        }
    }

    private IncrementalIndex getIndexWithDims(List<String> dims) {
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(this.makeDimensionSchemas(dims))).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
        return new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(1000).build();
    }

    private AggregatorFactory[] getCombiningAggregators(AggregatorFactory[] aggregators) {
        AggregatorFactory[] combiningAggregators = new AggregatorFactory[aggregators.length];
        for (int i = 0; i < aggregators.length; ++i) {
            combiningAggregators[i] = aggregators[i].getCombiningFactory();
        }
        return combiningAggregators;
    }

    @Test
    public void testMultiValueHandling() throws Exception {
        InputRow[] rows = new InputRow[]{new MapBasedInputRow(1L, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", Arrays.asList("x", "a", "a", "b"), (Object)"dim2", Arrays.asList("a", "x", "b", "x"))), new MapBasedInputRow(1L, Arrays.asList("dim1", "dim2"), (Map)ImmutableMap.of((Object)"dim1", Arrays.asList("a", "b", "x"), (Object)"dim2", Arrays.asList("x", "a", "b")))};
        List<DimensionSchema> schema = this.makeDimensionSchemas(Arrays.asList("dim1", "dim2"), DimensionSchema.MultiValueHandling.SORTED_ARRAY);
        QueryableIndex index = this.persistAndLoad(schema, rows);
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(index);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((long)2L, (long)index.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
        Assert.assertEquals(IndexMergerTestBase.makeOrderBys("__time", "dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getOrdering()));
        Assert.assertEquals((long)3L, (long)index.getColumnNames().size());
        Assert.assertEquals((long)2L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList(Arrays.asList("a", "a", "b", "x"), Arrays.asList("a", "b", "x", "x")), rowList.get(0).dimensionValues());
        Assert.assertEquals(Arrays.asList(Arrays.asList("a", "b", "x"), Arrays.asList("a", "b", "x")), rowList.get(1).dimensionValues());
        Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dim1").hasBitmapIndexes());
        Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dim2").hasBitmapIndexes());
        if (this.useBitmapIndexes) {
            this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", null));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "a"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "b"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "x"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", "a"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", "b"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", "x"));
        }
        schema = this.makeDimensionSchemas(Arrays.asList("dim1", "dim2"), DimensionSchema.MultiValueHandling.SORTED_SET);
        index = this.persistAndLoad(schema, rows);
        Assert.assertEquals((long)1L, (long)index.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
        Assert.assertEquals(IndexMergerTestBase.makeOrderBys("__time", "dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getOrdering()));
        Assert.assertEquals((long)3L, (long)index.getColumnNames().size());
        adapter = new QueryableIndexIndexableAdapter(index);
        rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((long)1L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList(Arrays.asList("a", "b", "x"), Arrays.asList("a", "b", "x")), rowList.get(0).dimensionValues());
        Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dim1").hasBitmapIndexes());
        Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dim2").hasBitmapIndexes());
        if (this.useBitmapIndexes) {
            this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", null));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "a"));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "b"));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "x"));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", "a"));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", "b"));
            this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", "x"));
        }
        schema = this.makeDimensionSchemas(Arrays.asList("dim1", "dim2"), DimensionSchema.MultiValueHandling.ARRAY);
        index = this.persistAndLoad(schema, rows);
        Assert.assertEquals((long)2L, (long)index.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
        Assert.assertEquals(IndexMergerTestBase.makeOrderBys("__time", "dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getOrdering()));
        Assert.assertEquals((long)3L, (long)index.getColumnNames().size());
        adapter = new QueryableIndexIndexableAdapter(index);
        rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((long)2L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList(Arrays.asList("a", "b", "x"), Arrays.asList("x", "a", "b")), rowList.get(0).dimensionValues());
        Assert.assertEquals(Arrays.asList(Arrays.asList("x", "a", "a", "b"), Arrays.asList("a", "x", "b", "x")), rowList.get(1).dimensionValues());
        Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dim1").hasBitmapIndexes());
        Assert.assertEquals((Object)this.useBitmapIndexes, (Object)adapter.getCapabilities("dim2").hasBitmapIndexes());
        if (this.useBitmapIndexes) {
            this.checkBitmapIndex(Collections.emptyList(), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", null));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "a"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "b"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim1", "x"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", "a"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", "b"));
            this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dim2", "x"));
        }
    }

    @Test
    public void testDimensionWithEmptyName() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist = IncrementalIndexTest.createIndex(null);
        IncrementalIndexTest.populateIndex(timestamp, toPersist);
        toPersist.add((InputRow)new MapBasedInputRow(timestamp, Arrays.asList("", "dim2"), (Map)ImmutableMap.of((Object)"", (Object)"1", (Object)"dim2", (Object)"2")));
        File tempDir = this.temporaryFolder.newFolder();
        QueryableIndex index = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, this.indexSpec, null)));
        Assert.assertEquals((long)3L, (long)index.getColumnHolder("__time").getLength());
        Assert.assertEquals(Arrays.asList("dim1", "dim2"), (Object)Lists.newArrayList((Iterable)index.getAvailableDimensions()));
        Assert.assertEquals(IndexMergerTestBase.makeOrderBys("__time"), (Object)Lists.newArrayList((Iterable)index.getOrdering()));
        Assert.assertEquals((long)3L, (long)index.getColumnNames().size());
        this.assertDimCompression(index, this.indexSpec.getDimensionCompression());
        Assert.assertArrayEquals((Object[])IncrementalIndexTest.getDefaultCombiningAggregatorFactories(), (Object[])index.getMetadata().getAggregators());
        Assert.assertEquals((Object)Granularities.NONE, (Object)index.getMetadata().getQueryGranularity());
    }

    @Test
    public void testMultivalDim_mergeAcrossSegments_rollupWorks() throws Exception {
        List<String> dims = Arrays.asList("dimA", "dimMultiVal");
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("dimA", DimensionSchema.MultiValueHandling.SORTED_ARRAY, Boolean.valueOf(true)), (Object)new StringDimensionSchema("dimMultiVal", DimensionSchema.MultiValueHandling.SORTED_ARRAY, Boolean.valueOf(true))))).withMetrics(new AggregatorFactory[]{new LongSumAggregatorFactory("sumCount", "sumCount")}).withRollup(true).build();
        IncrementalIndex toPersistA = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
        HashMap<String, Object> event1 = new HashMap<String, Object>();
        event1.put("dimA", "leek");
        event1.put("dimMultiVal", ImmutableList.of((Object)"1", (Object)"2", (Object)"4"));
        event1.put("sumCount", 1L);
        HashMap<String, Object> event2 = new HashMap<String, Object>();
        event2.put("dimA", "leek");
        event2.put("dimMultiVal", ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5"));
        event2.put("sumCount", 1L);
        toPersistA.add((InputRow)new MapBasedInputRow(1L, dims, event1));
        toPersistA.add((InputRow)new MapBasedInputRow(1L, dims, event2));
        IncrementalIndex toPersistB = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
        HashMap<String, Object> event3 = new HashMap<String, Object>();
        event3.put("dimA", "leek");
        event3.put("dimMultiVal", ImmutableList.of((Object)"1", (Object)"2", (Object)"4"));
        event3.put("sumCount", 1L);
        HashMap<String, Object> event4 = new HashMap<String, Object>();
        event4.put("dimA", "potato");
        event4.put("dimMultiVal", ImmutableList.of((Object)"0", (Object)"1", (Object)"4"));
        event4.put("sumCount", 1L);
        toPersistB.add((InputRow)new MapBasedInputRow(1L, dims, event3));
        toPersistB.add((InputRow)new MapBasedInputRow(1L, dims, event4));
        File tmpDirA = this.temporaryFolder.newFolder();
        File tmpDirB = this.temporaryFolder.newFolder();
        File tmpDirMerged = this.temporaryFolder.newFolder();
        QueryableIndex indexA = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistA, tmpDirA, this.indexSpec, null)));
        QueryableIndex indexB = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistB, tmpDirB, this.indexSpec, null)));
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB), true, new AggregatorFactory[]{new LongSumAggregatorFactory("sumCount", "sumCount")}, tmpDirMerged, this.indexSpec, null, -1)));
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimMultiVal"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
        Assert.assertEquals((Object)ImmutableList.of((Object)"dimA", (Object)"dimMultiVal"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
        Assert.assertEquals((long)3L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList("leek", Arrays.asList("1", "2", "3", "5")), rowList.get(0).dimensionValues());
        Assert.assertEquals((Object)1L, (Object)rowList.get(0).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", Arrays.asList("1", "2", "4")), rowList.get(1).dimensionValues());
        Assert.assertEquals((Object)2L, (Object)rowList.get(1).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("potato", Arrays.asList("0", "1", "4")), rowList.get(2).dimensionValues());
        Assert.assertEquals((Object)1L, (Object)rowList.get(2).metricValues().get(0));
        this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "leek"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "potato"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "0"));
        this.checkBitmapIndex(Arrays.asList(0, 1, 2), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "1"));
        this.checkBitmapIndex(Arrays.asList(0, 1), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "2"));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "3"));
        this.checkBitmapIndex(Arrays.asList(1, 2), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "4"));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "5"));
    }

    @Test
    public void testMultivalDim_persistAndMerge_dimensionValueOrderingRules() throws Exception {
        List<String> dims = Arrays.asList("dimA", "dimMultiVal");
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("dimA", DimensionSchema.MultiValueHandling.SORTED_ARRAY, Boolean.valueOf(true)), (Object)new StringDimensionSchema("dimMultiVal", DimensionSchema.MultiValueHandling.SORTED_ARRAY, Boolean.valueOf(true))))).withMetrics(new AggregatorFactory[]{new LongSumAggregatorFactory("sumCount", "sumCount")}).withRollup(true).build();
        HashMap<String, Object> nullEvent = new HashMap<String, Object>();
        nullEvent.put("dimA", "leek");
        nullEvent.put("sumCount", 1L);
        HashMap<String, Object> nullEvent2 = new HashMap<String, Object>();
        nullEvent2.put("dimA", "leek");
        nullEvent2.put("dimMultiVal", null);
        nullEvent2.put("sumCount", 1L);
        HashMap<String, Object> emptyListEvent = new HashMap<String, Object>();
        emptyListEvent.put("dimA", "leek");
        emptyListEvent.put("dimMultiVal", ImmutableList.of());
        emptyListEvent.put("sumCount", 1L);
        ArrayList<Object> listWithNull = new ArrayList<Object>();
        listWithNull.add(null);
        HashMap<String, Object> listWithNullEvent = new HashMap<String, Object>();
        listWithNullEvent.put("dimA", "leek");
        listWithNullEvent.put("dimMultiVal", listWithNull);
        listWithNullEvent.put("sumCount", 1L);
        HashMap<String, Object> emptyStringEvent = new HashMap<String, Object>();
        emptyStringEvent.put("dimA", "leek");
        emptyStringEvent.put("dimMultiVal", "");
        emptyStringEvent.put("sumCount", 1L);
        HashMap<String, Object> listWithEmptyStringEvent = new HashMap<String, Object>();
        listWithEmptyStringEvent.put("dimA", "leek");
        listWithEmptyStringEvent.put("dimMultiVal", ImmutableList.of((Object)""));
        listWithEmptyStringEvent.put("sumCount", 1L);
        HashMap<String, Object> singleValEvent = new HashMap<String, Object>();
        singleValEvent.put("dimA", "leek");
        singleValEvent.put("dimMultiVal", "1");
        singleValEvent.put("sumCount", 1L);
        HashMap<String, Object> singleValEvent2 = new HashMap<String, Object>();
        singleValEvent2.put("dimA", "leek");
        singleValEvent2.put("dimMultiVal", "2");
        singleValEvent2.put("sumCount", 1L);
        HashMap<String, Object> singleValEvent3 = new HashMap<String, Object>();
        singleValEvent3.put("dimA", "potato");
        singleValEvent3.put("dimMultiVal", "2");
        singleValEvent3.put("sumCount", 1L);
        HashMap<String, Object> listWithSingleValEvent = new HashMap<String, Object>();
        listWithSingleValEvent.put("dimA", "leek");
        listWithSingleValEvent.put("dimMultiVal", ImmutableList.of((Object)"1"));
        listWithSingleValEvent.put("sumCount", 1L);
        HashMap<String, Object> listWithSingleValEvent2 = new HashMap<String, Object>();
        listWithSingleValEvent2.put("dimA", "leek");
        listWithSingleValEvent2.put("dimMultiVal", ImmutableList.of((Object)"2"));
        listWithSingleValEvent2.put("sumCount", 1L);
        HashMap<String, Object> listWithSingleValEvent3 = new HashMap<String, Object>();
        listWithSingleValEvent3.put("dimA", "potato");
        listWithSingleValEvent3.put("dimMultiVal", ImmutableList.of((Object)"2"));
        listWithSingleValEvent3.put("sumCount", 1L);
        HashMap<String, Object> multivalEvent = new HashMap<String, Object>();
        multivalEvent.put("dimA", "leek");
        multivalEvent.put("dimMultiVal", ImmutableList.of((Object)"1", (Object)"3"));
        multivalEvent.put("sumCount", 1L);
        HashMap<String, Object> multivalEvent2 = new HashMap<String, Object>();
        multivalEvent2.put("dimA", "leek");
        multivalEvent2.put("dimMultiVal", ImmutableList.of((Object)"1", (Object)"4"));
        multivalEvent2.put("sumCount", 1L);
        HashMap<String, Object> multivalEvent3 = new HashMap<String, Object>();
        multivalEvent3.put("dimA", "leek");
        multivalEvent3.put("dimMultiVal", ImmutableList.of((Object)"1", (Object)"3", (Object)"5"));
        multivalEvent3.put("sumCount", 1L);
        HashMap<String, Object> multivalEvent4 = new HashMap<String, Object>();
        multivalEvent4.put("dimA", "leek");
        multivalEvent4.put("dimMultiVal", ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        multivalEvent4.put("sumCount", 1L);
        List<String> multivalEvent5List = Arrays.asList("1", "2", "3", null);
        HashMap<String, Object> multivalEvent5 = new HashMap<String, Object>();
        multivalEvent5.put("dimA", "leek");
        multivalEvent5.put("dimMultiVal", multivalEvent5List);
        multivalEvent5.put("sumCount", 1L);
        List<String> multivalEvent6List = Arrays.asList(null, "3");
        HashMap<String, Object> multivalEvent6 = new HashMap<String, Object>();
        multivalEvent6.put("dimA", "leek");
        multivalEvent6.put("dimMultiVal", multivalEvent6List);
        multivalEvent6.put("sumCount", 1L);
        HashMap<String, Object> multivalEvent7 = new HashMap<String, Object>();
        multivalEvent7.put("dimA", "leek");
        multivalEvent7.put("dimMultiVal", ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)""));
        multivalEvent7.put("sumCount", 1L);
        HashMap<String, Object> multivalEvent8 = new HashMap<String, Object>();
        multivalEvent8.put("dimA", "leek");
        multivalEvent8.put("dimMultiVal", ImmutableList.of((Object)"", (Object)"3"));
        multivalEvent8.put("sumCount", 1L);
        HashMap<String, Object> multivalEvent9 = new HashMap<String, Object>();
        multivalEvent9.put("dimA", "potato");
        multivalEvent9.put("dimMultiVal", ImmutableList.of((Object)"1", (Object)"3"));
        multivalEvent9.put("sumCount", 1L);
        ImmutableList events = ImmutableList.of(nullEvent, nullEvent2, emptyListEvent, listWithNullEvent, emptyStringEvent, listWithEmptyStringEvent, singleValEvent, singleValEvent2, singleValEvent3, listWithSingleValEvent, listWithSingleValEvent2, listWithSingleValEvent3, (Object[])new Map[]{multivalEvent, multivalEvent2, multivalEvent3, multivalEvent4, multivalEvent5, multivalEvent6, multivalEvent7, multivalEvent8, multivalEvent9});
        IncrementalIndex toPersistA = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
        for (Map event : events) {
            toPersistA.add((InputRow)new MapBasedInputRow(1L, dims, event));
        }
        File tmpDirA = this.temporaryFolder.newFolder();
        QueryableIndex indexA = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistA, tmpDirA, this.indexSpec, null)));
        ArrayList<QueryableIndex> singleEventIndexes = new ArrayList<QueryableIndex>();
        for (Map event : events) {
            IncrementalIndex toPersist = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
            toPersist.add((InputRow)new MapBasedInputRow(1L, dims, event));
            File tmpDir = this.temporaryFolder.newFolder();
            QueryableIndex queryableIndex = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tmpDir, this.indexSpec, null)));
            singleEventIndexes.add(queryableIndex);
        }
        singleEventIndexes.add(indexA);
        File tmpDirMerged = this.temporaryFolder.newFolder();
        QueryableIndex merged = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(singleEventIndexes, true, new AggregatorFactory[]{new LongSumAggregatorFactory("sumCount", "sumCount")}, tmpDirMerged, this.indexSpec, null, -1)));
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"dimA", (Object)"dimMultiVal"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
        Assert.assertEquals((Object)ImmutableList.of((Object)"dimA", (Object)"dimMultiVal"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
        Assert.assertEquals((long)14L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList("leek", null), rowList.get(0).dimensionValues());
        Assert.assertEquals((Object)8L, (Object)rowList.get(0).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", Arrays.asList(null, "1", "2", "3")), rowList.get(1).dimensionValues());
        Assert.assertEquals((Object)2L, (Object)rowList.get(1).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", Arrays.asList(null, "3")), rowList.get(2).dimensionValues());
        Assert.assertEquals((Object)2L, (Object)rowList.get(2).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", ""), rowList.get(3).dimensionValues());
        Assert.assertEquals((Object)4L, (Object)rowList.get(3).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", Arrays.asList("", "1", "2", "3")), rowList.get(4).dimensionValues());
        Assert.assertEquals((Object)2L, (Object)rowList.get(4).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", Arrays.asList("", "3")), rowList.get(5).dimensionValues());
        Assert.assertEquals((Object)2L, (Object)rowList.get(5).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", "1"), rowList.get(6).dimensionValues());
        Assert.assertEquals((Object)4L, (Object)rowList.get(6).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", Arrays.asList("1", "2", "3")), rowList.get(7).dimensionValues());
        Assert.assertEquals((Object)2L, (Object)rowList.get(7).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", Arrays.asList("1", "3")), rowList.get(8).dimensionValues());
        Assert.assertEquals((Object)2L, (Object)rowList.get(8).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", Arrays.asList("1", "3", "5")), rowList.get(9).dimensionValues());
        Assert.assertEquals((Object)2L, (Object)rowList.get(9).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", Arrays.asList("1", "4")), rowList.get(10).dimensionValues());
        Assert.assertEquals((Object)2L, (Object)rowList.get(10).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("leek", "2"), rowList.get(11).dimensionValues());
        Assert.assertEquals((Object)4L, (Object)rowList.get(11).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("potato", Arrays.asList("1", "3")), rowList.get(12).dimensionValues());
        Assert.assertEquals((Object)2L, (Object)rowList.get(12).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("potato", "2"), rowList.get(13).dimensionValues());
        Assert.assertEquals((Object)4L, (Object)rowList.get(13).metricValues().get(0));
        this.checkBitmapIndex(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "leek"));
        this.checkBitmapIndex(Arrays.asList(12, 13), IndexMergerTestBase.getBitmapIndex(adapter, "dimA", "potato"));
        this.checkBitmapIndex(Arrays.asList(0, 1, 2), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", null));
        this.checkBitmapIndex((List<Integer>)ImmutableList.of((Object)3, (Object)4, (Object)5), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", ""));
        this.checkBitmapIndex(Arrays.asList(1, 4, 6, 7, 8, 9, 10, 12), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "1"));
        this.checkBitmapIndex(Arrays.asList(1, 4, 7, 11, 13), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "2"));
        this.checkBitmapIndex(Arrays.asList(1, 2, 4, 5, 7, 8, 9, 12), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "3"));
        this.checkBitmapIndex(Collections.singletonList(10), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "4"));
        this.checkBitmapIndex(Collections.singletonList(9), IndexMergerTestBase.getBitmapIndex(adapter, "dimMultiVal", "5"));
    }

    private MapBasedInputRow getRowForTestMaxColumnsToMerge(long ts, String d1, String d2, String d3, String d4, String d5) {
        return new MapBasedInputRow(ts, Arrays.asList("d1", "d2", "d3", "d4", "d5"), (Map)ImmutableMap.of((Object)"d1", (Object)d1, (Object)"d2", (Object)d2, (Object)"d3", (Object)d3, (Object)"d4", (Object)d4, (Object)"d5", (Object)d5));
    }

    private void validateTestMaxColumnsToMergeOutputSegment(QueryableIndex merged) {
        QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(merged);
        List<DebugRow> rowList = RowIteratorHelper.toList((RowIterator)adapter.getRows());
        Assert.assertEquals((Object)ImmutableList.of((Object)"__time", (Object)"d1", (Object)"d2", (Object)"d3", (Object)"d4", (Object)"d5"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(true)));
        Assert.assertEquals((Object)ImmutableList.of((Object)"d1", (Object)"d2", (Object)"d3", (Object)"d4", (Object)"d5"), (Object)ImmutableList.copyOf((Collection)adapter.getDimensionNames(false)));
        Assert.assertEquals((long)4L, (long)rowList.size());
        Assert.assertEquals(Arrays.asList("a", "b", "c", "d", "e"), rowList.get(0).dimensionValues());
        Assert.assertEquals((Object)1L, (Object)rowList.get(0).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("aa", "bb", "cc", "dd", "ee"), rowList.get(1).dimensionValues());
        Assert.assertEquals((Object)1L, (Object)rowList.get(1).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("aaa", "bbb", "ccc", "ddd", "eee"), rowList.get(2).dimensionValues());
        Assert.assertEquals((Object)1L, (Object)rowList.get(2).metricValues().get(0));
        Assert.assertEquals(Arrays.asList("1", "2", "3", "4", "5"), rowList.get(3).dimensionValues());
        Assert.assertEquals((Object)3L, (Object)rowList.get(3).metricValues().get(0));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d1", "a"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d1", "aa"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d1", "aaa"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d1", "aaa"));
        this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d1", "1"));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d2", "b"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d2", "bb"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d2", "bbb"));
        this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d2", "2"));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d3", "c"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d3", "cc"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d3", "ccc"));
        this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d3", "3"));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d4", "d"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d4", "dd"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d4", "ddd"));
        this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d4", "4"));
        this.checkBitmapIndex(Collections.singletonList(0), IndexMergerTestBase.getBitmapIndex(adapter, "d5", "e"));
        this.checkBitmapIndex(Collections.singletonList(1), IndexMergerTestBase.getBitmapIndex(adapter, "d5", "ee"));
        this.checkBitmapIndex(Collections.singletonList(2), IndexMergerTestBase.getBitmapIndex(adapter, "d5", "eee"));
        this.checkBitmapIndex(Collections.singletonList(3), IndexMergerTestBase.getBitmapIndex(adapter, "d5", "5"));
    }

    @Test
    public void testMaxColumnsToMerge() throws Exception {
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).withRollup(true).build();
        IncrementalIndex toPersistA = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
        toPersistA.add((InputRow)this.getRowForTestMaxColumnsToMerge(10000L, "a", "b", "c", "d", "e"));
        toPersistA.add((InputRow)this.getRowForTestMaxColumnsToMerge(99999L, "1", "2", "3", "4", "5"));
        IncrementalIndex toPersistB = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
        toPersistB.add((InputRow)this.getRowForTestMaxColumnsToMerge(20000L, "aa", "bb", "cc", "dd", "ee"));
        toPersistB.add((InputRow)this.getRowForTestMaxColumnsToMerge(99999L, "1", "2", "3", "4", "5"));
        IncrementalIndex toPersistC = new OnheapIncrementalIndex.Builder().setIndexSchema(indexSchema).setMaxRowCount(1000).build();
        toPersistC.add((InputRow)this.getRowForTestMaxColumnsToMerge(30000L, "aaa", "bbb", "ccc", "ddd", "eee"));
        toPersistC.add((InputRow)this.getRowForTestMaxColumnsToMerge(99999L, "1", "2", "3", "4", "5"));
        File tmpDirA = this.temporaryFolder.newFolder();
        File tmpDirB = this.temporaryFolder.newFolder();
        File tmpDirC = this.temporaryFolder.newFolder();
        QueryableIndex indexA = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistA, tmpDirA, this.indexSpec, null)));
        QueryableIndex indexB = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistB, tmpDirB, this.indexSpec, null)));
        QueryableIndex indexC = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersistC, tmpDirC, this.indexSpec, null)));
        File tmpDirMerged0 = this.temporaryFolder.newFolder();
        QueryableIndex merged0 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB, indexC), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged0, this.indexSpec, null, -1)));
        this.validateTestMaxColumnsToMergeOutputSegment(merged0);
        File tmpDirMerged1 = this.temporaryFolder.newFolder();
        QueryableIndex merged1 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB, indexC), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged1, this.indexSpec, null, 50)));
        this.validateTestMaxColumnsToMergeOutputSegment(merged1);
        File tmpDirMerged2 = this.temporaryFolder.newFolder();
        QueryableIndex merged2 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB, indexC), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged2, this.indexSpec, null, 15)));
        this.validateTestMaxColumnsToMergeOutputSegment(merged2);
        File tmpDirMerged3 = this.temporaryFolder.newFolder();
        QueryableIndex merged3 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB, indexC), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged3, this.indexSpec, null, 9)));
        this.validateTestMaxColumnsToMergeOutputSegment(merged3);
        File tmpDirMerged4 = this.temporaryFolder.newFolder();
        QueryableIndex merged4 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB, indexC), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged4, this.indexSpec, null, 3)));
        this.validateTestMaxColumnsToMergeOutputSegment(merged4);
        File tmpDirMerged5 = this.temporaryFolder.newFolder();
        QueryableIndex merged5 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB, indexC), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged5, this.indexSpec, null, 6)));
        this.validateTestMaxColumnsToMergeOutputSegment(merged5);
        File tmpDirMerged6 = this.temporaryFolder.newFolder();
        QueryableIndex merged6 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB, indexC), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged6, this.indexSpec, null, 12)));
        this.validateTestMaxColumnsToMergeOutputSegment(merged6);
        File tmpDirMerged7 = this.temporaryFolder.newFolder();
        QueryableIndex merged7 = this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(indexA, indexB, indexC), true, new AggregatorFactory[]{new CountAggregatorFactory("count")}, tmpDirMerged7, this.indexSpec, null, 18)));
        this.validateTestMaxColumnsToMergeOutputSegment(merged7);
    }

    @Test
    public void testMergeProjections() throws IOException {
        int rowCount;
        Cursor cursor;
        File tmp = FileUtils.createTempDir();
        this.closer.closeLater(tmp::delete);
        DateTime timestamp = Granularities.DAY.bucket(DateTimes.nowUtc()).getStart();
        RowSignature rowSignature = RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).build();
        List<InputRow> rows1 = Arrays.asList(new ListBasedInputRow(rowSignature, timestamp, rowSignature.getColumnNames(), Arrays.asList("a", "x", 1L)), new ListBasedInputRow(rowSignature, timestamp.plusMinutes(1), rowSignature.getColumnNames(), Arrays.asList("b", "y", 2L)), new ListBasedInputRow(rowSignature, timestamp.plusHours(2), rowSignature.getColumnNames(), Arrays.asList("a", "z", 3L)));
        List<InputRow> rows2 = Arrays.asList(new ListBasedInputRow(rowSignature, timestamp, rowSignature.getColumnNames(), Arrays.asList("b", "y", 1L)), new ListBasedInputRow(rowSignature, timestamp.plusMinutes(1), rowSignature.getColumnNames(), Arrays.asList("d", "w", 2L)), new ListBasedInputRow(rowSignature, timestamp.plusHours(2), rowSignature.getColumnNames(), Arrays.asList("b", "z", 3L)));
        DimensionsSpec.Builder dimensionsBuilder = DimensionsSpec.builder().setDimensions(Arrays.asList(new StringDimensionSchema("a"), new StringDimensionSchema("b")));
        List<AggregateProjectionSpec> projections = Arrays.asList(new AggregateProjectionSpec("a_hourly_c_sum", VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__gran")}), Arrays.asList(new StringDimensionSchema("a"), new LongDimensionSchema("__gran")), new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}), new AggregateProjectionSpec("a_c_sum", VirtualColumns.EMPTY, Collections.singletonList(new StringDimensionSchema("a")), new AggregatorFactory[]{new LongSumAggregatorFactory("c_sum", "c")}));
        IndexBuilder bob = IndexBuilder.create().tmpDir(tmp).schema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsBuilder.build()).withRollup(false).withProjections(projections).build()).rows(rows1);
        IndexBuilder bob2 = IndexBuilder.create().tmpDir(tmp).schema(IncrementalIndexSchema.builder().withDimensionsSpec(dimensionsBuilder.build()).withRollup(false).withProjections(projections).build()).rows(rows2);
        QueryableIndex q1 = bob.buildMMappedIndex();
        QueryableIndex q2 = bob2.buildMMappedIndex();
        QueryableIndex merged = this.indexIO.loadIndex(this.indexMerger.merge(Arrays.asList(new QueryableIndexIndexableAdapter(q1), new QueryableIndexIndexableAdapter(q2)), true, new AggregatorFactory[0], this.temporaryFolder.newFolder(), dimensionsBuilder.build(), IndexSpec.DEFAULT, -1));
        CursorBuildSpec p1Spec = CursorBuildSpec.builder().setQueryContext(QueryContext.of((Map)ImmutableMap.of((Object)"useProjection", (Object)"a_hourly_c_sum"))).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"gran")})).setAggregators(Collections.singletonList(new LongSumAggregatorFactory("c", "c"))).setGroupingColumns(Collections.singletonList("a")).build();
        CursorBuildSpec p2Spec = CursorBuildSpec.builder().setQueryContext(QueryContext.of((Map)ImmutableMap.of((Object)"useProjection", (Object)"a_c_sum"))).setAggregators(Collections.singletonList(new LongSumAggregatorFactory("c", "c"))).setGroupingColumns(Collections.singletonList("a")).build();
        QueryableIndexCursorFactory cursorFactory = new QueryableIndexCursorFactory(merged);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(p1Spec);){
            cursor = cursorHolder.asCursor();
            rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)5L, (long)rowCount);
        }
        cursorHolder = cursorFactory.makeCursorHolder(p2Spec);
        try {
            cursor = cursorHolder.asCursor();
            rowCount = 0;
            while (!cursor.isDone()) {
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)3L, (long)rowCount);
        }
        finally {
            if (cursorHolder != null) {
                cursorHolder.close();
            }
        }
        QueryableIndex p1Index = merged.getProjectionQueryableIndex("a_hourly_c_sum");
        Assert.assertNotNull((Object)p1Index);
        ColumnHolder aHolder = p1Index.getColumnHolder("a");
        DictionaryEncodedColumn aCol = (DictionaryEncodedColumn)aHolder.getColumn();
        Assert.assertEquals((long)3L, (long)aCol.getCardinality());
        QueryableIndex p2Index = merged.getProjectionQueryableIndex("a_c_sum");
        Assert.assertNotNull((Object)p2Index);
        ColumnHolder aHolder2 = p2Index.getColumnHolder("a");
        DictionaryEncodedColumn aCol2 = (DictionaryEncodedColumn)aHolder2.getColumn();
        Assert.assertEquals((long)3L, (long)aCol2.getCardinality());
        if (this.serdeFactory != null) {
            DefaultBitmapResultFactory resultFactory = new DefaultBitmapResultFactory(this.serdeFactory.getBitmapFactory());
            Assert.assertEquals((long)2L, (long)resultFactory.toImmutableBitmap(((ValueIndexes)aHolder.getIndexSupplier().as(ValueIndexes.class)).forValue((Object)"a", (TypeSignature)ColumnType.STRING).computeBitmapResult((BitmapResultFactory)resultFactory, false)).size());
            Assert.assertEquals((long)1L, (long)resultFactory.toImmutableBitmap(((ValueIndexes)aHolder2.getIndexSupplier().as(ValueIndexes.class)).forValue((Object)"a", (TypeSignature)ColumnType.STRING).computeBitmapResult((BitmapResultFactory)resultFactory, false)).size());
        }
    }

    private QueryableIndex persistAndLoad(List<DimensionSchema> schema, InputRow ... rows) throws IOException {
        IncrementalIndex toPersist = IncrementalIndexTest.createIndex(null, new DimensionsSpec(schema));
        for (InputRow row : rows) {
            toPersist.add(row);
        }
        File tempDir = this.temporaryFolder.newFolder();
        return this.closer.closeLater(this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, this.indexSpec, null)));
    }

    private List<DimensionSchema> makeDimensionSchemas(List<String> dimensions) {
        return this.makeDimensionSchemas(dimensions, DimensionSchema.MultiValueHandling.SORTED_ARRAY);
    }

    private List<DimensionSchema> makeDimensionSchemas(List<String> dimensions, DimensionSchema.MultiValueHandling multiValueHandling) {
        return dimensions.stream().map(dimension -> new StringDimensionSchema(dimension, multiValueHandling, Boolean.valueOf(this.useBitmapIndexes))).collect(Collectors.toList());
    }

    private static List<OrderBy> makeOrderBys(String ... columnNames) {
        return Arrays.stream(columnNames).map(OrderBy::ascending).collect(Collectors.toList());
    }
}

