/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.timeseries.TimeseriesBinaryFn;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class TimeseriesBinaryFnTest {
    final CountAggregatorFactory rowsCount = new CountAggregatorFactory("rows");
    final LongSumAggregatorFactory indexLongSum = new LongSumAggregatorFactory("index", "index");
    final List<AggregatorFactory> aggregatorFactories = Arrays.asList(this.rowsCount, this.indexLongSum);
    final DateTime currTime = DateTimes.nowUtc();

    @Test
    public void testMerge() {
        Result result1 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L)));
        Result result2 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L)));
        Result expected = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"index", (Object)5L)));
        Result actual = new TimeseriesBinaryFn(Granularities.ALL, this.aggregatorFactories).apply(result1, result2);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMergeDay() {
        Result result1 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L)));
        Result result2 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L)));
        Result expected = new Result(Granularities.DAY.bucketStart(this.currTime), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"index", (Object)5L)));
        Result actual = new TimeseriesBinaryFn(Granularities.DAY, this.aggregatorFactories).apply(result1, result2);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMergeOneNullResult() {
        Result result1 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L)));
        Result result2 = null;
        Result expected = result1;
        Result actual = new TimeseriesBinaryFn(Granularities.ALL, this.aggregatorFactories).apply(result1, result2);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMergeShiftedTimestamp() {
        Result result1 = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)1L, (Object)"index", (Object)2L)));
        Result result2 = new Result(this.currTime.plusHours(2), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)2L, (Object)"index", (Object)3L)));
        Result expected = new Result(this.currTime, (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)3L, (Object)"index", (Object)5L)));
        Result actual = new TimeseriesBinaryFn(Granularities.ALL, this.aggregatorFactories).apply(result1, result2);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

