/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.spec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.junit.Assert;
import org.junit.Test;

public class QuerySegmentSpecTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerializationLegacyString() throws Exception {
        QuerySegmentSpec spec = (QuerySegmentSpec)JSON_MAPPER.readValue("\"2011-10-01/2011-10-10,2011-11-01/2011-11-10\"", QuerySegmentSpec.class);
        Assert.assertTrue((boolean)(spec instanceof LegacySegmentSpec));
        Assert.assertEquals((Object)ImmutableList.of((Object)Intervals.of((String)"2011-10-01/2011-10-10"), (Object)Intervals.of((String)"2011-11-01/2011-11-10")), (Object)spec.getIntervals());
    }

    @Test
    public void testSerializationLegacyArray() throws Exception {
        QuerySegmentSpec spec = (QuerySegmentSpec)JSON_MAPPER.readValue("[\"2011-09-01/2011-10-10\", \"2011-11-01/2011-11-10\"]", QuerySegmentSpec.class);
        Assert.assertTrue((boolean)(spec instanceof LegacySegmentSpec));
        Assert.assertEquals((Object)ImmutableList.of((Object)Intervals.of((String)"2011-09-01/2011-10-10"), (Object)Intervals.of((String)"2011-11-01/2011-11-10")), (Object)spec.getIntervals());
    }

    @Test
    public void testSerializationIntervals() throws Exception {
        QuerySegmentSpec spec = (QuerySegmentSpec)JSON_MAPPER.readValue("{\"type\": \"intervals\", \"intervals\":[\"2011-08-01/2011-10-10\", \"2011-11-01/2011-11-10\"]}", QuerySegmentSpec.class);
        Assert.assertTrue((boolean)(spec instanceof MultipleIntervalSegmentSpec));
        Assert.assertEquals((Object)ImmutableList.of((Object)Intervals.of((String)"2011-08-01/2011-10-10"), (Object)Intervals.of((String)"2011-11-01/2011-11-10")), (Object)spec.getIntervals());
    }

    @Test
    public void testSerializationSegments() {
        QuerySegmentSpec spec = (QuerySegmentSpec)JSON_MAPPER.convertValue((Object)ImmutableMap.of((Object)"type", (Object)"segments", (Object)"segments", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"itvl", (Object)"2011-07-01/2011-10-10", (Object)"ver", (Object)"1", (Object)"part", (Object)0), (Object)ImmutableMap.of((Object)"itvl", (Object)"2011-07-01/2011-10-10", (Object)"ver", (Object)"1", (Object)"part", (Object)1), (Object)ImmutableMap.of((Object)"itvl", (Object)"2011-11-01/2011-11-10", (Object)"ver", (Object)"2", (Object)"part", (Object)10))), QuerySegmentSpec.class);
        Assert.assertTrue((boolean)(spec instanceof MultipleSpecificSegmentSpec));
        Assert.assertEquals((Object)ImmutableList.of((Object)Intervals.of((String)"2011-07-01/2011-10-10"), (Object)Intervals.of((String)"2011-11-01/2011-11-10")), (Object)spec.getIntervals());
        Assert.assertEquals((Object)ImmutableList.of((Object)new SegmentDescriptor(Intervals.of((String)"2011-07-01/2011-10-10"), "1", 0), (Object)new SegmentDescriptor(Intervals.of((String)"2011-07-01/2011-10-10"), "1", 1), (Object)new SegmentDescriptor(Intervals.of((String)"2011-11-01/2011-11-10"), "2", 10)), (Object)((MultipleSpecificSegmentSpec)spec).getDescriptors());
    }
}

