/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column;

import java.util.ArrayList;
import java.util.List;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.accessor.DoubleColumnAccessorBase;
import org.apache.druid.query.rowsandcols.column.accessor.FloatColumnAccessorBase;
import org.apache.druid.query.rowsandcols.column.accessor.LongColumnAccessorBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ColumnAccessorsTest {
    private TestAccessorShim testAccessor;

    @Parameterized.Parameters
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (TestAccessorShim accessor : TestAccessorShim.values()) {
            ret.add(new Object[]{accessor});
        }
        return ret;
    }

    public ColumnAccessorsTest(TestAccessorShim accessor) {
        this.testAccessor = accessor;
    }

    @Test
    public void testSomeValue() {
        Object expectedValue = this.testAccessor.getSomeValue();
        ColumnAccessor acc = this.testAccessor.getColumnAccessor(expectedValue);
        Assert.assertFalse((boolean)acc.isNull(0));
        Assert.assertEquals((Object)expectedValue, (Object)acc.getObject(0));
    }

    @Test
    public void testNull() {
        ColumnAccessor acc = this.testAccessor.getColumnAccessor(null);
        Assert.assertTrue((boolean)acc.isNull(0));
        Assert.assertEquals(null, (Object)acc.getObject(0));
    }

    static enum TestAccessorShim {
        LONG{

            @Override
            ColumnAccessor getColumnAccessor(Object value) {
                final Long val = (Long)value;
                return new LongColumnAccessorBase(){

                    public int numRows() {
                        return 1;
                    }

                    public boolean isNull(int rowNum) {
                        return val == null;
                    }

                    public long getLong(int rowNum) {
                        return val;
                    }
                };
            }

            @Override
            protected Object getSomeValue() {
                return 42L;
            }
        }
        ,
        FLOAT{

            @Override
            ColumnAccessor getColumnAccessor(Object value) {
                final Float val = (Float)value;
                return new FloatColumnAccessorBase(){

                    public int numRows() {
                        return 1;
                    }

                    public boolean isNull(int rowNum) {
                        return val == null;
                    }

                    public float getFloat(int rowNum) {
                        return val.floatValue();
                    }
                };
            }

            @Override
            protected Object getSomeValue() {
                return Float.valueOf(42.1f);
            }
        }
        ,
        DOUBLE{

            @Override
            ColumnAccessor getColumnAccessor(Object value) {
                final Double val = (Double)value;
                return new DoubleColumnAccessorBase(){

                    public int numRows() {
                        return 1;
                    }

                    public boolean isNull(int rowNum) {
                        return val == null;
                    }

                    public double getDouble(int rowNum) {
                        return val;
                    }
                };
            }

            @Override
            protected Object getSomeValue() {
                return 42.1;
            }
        };


        abstract ColumnAccessor getColumnAccessor(Object var1);

        protected abstract Object getSomeValue();
    }
}

