/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.rowsandcols.ArrayListRowsAndColumns;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumnsTestBase;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class ArrayListRowsAndColumnsTest
extends RowsAndColumnsTestBase {
    @Nonnull
    public static Function<MapOfColumnsRowsAndColumns, ArrayListRowsAndColumns<Object[]>> MAKER = input -> ArrayListRowsAndColumnsTest.buildRAC(input);

    public ArrayListRowsAndColumnsTest() {
        super(ArrayListRowsAndColumns.class);
    }

    public static ArrayListRowsAndColumns<Object[]> buildRAC(MapOfColumnsRowsAndColumns input) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(input.numRows());
        ArrayList cols = new ArrayList(input.getColumnNames());
        RowSignature.Builder sigBob = RowSignature.builder();
        for (int i = 0; i < input.numRows(); ++i) {
            rows.add(new Object[cols.size()]);
        }
        for (int colIndex = 0; colIndex < cols.size(); ++colIndex) {
            String col = (String)cols.get(colIndex);
            ColumnAccessor column = Objects.requireNonNull(input.findColumn(col)).toAccessor();
            sigBob.add(col, column.getType());
            for (int i = 0; i < column.numRows(); ++i) {
                ((Object[])rows.get((int)i))[colIndex] = column.getObject(i);
            }
        }
        return new ArrayListRowsAndColumns(rows, columnName -> {
            int i = cols.indexOf(columnName);
            if (i < 0) {
                throw new ISE("Couldn't find column[%s]!? i[%s]", new Object[]{columnName, i});
            }
            return objects -> objects[i];
        }, sigBob.build());
    }

    @Test
    public void testChildRAC() {
        MapOfColumnsRowsAndColumns input = MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"colA", (Object)new IntArrayColumn(new int[]{1, 1, 1, 1, 2, 2, 2, 2, 2, 2}), (Object)"colB", (Object)new IntArrayColumn(new int[]{3, 3, 4, 4, 5, 5, 5, 6, 6, 7})));
        ArrayListRowsAndColumns<Object[]> rac = ArrayListRowsAndColumnsTest.buildRAC(input);
        ArrayList childRACs = rac.toClusteredGroupPartitioner().partitionOnBoundaries(Collections.singletonList("colA"));
        Assert.assertEquals((long)2L, (long)childRACs.size());
        ArrayListRowsAndColumns childRAC = (ArrayListRowsAndColumns)childRACs.get(1);
        ArrayListRowsAndColumns curChildRAC = (ArrayListRowsAndColumns)childRAC.toClusteredGroupPartitioner().partitionOnBoundaries(Collections.singletonList("colB")).get(0);
        Assert.assertEquals((long)5L, (long)curChildRAC.findColumn("colB").toAccessor().getInt(0));
    }
}

