/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.druid.query.groupby.epinephelinae.ByteBufferMinMaxOffsetHeap;
import org.junit.Assert;
import org.junit.Test;

public class ByteBufferMinMaxOffsetHeapTest {
    @Test
    public void testSimple() {
        int limit = 15;
        ByteBuffer myBuffer = ByteBuffer.allocate(1000000);
        ByteBufferMinMaxOffsetHeap heap = new ByteBufferMinMaxOffsetHeap(myBuffer, limit, (Comparator)Ordering.natural(), null);
        ArrayList values = Lists.newArrayList((Object[])new Integer[]{30, 45, 81, 92, 68, 54, 66, 33, 89, 98, 87, 62, 84, 39, 13, 32, 67, 50, 21, 53, 93, 18, 86, 41, 14, 56, 51, 69, 91, 60, 6, 2, 79, 4, 35, 17, 71, 22, 29, 76, 57, 97, 73, 24, 94, 77, 80, 15, 52, 88, 95, 96, 9, 3, 48, 58, 75, 82, 90, 65, 36, 85, 20, 34, 37, 72, 11, 78, 28, 43, 27, 12, 83, 38, 59, 19, 31, 46, 40, 63, 23, 70, 26, 8, 64, 16, 10, 74, 7, 25, 5, 42, 47, 44, 1, 49, 99});
        for (Integer value : values) {
            heap.addOffset(value.intValue());
        }
        int x = heap.removeAt(8);
        heap.addOffset(x);
        x = heap.removeAt(2);
        heap.addOffset(x);
        Collections.sort(values);
        List expected = values.subList(0, limit);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        for (int i = 0; i < limit; ++i) {
            int min = heap.removeMin();
            actual.add(min);
        }
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testRandom() {
        int limit = 20;
        Random rng = new Random(999L);
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < 10000; ++i) {
            values.add(rng.nextInt(1000000));
        }
        ArrayList<Integer> deletedValues = new ArrayList<Integer>();
        ByteBuffer myBuffer = ByteBuffer.allocate(1000000);
        ByteBufferMinMaxOffsetHeap heap = new ByteBufferMinMaxOffsetHeap(myBuffer, limit, (Comparator)Ordering.natural(), null);
        for (int i = 0; i < values.size(); ++i) {
            double deleteRoll;
            int droppedOffset = heap.addOffset(((Integer)values.get(i)).intValue());
            Assert.assertTrue((boolean)heap.isIntact());
            if (droppedOffset > 0) {
                deletedValues.add(droppedOffset);
            }
            if (heap.getHeapSize() <= limit / 2 || i % 2 != 1 || !((deleteRoll = rng.nextDouble()) > 0.15)) continue;
            int indexToRemove = rng.nextInt(heap.getHeapSize());
            int deadOffset = heap.removeAt(indexToRemove);
            Assert.assertTrue((boolean)heap.isIntact());
            deletedValues.add(deadOffset);
        }
        Collections.sort(values);
        Collections.sort(deletedValues);
        Iterator i = deletedValues.iterator();
        while (i.hasNext()) {
            int deletedValue = (Integer)i.next();
            values.remove((Object)deletedValue);
        }
        Assert.assertTrue((heap.getHeapSize() <= limit ? 1 : 0) != 0);
        List expected = values.subList(0, heap.getHeapSize());
        ArrayList<Integer> actual = new ArrayList<Integer>();
        int initialHeapSize = heap.getHeapSize();
        for (int i2 = 0; i2 < initialHeapSize; ++i2) {
            int min = heap.removeMin();
            actual.add(min);
        }
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testRandom2() {
        int limit = 5000;
        Random rng = new Random(9999L);
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < 20000; ++i) {
            values.add(rng.nextInt(1000000));
        }
        ArrayList<Integer> deletedValues = new ArrayList<Integer>();
        ByteBuffer myBuffer = ByteBuffer.allocate(1000000);
        ByteBufferMinMaxOffsetHeap heap = new ByteBufferMinMaxOffsetHeap(myBuffer, limit, (Comparator)Ordering.natural(), null);
        for (int i = 0; i < values.size(); ++i) {
            double deleteRoll;
            int droppedOffset = heap.addOffset(((Integer)values.get(i)).intValue());
            Assert.assertTrue((boolean)heap.isIntact());
            if (droppedOffset > 0) {
                deletedValues.add(droppedOffset);
            }
            if (heap.getHeapSize() <= limit / 2 || i % 2 != 1 || !((deleteRoll = rng.nextDouble()) > 0.15)) continue;
            int indexToRemove = rng.nextInt(heap.getHeapSize());
            int deadOffset = heap.removeAt(indexToRemove);
            Assert.assertTrue((boolean)heap.isIntact());
            deletedValues.add(deadOffset);
        }
        Collections.sort(values);
        Collections.sort(deletedValues);
        Iterator i = deletedValues.iterator();
        while (i.hasNext()) {
            int deletedValue = (Integer)i.next();
            values.remove((Object)deletedValue);
        }
        Assert.assertTrue((heap.getHeapSize() <= limit ? 1 : 0) != 0);
        List expected = values.subList(0, heap.getHeapSize());
        ArrayList<Integer> actual = new ArrayList<Integer>();
        int initialHeapSize = heap.getHeapSize();
        for (int i2 = 0; i2 < initialHeapSize; ++i2) {
            int min = heap.removeMin();
            actual.add(min);
        }
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testRemove() {
        int limit = 100;
        IntArrayList values = new IntArrayList(new int[]{1, 20, 1000, 2, 3, 30, 40, 10, 11, 12, 13, 300, 400, 500, 600});
        ByteBuffer myBuffer = ByteBuffer.allocate(1000000);
        ByteBufferMinMaxOffsetHeap heap = new ByteBufferMinMaxOffsetHeap(myBuffer, limit, (Comparator)Ordering.natural(), null);
        for (Integer value : values) {
            heap.addOffset(value.intValue());
            Assert.assertTrue((boolean)heap.isIntact());
        }
        heap.removeOffset(12);
        Assert.assertTrue((boolean)heap.isIntact());
        Collections.sort(values);
        values.rem(12);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        for (int i = 0; i < values.size(); ++i) {
            int min = heap.removeMin();
            actual.add(min);
        }
        Assert.assertEquals((Object)values, actual);
    }

    @Test
    public void testRemove2() {
        int limit = 100;
        IntArrayList values = new IntArrayList(new int[]{1, 20, 1000, 2, 3, 30, 40, 10, 11, 12, 13, 300, 400, 500, 600, 4, 5, 6, 7, 8, 9, 4, 5, 200, 250});
        ByteBuffer myBuffer = ByteBuffer.allocate(1000000);
        ByteBufferMinMaxOffsetHeap heap = new ByteBufferMinMaxOffsetHeap(myBuffer, limit, (Comparator)Ordering.natural(), null);
        for (Integer value : values) {
            heap.addOffset(value.intValue());
        }
        Assert.assertTrue((boolean)heap.isIntact());
        heap.removeOffset(2);
        Assert.assertTrue((boolean)heap.isIntact());
        Collections.sort(values);
        values.rem(2);
        Assert.assertTrue((boolean)heap.isIntact());
        ArrayList<Integer> actual = new ArrayList<Integer>();
        for (int i = 0; i < values.size(); ++i) {
            int min = heap.removeMin();
            actual.add(min);
        }
        Assert.assertTrue((boolean)heap.isIntact());
        Assert.assertEquals((Object)values, actual);
    }
}

