/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.groupby.DeferExpressionDimensions;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class GroupByQueryConfigTest {
    private final ObjectMapper MAPPER = TestHelper.makeJsonMapper();
    private final ImmutableMap<String, String> CONFIG_MAP = ImmutableMap.builder().put((Object)"singleThreaded", (Object)"true").put((Object)"bufferGrouperInitialBuckets", (Object)"1").put((Object)"defaultOnDiskStorage", (Object)"1M").put((Object)"maxOnDiskStorage", (Object)"4M").put((Object)"maxSelectorDictionarySize", (Object)"5").put((Object)"maxMergingDictionarySize", (Object)"6M").put((Object)"bufferGrouperMaxLoadFactor", (Object)"7").build();

    @Test
    public void testSerde() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue(this.CONFIG_MAP, GroupByQueryConfig.class);
        Assert.assertEquals((Object)true, (Object)config.isSingleThreaded());
        Assert.assertEquals((long)1L, (long)config.getBufferGrouperInitialBuckets());
        Assert.assertEquals((long)4000000L, (long)config.getMaxOnDiskStorage().getBytes());
        Assert.assertEquals((long)1000000L, (long)config.getDefaultOnDiskStorage().getBytes());
        Assert.assertEquals((long)5L, (long)config.getConfiguredMaxSelectorDictionarySize());
        Assert.assertEquals((long)6000000L, (long)config.getConfiguredMaxMergingDictionarySize());
        Assert.assertEquals((double)7.0, (double)config.getBufferGrouperMaxLoadFactor(), (double)0.0);
        Assert.assertFalse((boolean)config.isApplyLimitPushDownToSegment());
    }

    @Test
    public void testNoOverrides() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue(this.CONFIG_MAP, GroupByQueryConfig.class);
        GroupByQueryConfig config2 = config.withOverrides(GroupByQuery.builder().setDataSource("test").setInterval(Intervals.of((String)"2000/P1D")).setGranularity(Granularities.ALL).build());
        Assert.assertEquals((Object)true, (Object)config2.isSingleThreaded());
        Assert.assertEquals((long)1L, (long)config2.getBufferGrouperInitialBuckets());
        Assert.assertEquals((long)1000000L, (long)config2.getMaxOnDiskStorage().getBytes());
        Assert.assertEquals((long)5L, (long)config2.getConfiguredMaxSelectorDictionarySize());
        Assert.assertEquals((long)6000000L, (long)config2.getConfiguredMaxMergingDictionarySize());
        Assert.assertEquals((double)7.0, (double)config2.getBufferGrouperMaxLoadFactor(), (double)0.0);
        Assert.assertEquals((Object)DeferExpressionDimensions.FIXED_WIDTH_NON_NUMERIC, (Object)config2.getDeferExpressionDimensions());
        Assert.assertFalse((boolean)config2.isApplyLimitPushDownToSegment());
    }

    @Test
    public void testOverrides() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue(this.CONFIG_MAP, GroupByQueryConfig.class);
        GroupByQueryConfig config2 = config.withOverrides(GroupByQuery.builder().setDataSource("test").setInterval(Intervals.of((String)"2000/P1D")).setGranularity(Granularities.ALL).setContext((Map)ImmutableMap.builder().put((Object)"maxOnDiskStorage", (Object)"3M").put((Object)"maxResults", (Object)2).put((Object)"maxSelectorDictionarySize", (Object)3).put((Object)"maxMergingDictionarySize", (Object)4).put((Object)"applyLimitPushDownToSegment", (Object)true).put((Object)"deferExpressionDimensions", (Object)DeferExpressionDimensions.ALWAYS.toString()).build()).build());
        Assert.assertEquals((Object)true, (Object)config2.isSingleThreaded());
        Assert.assertEquals((long)1L, (long)config2.getBufferGrouperInitialBuckets());
        Assert.assertEquals((long)3000000L, (long)config2.getMaxOnDiskStorage().getBytes());
        Assert.assertEquals((long)3L, (long)config2.getConfiguredMaxSelectorDictionarySize());
        Assert.assertEquals((long)4L, (long)config2.getConfiguredMaxMergingDictionarySize());
        Assert.assertEquals((double)7.0, (double)config2.getBufferGrouperMaxLoadFactor(), (double)0.0);
        Assert.assertEquals((Object)DeferExpressionDimensions.ALWAYS, (Object)config2.getDeferExpressionDimensions());
        Assert.assertTrue((boolean)config2.isApplyLimitPushDownToSegment());
    }

    @Test
    public void testAutomaticMergingDictionarySize() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue((Object)ImmutableMap.of((Object)"maxMergingDictionarySize", (Object)"0"), GroupByQueryConfig.class);
        Assert.assertEquals((long)0L, (long)config.getConfiguredMaxMergingDictionarySize());
        Assert.assertEquals((long)150000000L, (long)config.getActualMaxMergingDictionarySize(1000000000L, 2));
    }

    @Test
    public void testNonAutomaticMergingDictionarySize() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue((Object)ImmutableMap.of((Object)"maxMergingDictionarySize", (Object)"100"), GroupByQueryConfig.class);
        Assert.assertEquals((long)100L, (long)config.getConfiguredMaxMergingDictionarySize());
        Assert.assertEquals((long)100L, (long)config.getActualMaxMergingDictionarySize(1000000000L, 2));
    }

    @Test
    public void testAutomaticSelectorDictionarySize() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue((Object)ImmutableMap.of((Object)"maxSelectorDictionarySize", (Object)"0"), GroupByQueryConfig.class);
        Assert.assertEquals((long)0L, (long)config.getConfiguredMaxSelectorDictionarySize());
        Assert.assertEquals((long)50000000L, (long)config.getActualMaxSelectorDictionarySize(1000000000L, 2));
    }

    @Test
    public void testNonAutomaticSelectorDictionarySize() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue((Object)ImmutableMap.of((Object)"maxSelectorDictionarySize", (Object)"100"), GroupByQueryConfig.class);
        Assert.assertEquals((long)100L, (long)config.getConfiguredMaxSelectorDictionarySize());
        Assert.assertEquals((long)100L, (long)config.getActualMaxSelectorDictionarySize(1000000000L, 2));
    }

    @Test
    public void testUseDefaultOnDiskStorage() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue((Object)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)"10G", (Object)"defaultOnDiskStorage", (Object)"5G"), GroupByQueryConfig.class);
        GroupByQueryConfig config2 = config.withOverrides(GroupByQuery.builder().setDataSource("test").setInterval(Intervals.of((String)"2000/P1D")).setGranularity(Granularities.ALL).setContext((Map)ImmutableMap.builder().build()).build());
        Assert.assertEquals((long)5000000000L, (long)config2.getMaxOnDiskStorage().getBytes());
    }

    @Test
    public void testUseMaxOnDiskStorageWhenClientOverrideIsTooLarge() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue((Object)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)"500M"), GroupByQueryConfig.class);
        GroupByQueryConfig config2 = config.withOverrides(GroupByQuery.builder().setDataSource("test").setInterval(Intervals.of((String)"2000/P1D")).setGranularity(Granularities.ALL).setContext((Map)ImmutableMap.builder().put((Object)"maxOnDiskStorage", (Object)"1G").build()).build());
        Assert.assertEquals((long)500000000L, (long)config2.getMaxOnDiskStorage().getBytes());
    }

    @Test
    public void testGetDefaultOnDiskStorageReturnsCorrectValue() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue((Object)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)"500M"), GroupByQueryConfig.class);
        GroupByQueryConfig config2 = (GroupByQueryConfig)this.MAPPER.convertValue((Object)ImmutableMap.of((Object)"maxOnDiskStorage", (Object)"500M", (Object)"defaultOnDiskStorage", (Object)"100M"), GroupByQueryConfig.class);
        Assert.assertEquals((long)500000000L, (long)config.getDefaultOnDiskStorage().getBytes());
        Assert.assertEquals((long)100000000L, (long)config2.getDefaultOnDiskStorage().getBytes());
    }
}

