/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.expression.MacroTestBase;
import org.apache.druid.query.expression.RegexpReplaceExprMacro;
import org.junit.Assert;
import org.junit.Test;

public class RegexpReplaceExprMacroTest
extends MacroTestBase {
    public RegexpReplaceExprMacroTest() {
        super((ExprMacroTable.ExprMacro)new RegexpReplaceExprMacro());
    }

    @Test
    public void testErrorZeroArguments() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_replace] requires 3 arguments");
        this.eval("regexp_replace()", InputBindings.nilBindings());
    }

    @Test
    public void testErrorFourArguments() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_replace] requires 3 arguments");
        this.eval("regexp_replace('a', 'b', 'c', 'd')", InputBindings.nilBindings());
    }

    @Test
    public void testErrorNonStringPattern() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_replace] pattern must be a string literal");
        this.eval("regexp_replace(a, 1, 'x')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
    }

    @Test
    public void testErrorNonStringReplacement() {
        this.expectException(IllegalArgumentException.class, "Function[regexp_replace] replacement must be a string literal");
        this.eval("regexp_replace(a, 'x', 1)", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
    }

    @Test
    public void testNullPattern() {
        ExprEval<?> result = this.eval("regexp_replace(a, null, 'x')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testNoMatch() {
        ExprEval<?> result = this.eval("regexp_replace(a, 'f.x', 'beep')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)"foo", (Object)result.value());
    }

    @Test
    public void testEmptyStringPattern() {
        ExprEval<?> result = this.eval("regexp_replace(a, '', 'x')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo"));
        Assert.assertEquals((Object)"xfxoxox", (Object)result.value());
    }

    @Test
    public void testMultiLinePattern() {
        ExprEval<?> result = this.eval("regexp_replace(a, '^foo\\\\nbar$', 'xxx')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo\nbar"));
        Assert.assertEquals((Object)"xxx", (Object)result.value());
    }

    @Test
    public void testMultiLinePatternNoMatch() {
        ExprEval<?> result = this.eval("regexp_replace(a, '^foo\\\\nbar$', 'xxx')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "foo\nbarz"));
        Assert.assertEquals((Object)"foo\nbarz", (Object)result.value());
    }

    @Test
    public void testNullPatternOnEmptyString() {
        ExprEval<?> result = this.eval("regexp_replace(a, null, 'x')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> ""));
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testEmptyStringPatternOnEmptyString() {
        ExprEval<?> result = this.eval("regexp_replace(a, '', 'x')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> ""));
        Assert.assertEquals((Object)"x", (Object)result.value());
    }

    @Test
    public void testEmptyStringPatternOnEmptyStringDynamic() {
        ExprEval<?> result = this.eval("regexp_replace(a, pattern, replacement)", InputBindings.forInputSuppliers((Map)ImmutableMap.of((Object)"a", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> ""), (Object)"pattern", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> ""), (Object)"replacement", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "x"))));
        Assert.assertEquals((Object)"x", (Object)result.value());
    }

    @Test
    public void testNullPatternOnNull() {
        ExprEval<?> result = this.eval("regexp_replace(a, null, 'x')", InputBindings.nilBindings());
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testNullPatternOnNullDynamic() {
        ExprEval<?> result = this.eval("regexp_replace(a, pattern, replacement)", InputBindings.forInputSuppliers((Map)ImmutableMap.of((Object)"replacement", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "x"))));
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testEmptyStringPatternOnNull() {
        ExprEval<?> result = this.eval("regexp_replace(a, '', 'x')", InputBindings.nilBindings());
        Assert.assertNull((Object)result.value());
    }

    @Test
    public void testUrlIdReplacement() {
        ExprEval<?> result = this.eval("regexp_replace(regexp_replace(a, '\\\\?(.*)$', ''), '/(\\\\w+)(?=/|$)', '/*')", InputBindings.forInputSupplier((String)"a", (ExpressionType)ExpressionType.STRING, () -> "http://example.com/path/to?query"));
        Assert.assertEquals((Object)"http://example.com/*/*", (Object)result.value());
    }

    @Test
    public void testUrlIdReplacementDynamic() {
        ExprEval<?> result = this.eval("regexp_replace(regexp_replace(a, pattern1, replacement1), pattern2, replacement2)", InputBindings.forInputSuppliers((Map)ImmutableMap.builder().put((Object)"a", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "http://example.com/path/to?query")).put((Object)"pattern1", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "\\?(.*)$")).put((Object)"pattern2", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "/(\\w+)(?=/|$)")).put((Object)"replacement1", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "")).put((Object)"replacement2", (Object)InputBindings.inputSupplier((ExpressionType)ExpressionType.STRING, () -> "/*")).build()));
        Assert.assertEquals((Object)"http://example.com/*/*", (Object)result.value());
    }
}

