/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MatchingDimExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.extraction.StrlenExtractionFn;
import org.apache.druid.segment.column.ColumnType;
import org.junit.Assert;
import org.junit.Test;

public class ExtractionDimensionSpecTest {
    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String oldJson = "{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"extractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}";
        ExtractionDimensionSpec extractionDimensionSpec = (ExtractionDimensionSpec)objectMapper.readValue("{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"extractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}", DimensionSpec.class);
        Assert.assertEquals((Object)"first3Letters", (Object)extractionDimensionSpec.getOutputName());
        Assert.assertEquals((Object)"myDim", (Object)extractionDimensionSpec.getDimension());
        Assert.assertNotNull((Object)extractionDimensionSpec.getExtractionFn());
        Assert.assertEquals((Object)ColumnType.STRING, (Object)extractionDimensionSpec.getOutputType());
        Assert.assertTrue((boolean)(extractionDimensionSpec.getExtractionFn() instanceof RegexDimExtractionFn));
        Assert.assertEquals((Object)extractionDimensionSpec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionDimensionSpec), DimensionSpec.class));
    }

    @Test
    public void testSerdeWithType() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String oldJson = "{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"outputType\": \"LONG\",\n    \"dimension\": \"myDim\",    \"extractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}";
        ExtractionDimensionSpec extractionDimensionSpec = (ExtractionDimensionSpec)objectMapper.readValue("{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"outputType\": \"LONG\",\n    \"dimension\": \"myDim\",    \"extractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}", DimensionSpec.class);
        Assert.assertEquals((Object)"first3Letters", (Object)extractionDimensionSpec.getOutputName());
        Assert.assertEquals((Object)"myDim", (Object)extractionDimensionSpec.getDimension());
        Assert.assertNotNull((Object)extractionDimensionSpec.getExtractionFn());
        Assert.assertEquals((Object)ColumnType.LONG, (Object)extractionDimensionSpec.getOutputType());
        Assert.assertTrue((boolean)(extractionDimensionSpec.getExtractionFn() instanceof RegexDimExtractionFn));
        Assert.assertEquals((Object)extractionDimensionSpec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionDimensionSpec), DimensionSpec.class));
    }

    @Test
    public void testSerdeBackwardsCompatibility() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String oldJson = "{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"dimExtractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}";
        ExtractionDimensionSpec extractionDimensionSpec = (ExtractionDimensionSpec)objectMapper.readValue("{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"dimExtractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}", DimensionSpec.class);
        Assert.assertEquals((Object)"first3Letters", (Object)extractionDimensionSpec.getOutputName());
        Assert.assertEquals((Object)"myDim", (Object)extractionDimensionSpec.getDimension());
        Assert.assertNotNull((Object)extractionDimensionSpec.getExtractionFn());
        Assert.assertTrue((boolean)(extractionDimensionSpec.getExtractionFn() instanceof RegexDimExtractionFn));
        Assert.assertEquals((Object)extractionDimensionSpec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)extractionDimensionSpec), DimensionSpec.class));
        String oldAndNewJson = "{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"extractionFn\": {\n        \"type\": \"partial\",\n        \"expr\": \"(...).*\"\n    },\n    \"dimExtractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}";
        Assert.assertTrue((boolean)(((DimensionSpec)objectMapper.readValue("{\n    \"type\": \"extraction\",\n    \"outputName\": \"first3Letters\",\n    \"dimension\": \"myDim\",    \"extractionFn\": {\n        \"type\": \"partial\",\n        \"expr\": \"(...).*\"\n    },\n    \"dimExtractionFn\": {\n        \"type\": \"regex\",\n        \"expr\": \"(...).*\"\n    }\n}", DimensionSpec.class)).getExtractionFn() instanceof MatchingDimExtractionFn));
    }

    @Test
    public void testCacheKey() {
        ExtractionDimensionSpec dimensionSpec = new ExtractionDimensionSpec("foo", "len", ColumnType.LONG, (ExtractionFn)StrlenExtractionFn.instance());
        byte[] expected = new byte[]{1, 7, 102, 111, 111, 9, 14, 7, 76, 79, 78, 71};
        Assert.assertArrayEquals((byte[])expected, (byte[])dimensionSpec.getCacheKey());
    }
}

