/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.Random;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.SerializablePairLongLongSimpleStagedSerde;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairLongLongSimpleStagedSerdeTest {
    private static final SerializablePairLongLongSimpleStagedSerde SERDE = new SerializablePairLongLongSimpleStagedSerde();
    private final Random random = new Random(0L);

    @Test
    public void testSimple() {
        SerializablePairLongLongSimpleStagedSerdeTest.assertValueEquals(new SerializablePairLongLong(Long.valueOf(Long.MAX_VALUE), Long.valueOf(10L)), 17);
    }

    @Test
    public void testNull() {
        SerializablePairLongLongSimpleStagedSerdeTest.assertValueEquals(null, 0);
    }

    @Test
    public void testNullString() {
        SerializablePairLongLongSimpleStagedSerdeTest.assertValueEquals(new SerializablePairLongLong(Long.valueOf(Long.MAX_VALUE), null), 9);
    }

    @Test
    public void testLargeRHS() {
        SerializablePairLongLongSimpleStagedSerdeTest.assertValueEquals(new SerializablePairLongLong(Long.valueOf(Long.MAX_VALUE), Long.valueOf(this.random.nextLong())), 17);
    }

    private static void assertValueEquals(@Nullable SerializablePairLongLong value, int size) {
        byte[] bytes = SERDE.serialize((Object)value);
        Assert.assertEquals((long)size, (long)bytes.length);
        SerializablePairLongLong deserialized = (SerializablePairLongLong)SERDE.deserialize(bytes);
        Assert.assertEquals((Object)value, (Object)deserialized);
    }
}

