/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.Random;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.SerializablePairLongLongDeltaEncodedStagedSerde;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairLongLongDeltaEncodedStagedSerdeTest {
    private static final SerializablePairLongLongDeltaEncodedStagedSerde INTEGER_SERDE = new SerializablePairLongLongDeltaEncodedStagedSerde(0L, true);
    private static final SerializablePairLongLongDeltaEncodedStagedSerde LONG_SERDE = new SerializablePairLongLongDeltaEncodedStagedSerde(0L, false);
    private final Random random = new Random(0L);

    @Test
    public void testNull() {
        SerializablePairLongLongDeltaEncodedStagedSerdeTest.assertValueEquals(null, 0, INTEGER_SERDE);
    }

    @Test
    public void testSimpleInteger() {
        SerializablePairLongLongDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongLong(Long.valueOf(100L), Long.valueOf(10L)), 13, INTEGER_SERDE);
    }

    @Test
    public void testNullRHSInteger() {
        SerializablePairLongLongDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongLong(Long.valueOf(100L), null), 5, INTEGER_SERDE);
    }

    @Test
    public void testLargeRHSInteger() {
        SerializablePairLongLongDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongLong(Long.valueOf(100L), Long.valueOf(this.random.nextLong())), 13, INTEGER_SERDE);
    }

    @Test
    public void testSimpleLong() {
        SerializablePairLongLongDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongLong(Long.valueOf(100L), Long.valueOf(10L)), 17, LONG_SERDE);
    }

    @Test
    public void testNullRHSLong() {
        SerializablePairLongLongDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongLong(Long.valueOf(100L), null), 9, LONG_SERDE);
    }

    @Test
    public void testLargeRHSLong() {
        SerializablePairLongLongDeltaEncodedStagedSerdeTest.assertValueEquals(new SerializablePairLongLong(Long.valueOf(100L), Long.valueOf(this.random.nextLong())), 17, LONG_SERDE);
    }

    private static void assertValueEquals(@Nullable SerializablePairLongLong value, int size, SerializablePairLongLongDeltaEncodedStagedSerde serde) {
        byte[] bytes = serde.serialize((Object)value);
        Assert.assertEquals((long)size, (long)bytes.length);
        SerializablePairLongLong deserialized = (SerializablePairLongLong)serde.deserialize(bytes);
        Assert.assertEquals((Object)value, (Object)deserialized);
    }
}

