/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FloatMaxAggregationTest {
    private final FloatMaxAggregatorFactory floatMaxAggregatorFactory;
    private VectorColumnSelectorFactory vectorColumnSelectorFactory;
    private final float[] floatValues1 = new float[]{5.0f, 2.0f, 4.0f, 100.0f, 1.0f, 5.0f, -2.0f, -3.0f, 0.0f, 55.0f};

    public FloatMaxAggregationTest() throws Exception {
        String vectorAggSpecJson = "{\"type\": \"floatMax\", \"name\": \"flt\", \"fieldName\": \"fltFld\"}";
        this.floatMaxAggregatorFactory = (FloatMaxAggregatorFactory)TestHelper.makeJsonMapper().readValue(vectorAggSpecJson, FloatMaxAggregatorFactory.class);
    }

    @Before
    public void setup() {
        VectorValueSelector vectorValueSelector = (VectorValueSelector)EasyMock.createMock(VectorValueSelector.class);
        EasyMock.expect((Object)vectorValueSelector.getFloatVector()).andReturn((Object)this.floatValues1).anyTimes();
        EasyMock.expect((Object)vectorValueSelector.getNullVector()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{vectorValueSelector});
        this.vectorColumnSelectorFactory = (VectorColumnSelectorFactory)EasyMock.createMock(VectorColumnSelectorFactory.class);
        EasyMock.expect((Object)this.vectorColumnSelectorFactory.getColumnCapabilities("fltFld")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ColumnType.FLOAT).setDictionaryEncoded(true)).anyTimes();
        EasyMock.expect((Object)this.vectorColumnSelectorFactory.makeValueSelector("fltFld")).andReturn((Object)vectorValueSelector).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.vectorColumnSelectorFactory});
    }

    @Test
    public void testFloatMaxVectorAggregator() {
        Assert.assertTrue((boolean)this.floatMaxAggregatorFactory.canVectorize((ColumnInspector)this.vectorColumnSelectorFactory));
        VectorValueSelector vectorValueSelector = this.floatMaxAggregatorFactory.vectorSelector(this.vectorColumnSelectorFactory);
        Assert.assertEquals((Object)this.floatValues1, (Object)vectorValueSelector.getFloatVector());
        VectorAggregator vectorAggregator = this.floatMaxAggregatorFactory.factorizeVector(this.vectorColumnSelectorFactory);
        ByteBuffer buf = ByteBuffer.allocate(this.floatMaxAggregatorFactory.getMaxIntermediateSizeWithNulls() * 3);
        vectorAggregator.init(buf, 0);
        vectorAggregator.aggregate(buf, 0, 0, 3);
        Assert.assertEquals((Object)Float.valueOf(this.floatValues1[0]), (Object)vectorAggregator.get(buf, 0));
        vectorAggregator.init(buf, 4);
        vectorAggregator.aggregate(buf, 4, 0, 3);
        Assert.assertEquals((Object)Float.valueOf(this.floatValues1[0]), (Object)vectorAggregator.get(buf, 4));
        vectorAggregator.init(buf, 8);
        vectorAggregator.aggregate(buf, 8, 4, 7);
        Assert.assertEquals((Object)Float.valueOf(this.floatValues1[5]), (Object)vectorAggregator.get(buf, 8));
        vectorAggregator.init(buf, 0);
        vectorAggregator.aggregate(buf, 0, 0, 10);
        Assert.assertEquals((Object)Float.valueOf(this.floatValues1[3]), (Object)vectorAggregator.get(buf, 0));
    }
}

