/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LookupDataSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final LookupDataSource lookylooDataSource = new LookupDataSource("lookyloo");

    @Test
    public void test_getTableNames() {
        Assert.assertEquals(Collections.emptySet(), (Object)this.lookylooDataSource.getTableNames());
    }

    @Test
    public void test_getChildren() {
        Assert.assertEquals(Collections.emptyList(), (Object)this.lookylooDataSource.getChildren());
    }

    @Test
    public void test_isCacheable() {
        Assert.assertFalse((boolean)this.lookylooDataSource.isCacheable(true));
        Assert.assertFalse((boolean)this.lookylooDataSource.isCacheable(false));
    }

    @Test
    public void test_isGlobal() {
        Assert.assertTrue((boolean)this.lookylooDataSource.isGlobal());
    }

    @Test
    public void test_isConcrete() {
        Assert.assertTrue((boolean)this.lookylooDataSource.isConcrete());
    }

    @Test
    public void test_withChildren_empty() {
        Assert.assertSame((Object)this.lookylooDataSource, (Object)this.lookylooDataSource.withChildren(Collections.emptyList()));
    }

    @Test
    public void test_withChildren_nonEmpty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Cannot accept children");
        this.lookylooDataSource.withChildren((List)ImmutableList.of((Object)new LookupDataSource("bar")));
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(LookupDataSource.class).usingGetClass().withNonnullFields(new String[]{"lookupName"}).verify();
    }

    @Test
    public void test_serde() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        LookupDataSource deserialized = (LookupDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)this.lookylooDataSource), DataSource.class);
        Assert.assertEquals((Object)this.lookylooDataSource, (Object)deserialized);
    }
}

