/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FilteredDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FilteredDataSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final TableDataSource fooDataSource = new TableDataSource("foo");
    private final TableDataSource barDataSource = new TableDataSource("bar");
    private final FilteredDataSource filteredFooDataSource = FilteredDataSource.create((DataSource)this.fooDataSource, null);
    private final FilteredDataSource filteredBarDataSource = FilteredDataSource.create((DataSource)this.barDataSource, null);

    @Test
    public void test_getTableNames() {
        Assert.assertEquals(Collections.singleton("foo"), (Object)this.filteredFooDataSource.getTableNames());
    }

    @Test
    public void test_getChildren() {
        Assert.assertEquals(Collections.singletonList(this.fooDataSource), (Object)this.filteredFooDataSource.getChildren());
    }

    @Test
    public void test_isCacheable() {
        Assert.assertFalse((boolean)this.filteredFooDataSource.isCacheable(true));
    }

    @Test
    public void test_isGlobal() {
        Assert.assertFalse((boolean)this.filteredFooDataSource.isGlobal());
    }

    @Test
    public void test_isConcrete() {
        Assert.assertTrue((boolean)this.filteredFooDataSource.isConcrete());
    }

    @Test
    public void test_withChildren_empty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected [1] child");
        Assert.assertSame((Object)this.filteredFooDataSource, (Object)this.filteredFooDataSource.withChildren(Collections.emptyList()));
    }

    @Test
    public void test_withChildren_nonEmpty() {
        FilteredDataSource newFilteredDataSource = (FilteredDataSource)this.filteredFooDataSource.withChildren((List)ImmutableList.of((Object)new TableDataSource("bar")));
        Assert.assertTrue((boolean)newFilteredDataSource.getBase().equals(this.barDataSource));
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Expected [1] child");
        this.filteredFooDataSource.withChildren((List)ImmutableList.of((Object)this.fooDataSource, (Object)this.barDataSource));
    }

    @Test
    public void test_withUpdatedDataSource() {
        FilteredDataSource newFilteredDataSource = (FilteredDataSource)this.filteredFooDataSource.withUpdatedDataSource((DataSource)new TableDataSource("bar"));
        Assert.assertTrue((boolean)newFilteredDataSource.getBase().equals(this.barDataSource));
    }

    @Test
    public void test_withAnalysis() {
        Assert.assertTrue((boolean)this.filteredFooDataSource.getAnalysis().equals((Object)this.fooDataSource.getAnalysis()));
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(FilteredDataSource.class).usingGetClass().withNonnullFields(new String[]{"base"}).verify();
    }

    @Test
    public void test_serde_roundTrip() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        FilteredDataSource deserialized = (FilteredDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)this.filteredFooDataSource), DataSource.class);
        Assert.assertEquals((Object)this.filteredFooDataSource, (Object)deserialized);
        Assert.assertNotEquals((Object)this.fooDataSource, (Object)deserialized);
    }

    @Test
    public void test_deserialize_fromObject() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        FilteredDataSource deserializedFilteredDataSource = (FilteredDataSource)jsonMapper.readValue("{\"type\":\"filter\",\"base\":{\"type\":\"table\",\"name\":\"foo\"},\"filter\":null}", FilteredDataSource.class);
        Assert.assertEquals((Object)this.filteredFooDataSource, (Object)deserializedFilteredDataSource);
        Assert.assertNotEquals((Object)this.fooDataSource, (Object)deserializedFilteredDataSource);
    }

    @Test
    public void test_serialize() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        String s = jsonMapper.writeValueAsString((Object)this.filteredFooDataSource);
        Assert.assertEquals((Object)"{\"type\":\"filter\",\"base\":{\"type\":\"table\",\"name\":\"foo\"},\"filter\":null}", (Object)s);
    }

    @Test
    public void testStringRep() {
        Assert.assertFalse((boolean)this.filteredFooDataSource.toString().equals(this.filteredBarDataSource.toString()));
    }
}

