/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.metrics.ProcFsReader;
import org.apache.druid.java.util.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ProcFsReaderTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File procDir;

    @Before
    public void setUp() throws IOException {
        this.procDir = this.temporaryFolder.newFolder();
        File kernelDir = new File(this.procDir, "sys/kernel/random");
        FileUtils.mkdirp((File)kernelDir);
        TestUtils.copyResource("/cpuinfo", new File(this.procDir, "cpuinfo"));
        TestUtils.copyResource("/boot_id", new File(kernelDir, "boot_id"));
    }

    @Test
    public void testUtilThrowsOnBadDir() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new ProcFsReader(Paths.get(this.procDir + "_dummy", new String[0])));
    }

    @Test
    public void testBootId() {
        ProcFsReader fetcher = new ProcFsReader(this.procDir.toPath());
        Assert.assertEquals((Object)"ad1f0a5c-55ea-4a49-9db8-bbb0f22e2ba6", (Object)fetcher.getBootId().toString());
    }

    @Test
    public void testProcessorCount() {
        ProcFsReader fetcher = new ProcFsReader(this.procDir.toPath());
        Assert.assertEquals((long)8L, (long)fetcher.getProcessorCount());
    }
}

