/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.java.util.common.StringUtils;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.junit.Assert;
import org.junit.Test;

public class AsyncHttpClientTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestTimeout() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final ServerSocket serverSocket = new ServerSocket(0);
        exec.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Socket clientSocket = serverSocket.accept();
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));){
                            OutputStream out = clientSocket.getOutputStream();
                            try {
                                while (!in.readLine().equals("")) {
                                }
                                Thread.sleep(5000L);
                                out.write("HTTP/1.1 200 OK\r\nContent-Length: 6\r\n\r\nhello!".getBytes(StandardCharsets.UTF_8));
                            }
                            finally {
                                if (out == null) continue;
                                out.close();
                            }
                        }
                        finally {
                            if (clientSocket == null) continue;
                            clientSocket.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        long requestStart = 0L;
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient();
        this.warmUp(serverSocket, client);
        try {
            requestStart = System.currentTimeMillis();
            ListenableFuture future = ((BoundRequestBuilder)client.prepareGet(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{serverSocket.getLocalPort()})).setRequestTimeout(2000)).execute();
            System.out.println("created future in: " + (System.currentTimeMillis() - requestStart));
            future.get(3000L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected timeout");
        }
        catch (ExecutionException | TimeoutException e) {
            long elapsed = System.currentTimeMillis() - requestStart;
            Assert.assertTrue((String)("elapsed: " + elapsed), (elapsed < 2200L ? 1 : 0) != 0);
        }
        finally {
            exec.shutdownNow();
            serverSocket.close();
        }
    }

    private void warmUp(ServerSocket serverSocket, DefaultAsyncHttpClient client) {
        try {
            ListenableFuture future = ((BoundRequestBuilder)client.prepareGet(StringUtils.format((String)"http://localhost:%d/", (Object[])new Object[]{serverSocket.getLocalPort()})).setRequestTimeout(100)).execute();
            future.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

