/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.SwitchingEmitter;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SwitchingEmitterTest {
    private static final String FEED_1 = "feed1";
    private static final String FEED_2 = "feed2";
    private static final String FEED_3 = "feed3";
    private SwitchingEmitter switchingEmitter;
    private Map<String, List<Emitter>> emitters;
    private List<Emitter> defaultEmitters;
    private Emitter feed1Emitter1;
    private Emitter feed1Emitter2;
    private Emitter feed2Emitter1;
    private Emitter feed1AndFeed3Emitter;
    private Set<Emitter> allEmitters;

    @Before
    public void setup() {
        this.defaultEmitters = ImmutableList.of((Object)((Emitter)EasyMock.createMock(Emitter.class)), (Object)((Emitter)EasyMock.createMock(Emitter.class)));
        this.feed1Emitter1 = (Emitter)EasyMock.createMock(Emitter.class);
        this.feed1Emitter2 = (Emitter)EasyMock.createMock(Emitter.class);
        this.feed2Emitter1 = (Emitter)EasyMock.createMock(Emitter.class);
        this.feed1AndFeed3Emitter = (Emitter)EasyMock.createMock(Emitter.class);
        this.emitters = ImmutableMap.of((Object)FEED_1, (Object)ImmutableList.of((Object)this.feed1Emitter1, (Object)this.feed1Emitter2, (Object)this.feed1AndFeed3Emitter), (Object)FEED_2, (Object)ImmutableList.of((Object)this.feed2Emitter1), (Object)FEED_3, (Object)ImmutableList.of((Object)this.feed1AndFeed3Emitter));
        this.allEmitters = new HashSet<Emitter>();
        this.allEmitters.addAll(this.defaultEmitters);
        for (List<Emitter> feedEmitters : this.emitters.values()) {
            this.allEmitters.addAll(feedEmitters);
        }
        this.switchingEmitter = new SwitchingEmitter(this.emitters, this.defaultEmitters.toArray(new Emitter[0]));
    }

    @Test
    public void testStart() {
        for (Emitter emitter : this.allEmitters) {
            emitter.start();
            EasyMock.replay((Object[])new Object[]{emitter});
        }
        this.switchingEmitter.start();
    }

    @Test
    public void testEmit() {
        Event feed1Event = (Event)EasyMock.createMock(Event.class);
        Event feed2Event = (Event)EasyMock.createMock(Event.class);
        Event feed3Event = (Event)EasyMock.createMock(Event.class);
        Event eventWithNoMatchingFeed = (Event)EasyMock.createMock(Event.class);
        EasyMock.expect((Object)feed1Event.getFeed()).andReturn((Object)FEED_1).anyTimes();
        EasyMock.expect((Object)feed2Event.getFeed()).andReturn((Object)FEED_2).anyTimes();
        EasyMock.expect((Object)feed3Event.getFeed()).andReturn((Object)FEED_3).anyTimes();
        EasyMock.expect((Object)eventWithNoMatchingFeed.getFeed()).andReturn((Object)"no-real-feed").anyTimes();
        EasyMock.replay((Object[])new Object[]{feed1Event, feed2Event, feed3Event, eventWithNoMatchingFeed});
        for (Emitter emitter : this.defaultEmitters) {
            emitter.emit(eventWithNoMatchingFeed);
        }
        for (Emitter emitter : this.emitters.get(FEED_1)) {
            emitter.emit(feed1Event);
        }
        for (Emitter emitter : this.emitters.get(FEED_2)) {
            emitter.emit(feed2Event);
        }
        for (Emitter emitter : this.emitters.get(FEED_3)) {
            emitter.emit(feed3Event);
        }
        for (Emitter emitter : this.allEmitters) {
            EasyMock.replay((Object[])new Object[]{emitter});
        }
        this.switchingEmitter.emit(feed1Event);
        this.switchingEmitter.emit(feed2Event);
        this.switchingEmitter.emit(feed3Event);
        this.switchingEmitter.emit(eventWithNoMatchingFeed);
    }

    @Test
    public void testFlush() throws IOException {
        for (Emitter emitter : this.allEmitters) {
            emitter.flush();
            EasyMock.replay((Object[])new Object[]{emitter});
        }
        this.switchingEmitter.flush();
    }

    @Test
    public void testClose() throws IOException {
        for (Emitter emitter : this.allEmitters) {
            emitter.close();
            EasyMock.replay((Object[])new Object[]{emitter});
        }
        this.switchingEmitter.close();
    }

    @After
    public void tearDown() {
        for (Emitter emitter : this.allEmitters) {
            EasyMock.verify((Object[])new Object[]{emitter});
        }
    }
}

