/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import org.apache.druid.java.util.common.parsers.ParserUtils;
import org.junit.Assert;
import org.junit.Test;

public class ParserUtilsTest {
    @Test
    public void testFindDuplicatesMixedCases() {
        ImmutableList fields = ImmutableList.of((Object)"f1", (Object)"f2", (Object)"F1", (Object)"F2", (Object)"f3");
        Assert.assertEquals(Collections.emptySet(), (Object)ParserUtils.findDuplicates((Iterable)fields));
    }

    @Test
    public void testFindDuplicates() {
        ImmutableList fields = ImmutableList.of((Object)"f1", (Object)"f2", (Object)"F1", (Object)"F2", (Object)"f1", (Object)"F2");
        Assert.assertEquals((Object)ImmutableSet.of((Object)"f1", (Object)"F2"), (Object)ParserUtils.findDuplicates((Iterable)fields));
    }

    @Test
    public void testInputWithDelimiterAndParserDisabled() {
        Assert.assertNull((Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply(null));
        Assert.assertEquals((Object)"", (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)""));
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"boo"), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"foo|boo"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"1|2|3"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"1", (Object)"-2", (Object)"3", (Object)"0", (Object)"-2"), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"1|-2|3|0|-2"));
        Assert.assertEquals((Object)"100", (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"100"));
        Assert.assertEquals((Object)"1.23", (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"1.23"));
        Assert.assertEquals((Object)"-2.0", (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"-2.0"));
        Assert.assertEquals((Object)"1e2", (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"1e2"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"1|2|3"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"1", (Object)"-2", (Object)"3", (Object)"0", (Object)"-2"), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"1|-2|3|0|-2"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"-1.0", (Object)"-2.2", (Object)"3.1", (Object)"0.2", (Object)"-2.1"), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"-1.0|-2.2|3.1|0.2|-2.1"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"-1.23", (Object)"3.13", (Object)"23"), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"-1.23|3.13|23"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"-1.23", (Object)"3.13", (Object)"23", (Object)"foo", (Object)"-9"), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)false).apply((Object)"-1.23|3.13|23|foo|-9"));
    }

    @Test
    public void testInputWithDelimiterAndParserEnabled() {
        Assert.assertNull((Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply(null));
        Assert.assertEquals((Object)"", (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)""));
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo", (Object)"boo"), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"foo|boo"));
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"1|2|3"));
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)-2L, (Object)3L, (Object)0L, (Object)-2L), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"1|-2|3|0|-2"));
        Assert.assertEquals((Object)100L, (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"100"));
        Assert.assertEquals((Object)1.23, (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"1.23"));
        Assert.assertEquals((Object)-2.0, (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"-2.0"));
        Assert.assertEquals((Object)100.0, (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"1e2"));
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"1|2|3"));
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)-2L, (Object)3L, (Object)0L, (Object)-2L), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"1|-2|3|0|-2"));
        Assert.assertEquals((Object)ImmutableList.of((Object)-1.0, (Object)-2.2, (Object)3.1, (Object)0.2, (Object)-2.1), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"-1.0|-2.2|3.1|0.2|-2.1"));
        Assert.assertEquals((Object)ImmutableList.of((Object)-1.23, (Object)3.13, (Object)23L), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"-1.23|3.13|23"));
        Assert.assertEquals((Object)ImmutableList.of((Object)-1.23, (Object)3.13, (Object)23L, (Object)"foo", (Object)-9L), (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"|"), (boolean)true).apply((Object)"-1.23|3.13|23|foo|-9"));
    }

    @Test
    public void testInputWithoutDelimiterAndNumberParsingDisabled() {
        Assert.assertNull((Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"$"), (boolean)false).apply(null));
        Assert.assertEquals((Object)"", (Object)ParserUtils.getTransformationFunction((String)"|", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)""));
        Assert.assertEquals((Object)"foo|boo", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)"foo|boo"));
        Assert.assertEquals((Object)"100", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)"100"));
        Assert.assertEquals((Object)"1.23", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)"1.23"));
        Assert.assertEquals((Object)"-2.0", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)"-2.0"));
        Assert.assertEquals((Object)"1e2", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)"1e2"));
        Assert.assertEquals((Object)"1|2|3", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)"1|2|3"));
        Assert.assertEquals((Object)"1|-2|3|0|-2", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)"1|-2|3|0|-2"));
        Assert.assertEquals((Object)"-1.0|-2.2|3.1|0.2|-2.1", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)"-1.0|-2.2|3.1|0.2|-2.1"));
        Assert.assertEquals((Object)"-1.23|3.13|23", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)"-1.23|3.13|23"));
        Assert.assertEquals((Object)"-1.23|3.13|23|foo|-9", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)false).apply((Object)"-1.23|3.13|23|foo|-9"));
    }

    @Test
    public void testInputWithoutDelimiterAndNumberParsingEnabled() {
        Assert.assertNull((Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply(null));
        Assert.assertEquals((Object)"", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)""));
        Assert.assertEquals((Object)"foo|boo", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)"foo|boo"));
        Assert.assertEquals((Object)100L, (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)"100"));
        Assert.assertEquals((Object)1.23, (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)"1.23"));
        Assert.assertEquals((Object)-2.0, (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)"-2.0"));
        Assert.assertEquals((Object)100.0, (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)"1e2"));
        Assert.assertEquals((Object)"1|2|3", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)"1|2|3"));
        Assert.assertEquals((Object)"1|-2|3|0|-2", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)"1|-2|3|0|-2"));
        Assert.assertEquals((Object)"-1.0|-2.2|3.1|0.2|-2.1", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)"-1.0|-2.2|3.1|0.2|-2.1"));
        Assert.assertEquals((Object)"-1.23|3.13|23", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)"-1.23|3.13|23"));
        Assert.assertEquals((Object)"-1.23|3.13|23|foo|-9", (Object)ParserUtils.getTransformationFunction((String)"$", (Splitter)Splitter.on((String)"$"), (boolean)true).apply((Object)"-1.23|3.13|23|foo|-9"));
    }
}

