/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.druid.query.extraction.UpperExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class FrameCursorFactoryTest {

    @RunWith(value=Parameterized.class)
    public static class CursorTests
    extends InitializedNullHandlingTest {
        private static final int VECTOR_SIZE = 7;
        private final FrameType frameType;
        @Nullable
        private final Filter filter;
        private final Interval interval;
        private final VirtualColumns virtualColumns;
        private final boolean descending;
        private CursorFactory queryableCursorFactory;
        private FrameSegment frameSegment;
        private CursorFactory frameCursorFactory;
        private final QueryContext queryContext = QueryContext.of((Map)ImmutableMap.of((Object)"vectorSize", (Object)7));
        private CursorBuildSpec buildSpec;

        public CursorTests(FrameType frameType, @Nullable DimFilter filter, Interval interval, VirtualColumns virtualColumns, boolean descending) {
            this.frameType = frameType;
            this.filter = Filters.toFilter((DimFilter)filter);
            this.interval = interval;
            this.virtualColumns = virtualColumns;
            this.descending = descending;
            this.buildSpec = CursorBuildSpec.builder().setFilter(this.filter).setInterval(this.interval).setVirtualColumns(this.virtualColumns).setPreferredOrdering(descending ? Cursors.descendingTimeOrder() : Collections.emptyList()).setQueryContext(this.queryContext).build();
        }

        @Parameterized.Parameters(name="frameType = {0}, filter = {1}, interval = {2}, virtualColumns = {3}, descending = {4}")
        public static Iterable<Object[]> constructorFeeder() {
            ArrayList<Object[]> constructors = new ArrayList<Object[]>();
            List<Interval> intervals = Arrays.asList(TestIndex.getMMappedTestIndex().getDataInterval(), Intervals.ETERNITY, Intervals.of((String)"2011-04-01T00:00:00.000Z/2011-04-02T00:00:00.000Z"), Intervals.of((String)"3001/3002"));
            ArrayList<Pair> filtersAndVirtualColumns = new ArrayList<Pair>();
            filtersAndVirtualColumns.add(Pair.of(null, (Object)VirtualColumns.EMPTY));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("quality", "automotive", null), (Object)VirtualColumns.EMPTY));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("expr", "1401", null), (Object)VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("expr", "qualityLong + 1", ColumnType.LONG, ExprMacroTable.nil())))));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("qualityLong", "1400", null), (Object)VirtualColumns.EMPTY));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("quality", "automotive", (ExtractionFn)new UpperExtractionFn(null)), (Object)VirtualColumns.EMPTY));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("__time", "Friday", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false)), (Object)VirtualColumns.EMPTY));
            filtersAndVirtualColumns.add(Pair.of((Object)new SelectorDimFilter("__time", "Friday", (ExtractionFn)new TimeFormatExtractionFn("EEEE", null, null, null, false)), (Object)VirtualColumns.EMPTY));
            for (FrameType frameType : FrameType.values()) {
                for (Pair filterVirtualColumnsPair : filtersAndVirtualColumns) {
                    for (Interval interval : intervals) {
                        for (boolean descending : Arrays.asList(false, true)) {
                            constructors.add(new Object[]{frameType, filterVirtualColumnsPair.lhs, interval, filterVirtualColumnsPair.rhs, descending});
                        }
                    }
                }
            }
            return constructors;
        }

        @Before
        public void setUp() {
            this.queryableCursorFactory = new QueryableIndexCursorFactory(TestIndex.getMMappedTestIndex());
            this.frameSegment = FrameTestUtil.cursorFactoryToFrameSegment(this.queryableCursorFactory, this.frameType);
            this.frameCursorFactory = this.frameSegment.asCursorFactory();
        }

        @After
        public void tearDown() {
            if (this.frameSegment != null) {
                this.frameSegment.close();
            }
        }

        @Test
        public void test_makeCursor() {
            RowSignature signature = this.frameCursorFactory.getRowSignature();
            CursorBuildSpec queryableBuildSpec = CursorBuildSpec.builder((CursorBuildSpec)this.buildSpec).setPreferredOrdering(Collections.emptyList()).build();
            try (CursorHolder queryableCursorHolder = this.queryableCursorFactory.makeCursorHolder(queryableBuildSpec);
                 CursorHolder frameCursorHolder = this.frameCursorFactory.makeCursorHolder(this.buildSpec);){
                Sequence<List<Object>> queryableRows = FrameTestUtil.readRowsFromCursor(CursorTests.advanceAndReset(queryableCursorHolder.asCursor()), signature);
                Sequence<List<Object>> frameRows = FrameTestUtil.readRowsFromCursor(CursorTests.advanceAndReset(frameCursorHolder.asCursor()), signature);
                FrameTestUtil.assertRowsEqual(queryableRows, frameRows);
            }
        }

        @Test
        public void test_makeVectorCursor() {
            Assume.assumeThat((Object)this.frameType, (Matcher)CoreMatchers.equalTo((Object)FrameType.COLUMNAR));
            Assume.assumeFalse((boolean)this.descending);
            this.assertVectorCursorsMatch(cursorFactory -> cursorFactory.makeCursorHolder(this.buildSpec));
        }

        private void assertVectorCursorsMatch(Function<CursorFactory, CursorHolder> call) {
            CursorHolder cursorHolder = call.apply(this.queryableCursorFactory);
            CursorHolder frameCursorHolder = call.apply(this.frameCursorFactory);
            Assert.assertTrue((String)"queryable cursor is vectorizable", (boolean)cursorHolder.canVectorize());
            Assert.assertTrue((String)"frame cursor is vectorizable", (boolean)frameCursorHolder.canVectorize());
            RowSignature signature = this.frameCursorFactory.getRowSignature();
            Sequence queryableRows = FrameTestUtil.readRowsFromVectorCursor(CursorTests.advanceAndReset(cursorHolder.asVectorCursor()), signature).withBaggage((Closeable)cursorHolder);
            Sequence frameRows = FrameTestUtil.readRowsFromVectorCursor(CursorTests.advanceAndReset(frameCursorHolder.asVectorCursor()), signature).withBaggage((Closeable)frameCursorHolder);
            FrameTestUtil.assertRowsEqual((Sequence<List<Object>>)queryableRows, (Sequence<List<Object>>)frameRows);
        }

        private static Cursor advanceAndReset(Cursor cursor) {
            for (int i = 0; i < 3 && !cursor.isDone(); ++i) {
                cursor.advance();
            }
            cursor.reset();
            return cursor;
        }

        private static VectorCursor advanceAndReset(VectorCursor cursor) {
            for (int i = 0; i < 3 && !cursor.isDone(); ++i) {
                cursor.advance();
            }
            cursor.reset();
            return cursor;
        }
    }

    @RunWith(value=Parameterized.class)
    public static class BasicTests
    extends InitializedNullHandlingTest {
        private final FrameType frameType;
        private CursorFactory queryableCursorFactory;
        private FrameSegment frameSegment;
        private CursorFactory frameCursorFactory;

        public BasicTests(FrameType frameType) {
            this.frameType = frameType;
        }

        @Parameterized.Parameters(name="frameType = {0}")
        public static Iterable<Object[]> constructorFeeder() {
            ArrayList<Object[]> constructors = new ArrayList<Object[]>();
            for (FrameType frameType : FrameType.values()) {
                constructors.add(new Object[]{frameType});
            }
            return constructors;
        }

        @Before
        public void setUp() {
            this.queryableCursorFactory = new QueryableIndexCursorFactory(TestIndex.getMMappedTestIndex());
            this.frameSegment = FrameTestUtil.cursorFactoryToFrameSegment(this.queryableCursorFactory, this.frameType);
            this.frameCursorFactory = this.frameSegment.asCursorFactory();
        }

        @After
        public void tearDown() {
            if (this.frameSegment != null) {
                this.frameSegment.close();
            }
        }

        @Test
        public void test_getRowSignature() {
            Assert.assertEquals((Object)this.queryableCursorFactory.getRowSignature(), (Object)this.frameCursorFactory.getRowSignature());
        }

        @Test
        public void test_getColumnCapabilities_typeOfKnownColumns() {
            for (String columnName : this.frameCursorFactory.getRowSignature().getColumnNames()) {
                ColumnCapabilities expectedCapabilities = this.queryableCursorFactory.getColumnCapabilities(columnName);
                ColumnCapabilities actualCapabilities = this.frameCursorFactory.getColumnCapabilities(columnName);
                Assert.assertEquals((String)StringUtils.format((String)"column [%s] type", (Object[])new Object[]{columnName}), (Object)expectedCapabilities.toColumnType(), (Object)actualCapabilities.toColumnType());
                if (this.frameType == FrameType.COLUMNAR) {
                    Assert.assertEquals((String)StringUtils.format((String)"column [%s] hasMultipleValues", (Object[])new Object[]{columnName}), (Object)expectedCapabilities.hasMultipleValues(), (Object)actualCapabilities.hasMultipleValues());
                    continue;
                }
                Assert.assertEquals((String)StringUtils.format((String)"column [%s] hasMultipleValues", (Object[])new Object[]{columnName}), (Object)(expectedCapabilities.getType() == ValueType.STRING ? ColumnCapabilities.Capable.UNKNOWN : ColumnCapabilities.Capable.FALSE), (Object)actualCapabilities.hasMultipleValues());
            }
        }

        @Test
        public void test_getColumnCapabilities_unknownColumn() {
            Assert.assertNull((Object)this.frameCursorFactory.getColumnCapabilities("nonexistent"));
        }
    }
}

