/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.test;

import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;

public final class TestFrameProcessorUtils {
    private TestFrameProcessorUtils() {
    }

    public static CursorFactory toCursorFactory(List<InputRow> inputRows) {
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setIndexSchema(IncrementalIndexSchema.builder().withTimestampSpec(new TimestampSpec("__time", "millis", null)).withDimensionsSpec(DimensionsSpec.builder().useSchemaDiscovery(true).build()).withRollup(false).build()).setMaxRowCount(1000).build();
        try {
            for (InputRow inputRow : inputRows) {
                index.add(inputRow);
            }
        }
        catch (IndexSizeExceededException e) {
            throw new RuntimeException(e);
        }
        return new IncrementalIndexCursorFactory(index);
    }

    public static Frame toFrame(List<InputRow> inputRows) {
        CursorFactory cursorFactory = TestFrameProcessorUtils.toCursorFactory(inputRows);
        return (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromCursorFactory(cursorFactory).frameType(FrameType.ROW_BASED).frames().toList());
    }
}

