/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.test;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.joda.time.Duration;

public class SleepyFrameProcessor
implements FrameProcessor<Long> {
    private final CountDownLatch didRun = new CountDownLatch(1);
    private final AtomicBoolean didGetInterrupt = new AtomicBoolean(false);
    private final CountDownLatch cleanupLatch = new CountDownLatch(1);
    private final AtomicBoolean didCleanup = new AtomicBoolean(false);

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.emptyList();
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.emptyList();
    }

    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws InterruptedException {
        this.didRun.countDown();
        try {
            while (true) {
                Thread.sleep(Duration.standardDays((long)1L).getMillis());
            }
        }
        catch (InterruptedException e) {
            this.didGetInterrupt.set(true);
            throw e;
        }
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[0]);
        this.didCleanup.set(true);
        this.cleanupLatch.countDown();
    }

    public void awaitRun() throws InterruptedException {
        this.didRun.await();
    }

    public boolean didGetInterrupt() {
        return this.didGetInterrupt.get();
    }

    public boolean didCleanup() {
        return this.didCleanup.get();
    }

    public void awaitCleanup() throws InterruptedException {
        this.cleanupLatch.await();
    }
}

