/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.PartitionedReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class OutputChannelFactoryTest
extends InitializedNullHandlingTest {
    private final OutputChannelFactory outputChannelFactory;
    private final long frameSize;
    protected final CursorFactory sourceCursorFactory;
    protected final Frame frame;

    public OutputChannelFactoryTest(OutputChannelFactory outputChannelFactory, long frameSize) {
        this.outputChannelFactory = outputChannelFactory;
        this.frameSize = frameSize;
        this.sourceCursorFactory = new IncrementalIndexCursorFactory(TestIndex.getIncrementalTestIndex());
        this.frame = (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromCursorFactory(this.sourceCursorFactory).frameType(FrameType.COLUMNAR).frames().toList());
    }

    @Test
    public void test_openChannel() throws IOException, ExecutionException, InterruptedException {
        OutputChannel channel = this.outputChannelFactory.openChannel(1);
        Assert.assertEquals((long)1L, (long)channel.getPartitionNumber());
        WritableFrameChannel writableFrameChannel = channel.getWritableChannel();
        writableFrameChannel.writabilityFuture().get();
        writableFrameChannel.write(new FrameWithPartition(this.frame, 1));
        writableFrameChannel.close();
        this.verifySingleFrameReadableChannel(channel.getReadableChannel(), this.sourceCursorFactory);
        Assert.assertEquals((long)this.frameSize, (long)channel.getFrameMemoryAllocator().capacity());
    }

    @Test
    public void test_openPartitionedChannel() throws IOException, ExecutionException, InterruptedException {
        PartitionedOutputChannel channel = this.outputChannelFactory.openPartitionedChannel("test", true);
        int[] partitions = new int[]{1, 2};
        WritableFrameChannel writableFrameChannel = channel.getWritableChannel();
        writableFrameChannel.writabilityFuture().get();
        for (int partition : partitions) {
            writableFrameChannel.write(new FrameWithPartition(this.frame, partition));
        }
        writableFrameChannel.close();
        Supplier partitionedReadableFrameChannelSupplier = channel.getReadableChannelSupplier();
        for (int partition : partitions) {
            this.verifySingleFrameReadableChannel(((PartitionedReadableFrameChannel)partitionedReadableFrameChannelSupplier.get()).getReadableFrameChannel(partition), this.sourceCursorFactory);
            Assert.assertEquals((long)this.frameSize, (long)channel.getFrameMemoryAllocator().capacity());
        }
    }

    protected void verifySingleFrameReadableChannel(ReadableFrameChannel readableFrameChannel, CursorFactory cursorFactory) throws ExecutionException, InterruptedException {
        readableFrameChannel.readabilityFuture().get();
        while (!readableFrameChannel.canRead()) {
        }
        Frame readbackFrame = readableFrameChannel.read();
        readableFrameChannel.readabilityFuture().get();
        Assert.assertFalse((boolean)readableFrameChannel.canRead());
        Assert.assertTrue((boolean)readableFrameChannel.isFinished());
        readableFrameChannel.close();
        CursorFactory frameCursorFactory = FrameReader.create((RowSignature)cursorFactory.getRowSignature()).makeCursorFactory(readbackFrame);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);
             CursorHolder frameHolder = frameCursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            List writtenData = FrameTestUtil.readRowsFromCursor(cursorHolder.asCursor(), cursorFactory.getRowSignature()).toList();
            List readData = FrameTestUtil.readRowsFromCursor(frameHolder.asCursor(), frameCursorFactory.getRowSignature()).toList();
            Assert.assertEquals((String)"Read rows count is different from written rows count", (long)writtenData.size(), (long)readData.size());
            Assert.assertEquals((String)"Read data is different from written data", (Object)writtenData, (Object)readData);
        }
    }

    @Test
    public void test_openNilChannel() {
        OutputChannel channel = this.outputChannelFactory.openNilChannel(1);
        Assert.assertEquals((long)1L, (long)channel.getPartitionNumber());
        Assert.assertTrue((boolean)channel.getReadableChannel().isFinished());
        Assert.assertThrows(IllegalStateException.class, () -> ((OutputChannel)channel).getWritableChannel());
    }
}

