/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.TransformUtils;
import org.junit.Assert;
import org.junit.Test;

public class TransformUtilsTest {
    private final WritableMemory lhsMemory = WritableMemory.allocate((int)10);
    private final WritableMemory rhsMemory = WritableMemory.allocate((int)10);
    private static final long MEMORY_LOCATION = 0L;

    @Test
    public void doubleTestWithoutNaN() {
        ImmutableList values = ImmutableList.of((Object)Double.MAX_VALUE, (Object)Double.MIN_VALUE, (Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY, (Object)Double.MIN_NORMAL, (Object)0.0, (Object)1.234234, (Object)-1.344234, (Object)129123.123123, (Object)-2.131221333E7, (Object)1111.0, (Object)23.0, (Object[])new Double[0]);
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            double value = (Double)iterator.next();
            Assert.assertEquals((double)value, (double)TransformUtils.detransformToDouble((long)TransformUtils.transformFromDouble((double)value)), (double)0.0);
        }
        for (int lhsIndex = 0; lhsIndex < values.size(); ++lhsIndex) {
            for (int rhsIndex = lhsIndex; rhsIndex < values.size(); ++rhsIndex) {
                double lhs = (Double)values.get(lhsIndex);
                double rhs = (Double)values.get(rhsIndex);
                this.lhsMemory.putLong(0L, TransformUtils.transformFromDouble((double)lhs));
                this.rhsMemory.putLong(0L, TransformUtils.transformFromDouble((double)rhs));
                int byteCmp = this.byteComparison(8);
                if (byteCmp < 0) {
                    Assert.assertTrue((lhs < rhs ? 1 : 0) != 0);
                    continue;
                }
                if (byteCmp == 0) {
                    Assert.assertEquals((double)lhs, (double)rhs, (double)0.0);
                    continue;
                }
                Assert.assertTrue((lhs > rhs ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void longTest() {
        ImmutableList values = ImmutableList.of((Object)Long.MIN_VALUE, (Object)Long.MAX_VALUE, (Object)0L, (Object)123L, (Object)-123L);
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            long value = (Long)iterator.next();
            Assert.assertEquals((long)value, (long)TransformUtils.detransformToLong((long)TransformUtils.transformFromLong((long)value)));
        }
        for (int lhsIndex = 0; lhsIndex < values.size(); ++lhsIndex) {
            for (int rhsIndex = lhsIndex; rhsIndex < values.size(); ++rhsIndex) {
                long lhs = (Long)values.get(lhsIndex);
                long rhs = (Long)values.get(rhsIndex);
                this.lhsMemory.putLong(0L, TransformUtils.transformFromLong((long)lhs));
                this.rhsMemory.putLong(0L, TransformUtils.transformFromLong((long)rhs));
                int byteCmp = this.byteComparison(8);
                if (byteCmp < 0) {
                    Assert.assertTrue((lhs < rhs ? 1 : 0) != 0);
                    continue;
                }
                if (byteCmp == 0) {
                    Assert.assertEquals((long)lhs, (long)rhs);
                    continue;
                }
                Assert.assertTrue((lhs > rhs ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void floatTestWithoutNaN() {
        ImmutableList values = ImmutableList.of((Object)Float.valueOf(Float.MIN_VALUE), (Object)Float.valueOf(Float.MAX_VALUE), (Object)Float.valueOf(Float.MIN_NORMAL), (Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.234234f), (Object)Float.valueOf(-1.344234f), (Object)Float.valueOf(129123.125f), (Object)Float.valueOf(-2.1312214E7f), (Object)Float.valueOf(1111.0f), (Object)Float.valueOf(23.0f), (Object[])new Float[0]);
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            float value = ((Float)iterator.next()).floatValue();
            Assert.assertEquals((double)value, (double)TransformUtils.detransformToFloat((int)TransformUtils.transformFromFloat((float)value)), (double)0.0);
        }
        for (int lhsIndex = 0; lhsIndex < values.size(); ++lhsIndex) {
            for (int rhsIndex = lhsIndex; rhsIndex < values.size(); ++rhsIndex) {
                float lhs = ((Float)values.get(lhsIndex)).floatValue();
                float rhs = ((Float)values.get(rhsIndex)).floatValue();
                this.lhsMemory.putLong(0L, (long)TransformUtils.transformFromFloat((float)lhs));
                this.rhsMemory.putLong(0L, (long)TransformUtils.transformFromFloat((float)rhs));
                int byteCmp = this.byteComparison(8);
                if (byteCmp < 0) {
                    Assert.assertTrue((lhs < rhs ? 1 : 0) != 0);
                    continue;
                }
                if (byteCmp == 0) {
                    Assert.assertEquals((double)lhs, (double)rhs, (double)0.0);
                    continue;
                }
                Assert.assertTrue((lhs > rhs ? 1 : 0) != 0);
            }
        }
    }

    private int byteComparison(int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            byte rhsByte;
            byte lhsByte = this.lhsMemory.getByte(0L + (long)i);
            int cmp = (lhsByte & 0xFF) - ((rhsByte = this.rhsMemory.getByte(0L + (long)i)) & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

