/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.error;

import java.util.ArrayList;
import org.apache.druid.matchers.DruidMatchers;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;

public class ExceptionMatcher
extends DiagnosingMatcher<Throwable> {
    private final AllOf<Throwable> delegate;
    private final ArrayList<Matcher<? super Throwable>> matcherList;
    private final Class<? extends Throwable> clazz;

    public static ExceptionMatcher of(Class<? extends Throwable> clazz) {
        return new ExceptionMatcher(clazz);
    }

    public ExceptionMatcher(Class<? extends Throwable> clazz) {
        this.clazz = clazz;
        this.matcherList = new ArrayList();
        this.delegate = new AllOf(this.matcherList);
    }

    public ExceptionMatcher expectMessageIs(String s) {
        return this.expectMessage((Matcher<String>)Matchers.equalTo((Object)s));
    }

    public ExceptionMatcher expectMessageContains(String contains) {
        return this.expectMessage((Matcher<String>)Matchers.containsString((String)contains));
    }

    public ExceptionMatcher expectMessage(Matcher<String> messageMatcher) {
        this.matcherList.add(0, (Matcher<? super Throwable>)DruidMatchers.fn("message", Throwable::getMessage, messageMatcher));
        return this;
    }

    public ExceptionMatcher expectCause(Matcher<Throwable> causeMatcher) {
        this.matcherList.add(0, (Matcher<? super Throwable>)DruidMatchers.fn("cause", Throwable::getCause, causeMatcher));
        return this;
    }

    protected boolean matches(Object item, Description mismatchDescription) {
        return this.delegate.matches(item, mismatchDescription);
    }

    public void describeTo(Description description) {
        this.delegate.describeTo(description);
    }

    public <T> void assertThrowsAndMatches(ThrowingSupplier fn) {
        boolean thrown = false;
        try {
            fn.get();
        }
        catch (Throwable e) {
            if (this.clazz.isInstance(e)) {
                MatcherAssert.assertThat((Object)e, (Matcher)this);
                thrown = true;
            }
            throw new RuntimeException(e);
        }
        MatcherAssert.assertThat((Object)thrown, (Matcher)Matchers.is((Object)true));
    }

    public static interface ThrowingSupplier {
        public void get() throws Exception;
    }
}

