/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.semantic;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.druid.common.semantic.SemanticCreator;
import org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;

@RunWith(value=Parameterized.class)
public class SemanticCreatorUsageTest {
    private final Method method;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Set methodsAnnotatedWith = new Reflections("org.apache", new Scanner[]{new MethodAnnotationsScanner()}).getMethodsAnnotatedWith(SemanticCreator.class);
        for (Method method : methodsAnnotatedWith) {
            String simpleMethodName = method.getDeclaringClass().getSimpleName() + "#" + method.getName();
            params.add(new Object[]{simpleMethodName, method});
        }
        params.sort(Comparator.comparing(o -> (String)o[0]));
        return params;
    }

    public SemanticCreatorUsageTest(String simpleMethodName, Method method) {
        this.method = method;
    }

    @Test
    public void testPublic() {
        int modifiers = this.method.getModifiers();
        Assert.assertTrue((String)StringUtils.format((String)"method [%s] is not public", (Object[])new Object[]{this.method}), (boolean)Modifier.isPublic(modifiers));
    }

    @Test
    public void testReturnType() {
        Class<?> returnType = this.method.getReturnType();
        Assert.assertTrue((String)(returnType + " is not an interface; this method must return with an interface; "), (boolean)returnType.isInterface());
    }

    @Test
    public void testMethodName() {
        Class<?> returnType = this.method.getReturnType();
        String desiredMethodName = "to" + returnType.getSimpleName();
        Assert.assertEquals((String)("should be named as " + desiredMethodName), (Object)desiredMethodName, (Object)this.method.getName());
    }
}

