/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.path;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.hadoop.DatasourceIngestionSpec;
import org.apache.druid.indexer.hadoop.DatasourceInputFormat;
import org.apache.druid.indexer.hadoop.WindowedDataSegment;
import org.apache.druid.indexer.path.PathSpec;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.MultipleInputs;

public class DatasourcePathSpec
implements PathSpec {
    private static final Logger logger = new Logger(DatasourcePathSpec.class);
    public static final String TYPE = "dataSource";
    private final DatasourceIngestionSpec ingestionSpec;
    private final long maxSplitSize;
    private final List<WindowedDataSegment> segments;
    private final boolean useNewAggs;
    private static final String USE_NEW_AGGS_KEY = "useNewAggs";

    @JsonCreator
    public DatasourcePathSpec(@JsonProperty(value="segments") List<WindowedDataSegment> segments, @JsonProperty(value="ingestionSpec") DatasourceIngestionSpec spec, @JsonProperty(value="maxSplitSize") Long maxSplitSize, @JsonProperty(value="useNewAggs") boolean useNewAggs) {
        this.segments = segments;
        this.ingestionSpec = (DatasourceIngestionSpec)Preconditions.checkNotNull((Object)spec, (Object)"null ingestionSpec");
        this.maxSplitSize = maxSplitSize == null ? 0L : maxSplitSize;
        this.useNewAggs = useNewAggs;
    }

    @JsonProperty
    public boolean isUseNewAggs() {
        return this.useNewAggs;
    }

    @JsonProperty
    public List<WindowedDataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public DatasourceIngestionSpec getIngestionSpec() {
        return this.ingestionSpec;
    }

    @JsonProperty
    public long getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Override
    public Job addInputPaths(HadoopDruidIndexerConfig config, Job job) throws IOException {
        if (this.segments == null || this.segments.isEmpty()) {
            if (this.ingestionSpec.isIgnoreWhenNoSegments()) {
                logger.warn("No segments found for ingestionSpec [%s]", new Object[]{this.ingestionSpec});
                return job;
            }
            throw new ISE("No segments found for ingestion spec [%s]", new Object[]{this.ingestionSpec});
        }
        logger.info("Found total [%d] segments for [%s]  in interval [%s]", new Object[]{this.segments.size(), this.ingestionSpec.getDataSource(), this.ingestionSpec.getIntervals()});
        DatasourceIngestionSpec updatedIngestionSpec = this.ingestionSpec;
        if (updatedIngestionSpec.getDimensions() == null) {
            List dims;
            if (config.getParser().getParseSpec().getDimensionsSpec().hasCustomDimensions()) {
                dims = config.getParser().getParseSpec().getDimensionsSpec().getDimensionNames();
            } else {
                HashSet dimSet = Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform(this.segments, (Function)new Function<WindowedDataSegment, Iterable<String>>(){

                    public Iterable<String> apply(WindowedDataSegment dataSegment) {
                        return dataSegment.getSegment().getDimensions();
                    }
                })));
                dims = Lists.newArrayList((Iterable)Sets.difference((Set)dimSet, (Set)config.getParser().getParseSpec().getDimensionsSpec().getDimensionExclusions()));
            }
            updatedIngestionSpec = updatedIngestionSpec.withDimensions(dims);
        }
        if (updatedIngestionSpec.getMetrics() == null) {
            HashSet<String> metrics = new HashSet<String>();
            AggregatorFactory[] cols = config.getSchema().getDataSchema().getAggregators();
            if (cols != null) {
                if (this.useNewAggs) {
                    for (AggregatorFactory col : cols) {
                        metrics.addAll(col.requiredFields());
                    }
                } else {
                    for (AggregatorFactory col : cols) {
                        metrics.add(col.getName());
                    }
                }
            }
            updatedIngestionSpec = updatedIngestionSpec.withMetrics(Lists.newArrayList(metrics));
        }
        updatedIngestionSpec = updatedIngestionSpec.withQueryGranularity(config.getGranularitySpec().getQueryGranularity());
        updatedIngestionSpec = updatedIngestionSpec.withTransformSpec(config.getSchema().getDataSchema().getTransformSpec());
        DatasourceInputFormat.addDataSource(job.getConfiguration(), updatedIngestionSpec, this.segments, this.maxSplitSize);
        MultipleInputs.addInputPath((Job)job, (Path)new Path("/dummy/tobe/ignored"), DatasourceInputFormat.class);
        return job;
    }

    public static boolean checkIfReindexingAndIsUseAggEnabled(Map<String, Object> configuredPathSpec) {
        return TYPE.equals(configuredPathSpec.get("type")) && Boolean.parseBoolean(configuredPathSpec.getOrDefault(USE_NEW_AGGS_KEY, false).toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasourcePathSpec that = (DatasourcePathSpec)o;
        if (this.maxSplitSize != that.maxSplitSize) {
            return false;
        }
        if (!this.ingestionSpec.equals(that.ingestionSpec)) {
            return false;
        }
        return !(this.segments == null ? that.segments != null : !this.segments.equals(that.segments));
    }

    public int hashCode() {
        int result = this.ingestionSpec.hashCode();
        result = 31 * result + (int)(this.maxSplitSize ^ this.maxSplitSize >>> 32);
        result = 31 * result + (this.segments != null ? this.segments.hashCode() : 0);
        return result;
    }
}

