/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.retry.RetryUtils;
import java.io.IOException;

public class AWSClientUtil {
    public static boolean isClientExceptionRecoverable(AmazonClientException exception) {
        if (exception.getCause() instanceof IOException) {
            return true;
        }
        if (exception instanceof AmazonServiceException && "RequestTimeout".equals(((AmazonServiceException)exception).getErrorCode())) {
            return true;
        }
        if (RetryUtils.isRetryableServiceException((SdkBaseException)exception)) {
            return true;
        }
        if (RetryUtils.isThrottlingException((SdkBaseException)exception)) {
            return true;
        }
        return RetryUtils.isClockSkewError((SdkBaseException)exception);
    }
}

