/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.Validator;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class JsonConfigurator {
    private static final Logger log = new Logger(JsonConfigurator.class);
    private final ObjectMapper jsonMapper;
    private final Validator validator;

    @Inject
    public JsonConfigurator(ObjectMapper jsonMapper, Validator validator) {
        this.jsonMapper = jsonMapper;
        this.validator = validator;
    }

    public <T> T configurate(Properties props, String propertyPrefix, Class<T> clazz) throws ProvisionException {
        Object config;
        JsonConfigurator.verifyClazzIsConfigurable(this.jsonMapper, clazz);
        final String propertyBase = propertyPrefix.endsWith(".") ? propertyPrefix : propertyPrefix + ".";
        HashMap jsonMap = Maps.newHashMap();
        for (String prop : props.stringPropertyNames()) {
            Object value;
            if (!prop.startsWith(propertyBase)) continue;
            String propValue = props.getProperty(prop);
            try {
                String modifiedPropValue = propValue;
                if (!modifiedPropValue.startsWith("[") && !modifiedPropValue.startsWith("{")) {
                    modifiedPropValue = this.jsonMapper.writeValueAsString((Object)propValue);
                }
                value = this.jsonMapper.readValue(modifiedPropValue, Object.class);
            }
            catch (IOException e) {
                log.info((Throwable)e, "Unable to parse [%s]=[%s] as a json object, using as is.", new Object[]{prop, propValue});
                value = propValue;
            }
            JsonConfigurator.hieraricalPutValue(propertyPrefix, prop, prop.substring(propertyBase.length()), value, jsonMap);
        }
        try {
            config = this.jsonMapper.convertValue((Object)jsonMap, clazz);
        }
        catch (IllegalArgumentException e) {
            throw new ProvisionException(StringUtils.format((String)"Problem parsing object at prefix[%s]: %s.", (Object[])new Object[]{propertyPrefix, e.getMessage()}), (Throwable)e);
        }
        Set violations = this.validator.validate(config, new Class[0]);
        if (!violations.isEmpty()) {
            ArrayList messages = Lists.newArrayList();
            for (ConstraintViolation violation : violations) {
                StringBuilder path = new StringBuilder();
                try {
                    Class beanClazz = violation.getRootBeanClass();
                    for (Path.Node next : violation.getPropertyPath()) {
                        String pathPart;
                        if (next.getKind() != ElementKind.PROPERTY) continue;
                        String fieldName = next.getName();
                        Field theField = beanClazz.getDeclaredField(fieldName);
                        if (theField.getAnnotation(JacksonInject.class) != null) {
                            path = new StringBuilder(StringUtils.format((String)" -- Injected field[%s] not bound!?", (Object[])new Object[]{fieldName}));
                            break;
                        }
                        JsonProperty annotation = theField.getAnnotation(JsonProperty.class);
                        boolean noAnnotationValue = annotation == null || Strings.isNullOrEmpty((String)annotation.value());
                        String string = pathPart = noAnnotationValue ? fieldName : annotation.value();
                        if (path.length() == 0) {
                            path.append(pathPart);
                            continue;
                        }
                        path.append(".").append(pathPart);
                    }
                }
                catch (NoSuchFieldException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                messages.add(StringUtils.format((String)"%s - %s", (Object[])new Object[]{path.toString(), violation.getMessage()}));
            }
            throw new ProvisionException(Iterables.transform((Iterable)messages, (Function)new Function<String, Message>(){

                public Message apply(String input) {
                    return new Message(StringUtils.format((String)"%s%s", (Object[])new Object[]{propertyBase, input}));
                }
            }));
        }
        log.info("Loaded class[%s] from props[%s] as [%s]", new Object[]{clazz, propertyBase, config});
        return (T)config;
    }

    private static void hieraricalPutValue(String propertyPrefix, String originalProperty, String property, Object value, Map<String, Object> targetMap) {
        int dotIndex = property.indexOf(46);
        targetMap.put(property, value);
        if (dotIndex < 0) {
            return;
        }
        if (dotIndex == 0) {
            throw new ProvisionException(StringUtils.format((String)"Double dot in property: %s", (Object[])new Object[]{originalProperty}));
        }
        if (dotIndex == property.length() - 1) {
            throw new ProvisionException(StringUtils.format((String)"Dot at the end of property: %s", (Object[])new Object[]{originalProperty}));
        }
        String nestedKey = property.substring(0, dotIndex);
        Object nested = targetMap.computeIfAbsent(nestedKey, k -> new HashMap());
        if (!(nested instanceof Map)) {
            log.info("Skipping %s property: one of it's prefixes is also used as a property key. Prefix: %s", new Object[]{originalProperty, propertyPrefix});
            return;
        }
        Map nestedMap = (Map)nested;
        JsonConfigurator.hieraricalPutValue(propertyPrefix, originalProperty, property.substring(dotIndex + 1), value, nestedMap);
    }

    @VisibleForTesting
    public static <T> void verifyClazzIsConfigurable(ObjectMapper mapper, Class<T> clazz) {
        List beanDefs = mapper.getSerializationConfig().introspect(mapper.constructType(clazz)).findProperties();
        for (BeanPropertyDefinition beanDef : beanDefs) {
            AnnotatedField field = beanDef.getField();
            if (field != null && field.hasAnnotation(JsonProperty.class)) continue;
            throw new ProvisionException(StringUtils.format((String)"JsonConfigurator requires Jackson-annotated Config objects to have field annotations. %s doesn't", (Object[])new Object[]{clazz}));
        }
    }
}

