/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.remoteshell;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.ssh.param.SSHConnectionParam;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.ResourceType;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.DataSourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.remoteshell.RemoteExecutor;
import org.apache.dolphinscheduler.plugin.task.remoteshell.RemoteShellParameters;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteShellTask
extends AbstractTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteShellTask.class);
    static final String TASK_ID_PREFIX = "dolphinscheduler-remoteshell-";
    private RemoteShellParameters remoteShellParameters;
    private TaskExecutionContext taskExecutionContext;
    private RemoteExecutor remoteExecutor;
    private String taskId;

    public RemoteShellTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        log.info("shell task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.remoteShellParameters = (RemoteShellParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), RemoteShellParameters.class));
        if (!this.remoteShellParameters.checkParameters()) {
            throw new TaskException("sell task params is not valid");
        }
        this.taskId = this.taskExecutionContext.getAppIds();
        if (this.taskId == null) {
            this.taskId = TASK_ID_PREFIX + this.taskExecutionContext.getTaskInstanceId();
        }
        this.setAppIds(this.taskId);
        this.taskExecutionContext.setAppIds(this.taskId);
        this.initRemoteExecutor();
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try (RemoteExecutor executor = this.remoteExecutor;){
            String localFile = this.buildCommand();
            int exitCode = this.remoteExecutor.run(this.taskId, localFile);
            this.setExitStatusCode(exitCode);
            this.remoteShellParameters.dealOutParam(this.remoteExecutor.getTaskOutputParams());
        }
        catch (Exception e) {
            log.error("shell task error", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("Execute shell task error", (Throwable)e);
        }
    }

    public void cancel() throws TaskException {
        try {
            log.info("kill remote task {}", (Object)this.taskId);
            this.remoteExecutor.kill(this.taskId);
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    public String buildCommand() throws Exception {
        String fileName = String.format("%s/%s_node.%s", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId(), SystemUtils.IS_OS_WINDOWS ? "bat" : "sh");
        File file = new File(fileName);
        Path path = file.toPath();
        if (Files.exists(path, new LinkOption[0])) {
            log.warn("The command file: {} is already exist", (Object)path);
            return fileName;
        }
        String script = this.remoteShellParameters.getRawScript().replaceAll("\\r\\n", "\n");
        script = this.parseScript(script);
        String environment = this.taskExecutionContext.getEnvironmentConfig();
        if (environment != null) {
            environment = environment.replaceAll("\\r\\n", "\n");
            environment = environment.replace("\r\n", "\n");
            script = environment + "\n" + script;
        }
        script = String.format("#!/bin/bash\n", new Object[0]) + script;
        script = script + String.format("\necho %s$?", "DOLPHINSCHEDULER-REMOTE-SHELL-TASK-STATUS-");
        FileUtils.createFileWith755((Path)path);
        Files.write(path, script.getBytes(), StandardOpenOption.APPEND);
        log.info("raw script : {}", (Object)script);
        return fileName;
    }

    public AbstractParameters getParameters() {
        return this.remoteShellParameters;
    }

    private String parseScript(String script) {
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        return ParameterUtils.convertParameterPlaceholders((String)script, (Map)ParameterUtils.convert((Map)paramsMap));
    }

    public void initRemoteExecutor() {
        DataSourceParameters dbSource = (DataSourceParameters)this.taskExecutionContext.getResourceParametersHelper().getResourceParameters(ResourceType.DATASOURCE, Integer.valueOf(this.remoteShellParameters.getDatasource()));
        this.taskExecutionContext.getResourceParametersHelper().getResourceParameters(ResourceType.DATASOURCE, Integer.valueOf(this.remoteShellParameters.getDatasource()));
        SSHConnectionParam sshConnectionParam = (SSHConnectionParam)DataSourceUtils.buildConnectionParams((DbType)DbType.valueOf((String)this.remoteShellParameters.getType()), (String)dbSource.getConnectionParams());
        this.remoteExecutor = new RemoteExecutor(sshConnectionParam);
    }
}

