/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.pytorch;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;

public class PytorchParameters
extends AbstractParameters {
    private Boolean isCreateEnvironment = false;
    private String pythonPath = ".";
    private String script;
    private String scriptParams;
    private String pythonLauncher = "${PYTHON_LAUNCHER}";
    private String pythonEnvTool = "virtualenv";
    private String requirements = "requirements.txt";
    private String condaPythonVersion = "3.9";
    private List<ResourceInfo> resourceList;

    public List<ResourceInfo> getResourceFilesList() {
        return this.resourceList;
    }

    public boolean checkParameters() {
        return true;
    }

    public String getRequirementPath() {
        return this.getPossiblePath(this.requirements);
    }

    public String getPythonLauncher() {
        String command = this.pythonLauncher.isEmpty() ? "${PYTHON_LAUNCHER}" : this.pythonLauncher;
        return command;
    }

    public String getScriptPath() {
        return this.getPossiblePath(this.script);
    }

    private String getPossiblePath(String filePath) {
        String possiblePath = filePath;
        File sourceFile = new File(possiblePath);
        String newPath = Paths.get(this.pythonPath, possiblePath).toString();
        File newFile = new File(newPath);
        if (newFile.exists() && !sourceFile.exists()) {
            possiblePath = newPath;
        } else if (this.resourceList != null) {
            String newPathResource = StringUtils.removeStart((String)newPath, (String)"./");
            for (ResourceInfo resourceInfo : this.resourceList) {
                if (!resourceInfo.getResourceName().equals("/" + newPathResource)) continue;
                possiblePath = newPath;
                break;
            }
        }
        return possiblePath;
    }

    @Generated
    public PytorchParameters() {
    }

    @Generated
    public Boolean getIsCreateEnvironment() {
        return this.isCreateEnvironment;
    }

    @Generated
    public String getPythonPath() {
        return this.pythonPath;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public String getScriptParams() {
        return this.scriptParams;
    }

    @Generated
    public String getPythonEnvTool() {
        return this.pythonEnvTool;
    }

    @Generated
    public String getRequirements() {
        return this.requirements;
    }

    @Generated
    public String getCondaPythonVersion() {
        return this.condaPythonVersion;
    }

    @Generated
    public List<ResourceInfo> getResourceList() {
        return this.resourceList;
    }

    @Generated
    public void setIsCreateEnvironment(Boolean isCreateEnvironment) {
        this.isCreateEnvironment = isCreateEnvironment;
    }

    @Generated
    public void setPythonPath(String pythonPath) {
        this.pythonPath = pythonPath;
    }

    @Generated
    public void setScript(String script) {
        this.script = script;
    }

    @Generated
    public void setScriptParams(String scriptParams) {
        this.scriptParams = scriptParams;
    }

    @Generated
    public void setPythonLauncher(String pythonLauncher) {
        this.pythonLauncher = pythonLauncher;
    }

    @Generated
    public void setPythonEnvTool(String pythonEnvTool) {
        this.pythonEnvTool = pythonEnvTool;
    }

    @Generated
    public void setRequirements(String requirements) {
        this.requirements = requirements;
    }

    @Generated
    public void setCondaPythonVersion(String condaPythonVersion) {
        this.condaPythonVersion = condaPythonVersion;
    }

    @Generated
    public void setResourceList(List<ResourceInfo> resourceList) {
        this.resourceList = resourceList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PytorchParameters)) {
            return false;
        }
        PytorchParameters other = (PytorchParameters)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$isCreateEnvironment = this.getIsCreateEnvironment();
        Boolean other$isCreateEnvironment = other.getIsCreateEnvironment();
        if (this$isCreateEnvironment == null ? other$isCreateEnvironment != null : !((Object)this$isCreateEnvironment).equals(other$isCreateEnvironment)) {
            return false;
        }
        String this$pythonPath = this.getPythonPath();
        String other$pythonPath = other.getPythonPath();
        if (this$pythonPath == null ? other$pythonPath != null : !this$pythonPath.equals(other$pythonPath)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        String this$scriptParams = this.getScriptParams();
        String other$scriptParams = other.getScriptParams();
        if (this$scriptParams == null ? other$scriptParams != null : !this$scriptParams.equals(other$scriptParams)) {
            return false;
        }
        String this$pythonLauncher = this.getPythonLauncher();
        String other$pythonLauncher = other.getPythonLauncher();
        if (this$pythonLauncher == null ? other$pythonLauncher != null : !this$pythonLauncher.equals(other$pythonLauncher)) {
            return false;
        }
        String this$pythonEnvTool = this.getPythonEnvTool();
        String other$pythonEnvTool = other.getPythonEnvTool();
        if (this$pythonEnvTool == null ? other$pythonEnvTool != null : !this$pythonEnvTool.equals(other$pythonEnvTool)) {
            return false;
        }
        String this$requirements = this.getRequirements();
        String other$requirements = other.getRequirements();
        if (this$requirements == null ? other$requirements != null : !this$requirements.equals(other$requirements)) {
            return false;
        }
        String this$condaPythonVersion = this.getCondaPythonVersion();
        String other$condaPythonVersion = other.getCondaPythonVersion();
        if (this$condaPythonVersion == null ? other$condaPythonVersion != null : !this$condaPythonVersion.equals(other$condaPythonVersion)) {
            return false;
        }
        List<ResourceInfo> this$resourceList = this.getResourceList();
        List<ResourceInfo> other$resourceList = other.getResourceList();
        return !(this$resourceList == null ? other$resourceList != null : !((Object)this$resourceList).equals(other$resourceList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PytorchParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isCreateEnvironment = this.getIsCreateEnvironment();
        result = result * 59 + ($isCreateEnvironment == null ? 43 : ((Object)$isCreateEnvironment).hashCode());
        String $pythonPath = this.getPythonPath();
        result = result * 59 + ($pythonPath == null ? 43 : $pythonPath.hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        String $scriptParams = this.getScriptParams();
        result = result * 59 + ($scriptParams == null ? 43 : $scriptParams.hashCode());
        String $pythonLauncher = this.getPythonLauncher();
        result = result * 59 + ($pythonLauncher == null ? 43 : $pythonLauncher.hashCode());
        String $pythonEnvTool = this.getPythonEnvTool();
        result = result * 59 + ($pythonEnvTool == null ? 43 : $pythonEnvTool.hashCode());
        String $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : $requirements.hashCode());
        String $condaPythonVersion = this.getCondaPythonVersion();
        result = result * 59 + ($condaPythonVersion == null ? 43 : $condaPythonVersion.hashCode());
        List<ResourceInfo> $resourceList = this.getResourceList();
        result = result * 59 + ($resourceList == null ? 43 : ((Object)$resourceList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PytorchParameters(isCreateEnvironment=" + this.getIsCreateEnvironment() + ", pythonPath=" + this.getPythonPath() + ", script=" + this.getScript() + ", scriptParams=" + this.getScriptParams() + ", pythonLauncher=" + this.getPythonLauncher() + ", pythonEnvTool=" + this.getPythonEnvTool() + ", requirements=" + this.getRequirements() + ", condaPythonVersion=" + this.getCondaPythonVersion() + ", resourceList=" + this.getResourceList() + ")";
    }
}

