/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.k8s;

import io.fabric8.kubernetes.api.model.NodeSelectorRequirement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.k8s.param.K8sConnectionParam;
import org.apache.dolphinscheduler.plugin.task.api.K8sTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.k8s.AbstractK8sTask;
import org.apache.dolphinscheduler.plugin.task.api.k8s.K8sTaskMainParameters;
import org.apache.dolphinscheduler.plugin.task.api.model.Label;
import org.apache.dolphinscheduler.plugin.task.api.model.NodeSelectorExpression;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.K8sTaskParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sTask
extends AbstractK8sTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sTask.class);
    private final TaskExecutionContext taskExecutionContext;
    private K8sTaskParameters k8sTaskParameters;
    private K8sTaskExecutionContext k8sTaskExecutionContext;
    private K8sConnectionParam k8sConnectionParam;

    public K8sTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.taskExecutionContext = taskRequest;
    }

    public void init() {
        String taskParams = this.taskExecutionContext.getTaskParams();
        this.k8sTaskParameters = (K8sTaskParameters)JSONUtils.parseObject((String)taskParams, K8sTaskParameters.class);
        if (this.k8sTaskParameters == null || !this.k8sTaskParameters.checkParameters()) {
            throw new TaskException("K8S task params is not valid");
        }
        this.k8sTaskExecutionContext = this.k8sTaskParameters.generateK8sTaskExecutionContext(this.taskExecutionContext.getResourceParametersHelper(), this.k8sTaskParameters.getDatasource());
        this.k8sConnectionParam = (K8sConnectionParam)DataSourceUtils.buildConnectionParams((DbType)DbType.valueOf((String)this.k8sTaskParameters.getType()), (String)this.k8sTaskExecutionContext.getConnectionParams());
        String kubeConfig = this.k8sConnectionParam.getKubeConfig();
        this.k8sTaskParameters.setNamespace(this.k8sConnectionParam.getNamespace());
        this.k8sTaskParameters.setKubeConfig(kubeConfig);
        this.k8sTaskExecutionContext.setConfigYaml(kubeConfig);
        this.taskRequest.setK8sTaskExecutionContext(this.k8sTaskExecutionContext);
        log.info("Initialize k8s task params:{}", (Object)JSONUtils.toPrettyJsonString((Object)this.k8sTaskParameters));
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public AbstractParameters getParameters() {
        return this.k8sTaskParameters;
    }

    protected String buildCommand() {
        K8sTaskMainParameters k8sTaskMainParameters = new K8sTaskMainParameters();
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        String namespaceName = this.k8sTaskParameters.getNamespace();
        k8sTaskMainParameters.setImage(this.k8sTaskParameters.getImage());
        k8sTaskMainParameters.setPullSecret(this.k8sTaskParameters.getPullSecret());
        k8sTaskMainParameters.setNamespaceName(namespaceName);
        k8sTaskMainParameters.setMinCpuCores(this.k8sTaskParameters.getMinCpuCores());
        k8sTaskMainParameters.setMinMemorySpace(this.k8sTaskParameters.getMinMemorySpace());
        k8sTaskMainParameters.setParamsMap(ParameterUtils.convert((Map)paramsMap));
        k8sTaskMainParameters.setLabelMap(this.convertToLabelMap(this.k8sTaskParameters.getCustomizedLabels()));
        k8sTaskMainParameters.setNodeSelectorRequirements(this.convertToNodeSelectorRequirements(this.k8sTaskParameters.getNodeSelectors()));
        k8sTaskMainParameters.setCommand(this.k8sTaskParameters.getCommand());
        k8sTaskMainParameters.setArgs(this.k8sTaskParameters.getArgs());
        k8sTaskMainParameters.setImagePullPolicy(this.k8sTaskParameters.getImagePullPolicy());
        return JSONUtils.toJsonString((Object)k8sTaskMainParameters);
    }

    protected void dealOutParam(Map<String, String> taskOutputParams) {
        this.k8sTaskParameters.dealOutParam(taskOutputParams);
    }

    public List<NodeSelectorRequirement> convertToNodeSelectorRequirements(List<NodeSelectorExpression> expressions) {
        if (CollectionUtils.isEmpty(expressions)) {
            return Collections.emptyList();
        }
        return expressions.stream().map(expression -> new NodeSelectorRequirement(expression.getKey(), expression.getOperator(), StringUtils.isEmpty((CharSequence)expression.getValues()) ? Collections.emptyList() : Arrays.asList(expression.getValues().trim().split("\\s*,\\s*")))).collect(Collectors.toList());
    }

    public Map<String, String> convertToLabelMap(List<Label> labels) {
        if (CollectionUtils.isEmpty(labels)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labelMap = new HashMap<String, String>();
        labels.forEach(label -> labelMap.put(label.getLabel(), label.getValue()));
        return labelMap;
    }
}

