/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.dvc;

import java.util.ArrayList;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.dvc.DvcParameters;

public class DvcTask
extends AbstractTask {
    private DvcParameters parameters;
    private ShellCommandExecutor shellCommandExecutor;
    private TaskExecutionContext taskExecutionContext;

    public DvcTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((DvcTask)this).logHandle(arg_0), taskExecutionContext, this.logger);
    }

    public void init() {
        this.logger.info("dvc task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.parameters = (DvcParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), DvcParameters.class));
        if (!this.parameters.checkParameters()) {
            throw new RuntimeException("dvc task params is not valid");
        }
    }

    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            String command = this.buildCommand();
            TaskResponse commandExecuteResult = this.shellCommandExecutor.run(command);
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setProcessId(commandExecuteResult.getProcessId());
            this.parameters.dealOutParam(this.shellCommandExecutor.getVarPool());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("The current DvcTask has been interrupted", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("The current DvcTask has been interrupted", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("dvc task error", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("Execute dvc task failed", (Throwable)e);
        }
    }

    public void cancel() throws TaskException {
        try {
            this.shellCommandExecutor.cancelApplication();
        }
        catch (Exception e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    public String buildCommand() {
        String command = "";
        String taskType = this.parameters.getDvcTaskType();
        if (taskType.equals("Upload")) {
            command = this.buildUploadCommond();
        } else if (taskType.equals("Download")) {
            command = this.buildDownCommond();
        } else if (taskType.equals("Init DVC")) {
            command = this.buildInitDvcCommond();
        }
        this.logger.info("Run DVC task with command: \n{}", (Object)command);
        return command;
    }

    private String buildUploadCommond() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.format("which dvc || { echo \"dvc does not exist\"; exit 1; }; DVC_REPO=%s", this.parameters.getDvcRepository()));
        args.add(String.format("DVC_DATA_PATH=%s", this.parameters.getDvcLoadSaveDataPath()));
        args.add(String.format("DVC_DATA_LOCATION=%s", this.parameters.getDvcDataLocation()));
        args.add(String.format("DVC_VERSION=%s", this.parameters.getDvcVersion()));
        args.add(String.format("DVC_MESSAGE=\"%s\"", this.parameters.getDvcMessage()));
        args.add("git clone $DVC_REPO dvc-repository; cd dvc-repository; pwd");
        args.add("dvc config core.autostage true --local || exit 1");
        args.add("dvc add $DVC_DATA_PATH -v -o $DVC_DATA_LOCATION --to-remote || exit 1");
        args.add("git commit -am \"$DVC_MESSAGE\"\ngit tag \"$DVC_VERSION\" -m \"$DVC_MESSAGE\"\ngit push --all\ngit push --tags");
        String command = String.join((CharSequence)"\n", args);
        return command;
    }

    private String buildDownCommond() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.format("which dvc || { echo \"dvc does not exist\"; exit 1; }; DVC_REPO=%s", this.parameters.getDvcRepository()));
        args.add(String.format("DVC_DATA_PATH=%s", this.parameters.getDvcLoadSaveDataPath()));
        args.add(String.format("DVC_DATA_LOCATION=%s", this.parameters.getDvcDataLocation()));
        args.add(String.format("DVC_VERSION=%s", this.parameters.getDvcVersion()));
        args.add("dvc get $DVC_REPO $DVC_DATA_LOCATION -o $DVC_DATA_PATH -v --rev $DVC_VERSION");
        String command = String.join((CharSequence)"\n", args);
        return command;
    }

    private String buildInitDvcCommond() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.format("which dvc || { echo \"dvc does not exist\"; exit 1; }; DVC_REPO=%s", this.parameters.getDvcRepository()));
        args.add("git clone $DVC_REPO dvc-repository; cd dvc-repository; pwd");
        args.add("dvc init || exit 1");
        args.add(String.format("dvc remote add origin %s -d", this.parameters.getDvcStoreUrl()));
        args.add("git commit -am \"init dvc project and add remote\"; git push");
        String command = String.join((CharSequence)"\n", args);
        return command;
    }

    public AbstractParameters getParameters() {
        return this.parameters;
    }
}

