/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.datasync;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.datasync.DatasyncParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.DataSyncClientBuilder;
import software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.CancelTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.CreateTaskRequest;
import software.amazon.awssdk.services.datasync.model.CreateTaskResponse;
import software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.DescribeTaskRequest;
import software.amazon.awssdk.services.datasync.model.DescribeTaskResponse;
import software.amazon.awssdk.services.datasync.model.FilterRule;
import software.amazon.awssdk.services.datasync.model.Options;
import software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest;
import software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.services.datasync.model.TaskExecutionStatus;
import software.amazon.awssdk.services.datasync.model.TaskSchedule;
import software.amazon.awssdk.services.datasync.model.TaskStatus;

public class DatasyncHook {
    public static TaskExecutionStatus[] doneStatus = new TaskExecutionStatus[]{TaskExecutionStatus.ERROR, TaskExecutionStatus.SUCCESS, TaskExecutionStatus.UNKNOWN_TO_SDK_VERSION};
    public static TaskStatus[] taskFinishFlags = new TaskStatus[]{TaskStatus.UNAVAILABLE, TaskStatus.UNKNOWN_TO_SDK_VERSION};
    protected final Logger log = LoggerFactory.getLogger(DatasyncHook.class);
    private DataSyncClient client = DatasyncHook.createClient();
    private String taskArn;
    private String taskExecArn;

    protected static DataSyncClient createClient() {
        String awsAccessKeyId = PropertyUtils.getString((String)"resource.aws.access.key.id");
        String awsSecretAccessKey = PropertyUtils.getString((String)"resource.aws.secret.access.key");
        String awsRegion = PropertyUtils.getString((String)"resource.aws.region");
        AwsBasicCredentials basicAWSCredentials = AwsBasicCredentials.create((String)awsAccessKeyId, (String)awsSecretAccessKey);
        StaticCredentialsProvider awsCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)basicAWSCredentials);
        return (DataSyncClient)((DataSyncClientBuilder)((DataSyncClientBuilder)DataSyncClient.builder().region(Region.of((String)awsRegion))).credentialsProvider((AwsCredentialsProvider)awsCredentialsProvider)).build();
    }

    public Boolean createDatasyncTask(DatasyncParameters parameters) {
        this.log.info("createDatasyncTask ......");
        CreateTaskRequest.Builder builder = CreateTaskRequest.builder().name(parameters.getName()).sourceLocationArn(parameters.getSourceLocationArn()).destinationLocationArn(parameters.getDestinationLocationArn());
        String cloudWatchLogGroupArn = parameters.getCloudWatchLogGroupArn();
        if (StringUtils.isNotEmpty((CharSequence)cloudWatchLogGroupArn)) {
            builder.cloudWatchLogGroupArn(cloudWatchLogGroupArn);
        }
        DatasyncHook.castParamPropertyPackage(parameters, builder);
        CreateTaskResponse task = this.client.createTask((CreateTaskRequest)builder.build());
        if (task.sdkHttpResponse().isSuccessful()) {
            this.taskArn = task.taskArn();
        }
        this.log.info("finished createDatasyncTask ......");
        return this.doubleCheckTaskStatus(TaskStatus.AVAILABLE, taskFinishFlags);
    }

    public Boolean startDatasyncTask() {
        this.log.info("startDatasyncTask ......");
        StartTaskExecutionRequest start = (StartTaskExecutionRequest)StartTaskExecutionRequest.builder().taskArn(this.taskArn).build();
        StartTaskExecutionResponse response = this.client.startTaskExecution(start);
        if (response.sdkHttpResponse().isSuccessful()) {
            this.taskExecArn = response.taskExecutionArn();
        }
        return this.doubleCheckExecStatus(TaskExecutionStatus.LAUNCHING, doneStatus);
    }

    public Boolean cancelDatasyncTask() {
        this.log.info("cancelTask ......");
        CancelTaskExecutionRequest cancel = (CancelTaskExecutionRequest)CancelTaskExecutionRequest.builder().taskExecutionArn(this.taskExecArn).build();
        CancelTaskExecutionResponse response = this.client.cancelTaskExecution(cancel);
        if (response.sdkHttpResponse().isSuccessful()) {
            return true;
        }
        return false;
    }

    public TaskStatus queryDatasyncTaskStatus() {
        this.log.info("queryDatasyncTaskStatus ......");
        DescribeTaskRequest request = (DescribeTaskRequest)DescribeTaskRequest.builder().taskArn(this.taskArn).build();
        DescribeTaskResponse describe = this.client.describeTask(request);
        if (describe.sdkHttpResponse().isSuccessful()) {
            this.log.info("queryDatasyncTaskStatus ......{}", (Object)describe.statusAsString());
            return describe.status();
        }
        return null;
    }

    public TaskExecutionStatus queryDatasyncTaskExecStatus() {
        this.log.info("queryDatasyncTaskExecStatus ......");
        DescribeTaskExecutionRequest request = (DescribeTaskExecutionRequest)DescribeTaskExecutionRequest.builder().taskExecutionArn(this.taskExecArn).build();
        DescribeTaskExecutionResponse describe = this.client.describeTaskExecution(request);
        if (describe.sdkHttpResponse().isSuccessful()) {
            this.log.info("queryDatasyncTaskExecStatus ......{}", (Object)describe.statusAsString());
            return describe.status();
        }
        return null;
    }

    public Boolean doubleCheckTaskStatus(TaskStatus exceptStatus, TaskStatus[] stopStatus) {
        List<TaskStatus> stopStatusSet = Arrays.asList(stopStatus);
        int maxRetry = 5;
        while (maxRetry > 0) {
            TaskStatus status = this.queryDatasyncTaskStatus();
            if (status == null) {
                --maxRetry;
                continue;
            }
            if (exceptStatus.equals((Object)status)) {
                this.log.info("double check success");
                return true;
            }
            if (!stopStatusSet.contains(status)) continue;
            break;
        }
        this.log.warn("double check error");
        return false;
    }

    public Boolean doubleCheckExecStatus(TaskExecutionStatus exceptStatus, TaskExecutionStatus[] stopStatus) {
        List<TaskExecutionStatus> stopStatusSet = Arrays.asList(stopStatus);
        int maxRetry = 5;
        while (maxRetry > 0) {
            TaskExecutionStatus status = this.queryDatasyncTaskExecStatus();
            if (status == null) {
                --maxRetry;
                continue;
            }
            if (exceptStatus.equals((Object)status)) {
                this.log.info("double check success");
                return true;
            }
            if (!stopStatusSet.contains(status)) continue;
            break;
        }
        this.log.warn("double check error");
        return false;
    }

    public Boolean doubleCheckFinishStatus(TaskExecutionStatus expectStatus, TaskExecutionStatus[] stopStatus) {
        List<TaskExecutionStatus> stopStatusSet = Arrays.asList(stopStatus);
        while (true) {
            TaskExecutionStatus status;
            if ((status = this.queryDatasyncTaskExecStatus()) == null) {
                continue;
            }
            if (expectStatus.equals((Object)status)) {
                this.log.info("double check finish status success");
                return true;
            }
            if (stopStatusSet.contains(status)) break;
            this.log.debug("wait 10s to recheck finish status....");
            Thread.sleep(10000L);
        }
        this.log.warn("double check error");
        return false;
    }

    private static void castParamPropertyPackage(DatasyncParameters parameters, CreateTaskRequest.Builder builder) {
        List<DatasyncParameters.FilterRule> includes;
        List<DatasyncParameters.FilterRule> excludes;
        DatasyncParameters.Options options;
        List<DatasyncParameters.TagListEntry> tags = parameters.getTags();
        if (tags != null && tags.size() > 0) {
            List collect = tags.stream().map(e -> (TagListEntry)TagListEntry.builder().key(e.getKey()).value(e.getValue()).build()).collect(Collectors.toList());
            builder.tags(collect);
        }
        if ((options = parameters.getOptions()) != null) {
            Options option = (Options)Options.builder().build();
            try {
                BeanUtils.copyProperties((Object)option, (Object)options);
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
            catch (InvocationTargetException e3) {
                throw new RuntimeException(e3);
            }
            builder.options(option);
        }
        if ((excludes = parameters.getExcludes()) != null && excludes.size() > 0) {
            List collect = excludes.stream().map(e -> (FilterRule)FilterRule.builder().filterType(e.getFilterType()).value(e.getValue()).build()).collect(Collectors.toList());
            builder.excludes(collect);
        }
        if ((includes = parameters.getIncludes()) != null && includes.size() > 0) {
            List collect = includes.stream().map(e -> (FilterRule)FilterRule.builder().filterType(e.getFilterType()).value(e.getValue()).build()).collect(Collectors.toList());
            builder.excludes(collect);
        }
        if (parameters.getSchedule() != null) {
            builder.schedule((TaskSchedule)TaskSchedule.builder().scheduleExpression(parameters.getSchedule().getScheduleExpression()).build());
        }
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public DataSyncClient getClient() {
        return this.client;
    }

    @Generated
    public String getTaskArn() {
        return this.taskArn;
    }

    @Generated
    public String getTaskExecArn() {
        return this.taskExecArn;
    }

    @Generated
    public void setClient(DataSyncClient client) {
        this.client = client;
    }

    @Generated
    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    @Generated
    public void setTaskExecArn(String taskExecArn) {
        this.taskExecArn = taskExecArn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatasyncHook)) {
            return false;
        }
        DatasyncHook other = (DatasyncHook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        DataSyncClient this$client = this.getClient();
        DataSyncClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$taskArn = this.getTaskArn();
        String other$taskArn = other.getTaskArn();
        if (this$taskArn == null ? other$taskArn != null : !this$taskArn.equals(other$taskArn)) {
            return false;
        }
        String this$taskExecArn = this.getTaskExecArn();
        String other$taskExecArn = other.getTaskExecArn();
        return !(this$taskExecArn == null ? other$taskExecArn != null : !this$taskExecArn.equals(other$taskExecArn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DatasyncHook;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        DataSyncClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $taskArn = this.getTaskArn();
        result = result * 59 + ($taskArn == null ? 43 : $taskArn.hashCode());
        String $taskExecArn = this.getTaskExecArn();
        result = result * 59 + ($taskExecArn == null ? 43 : $taskExecArn.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DatasyncHook(log=" + this.getLog() + ", client=" + this.getClient() + ", taskArn=" + this.getTaskArn() + ", taskExecArn=" + this.getTaskExecArn() + ")";
    }
}

